/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class ToastDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create("ShowToast", "Toast created but not shown", "`Toast.makeText()` creates a `Toast` but does **not** show it. You must call `show()` on the resulting object to actually make the `Toast` appear.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(ToastDetector.class, Scope.JAVA_FILE_SCOPE)).setAndroidSpecific(true);

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("makeText");
    }

    @Override
    public void visitMethodCall(JavaContext context2, UCallExpression call, PsiMethod method) {
        UElement surroundingDeclaration;
        UExpression duration;
        if (!context2.getEvaluator().isMemberInClass((PsiMember)method, "android.widget.Toast")) {
            return;
        }
        List args = call.getValueArguments();
        if (args.size() == 3 && (duration = (UExpression)args.get(2)) instanceof ULiteralExpression) {
            context2.report(ISSUE, (UElement)duration, context2.getLocation((UElement)duration), "Expected duration `Toast.LENGTH_SHORT` or `Toast.LENGTH_LONG`, a custom duration value is not supported");
        }
        if ((surroundingDeclaration = UastUtils.getParentOfType((UElement)call, (boolean)true, UMethod.class, (Class[])new Class[]{UBlockExpression.class, ULambdaExpression.class})) == null) {
            return;
        }
        UElement parent = call.getUastParent();
        if (parent instanceof UMethod || parent instanceof UReferenceExpression && parent.getUastParent() instanceof UMethod) {
            return;
        }
        ShowFinder finder = new ShowFinder(call);
        surroundingDeclaration.accept((UastVisitor)finder);
        if (!finder.isShowCalled()) {
            context2.report(ISSUE, (UElement)call, context2.getCallLocation(call, true, false), "Toast created but not shown: did you forget to call `show()` ?");
        }
    }

    private static class ShowFinder
    extends AbstractUastVisitor {
        private final UCallExpression target;
        private boolean found;
        private boolean seenTarget;

        private ShowFinder(UCallExpression target) {
            this.target = target;
        }

        public boolean visitCallExpression(UCallExpression node) {
            if (node == this.target || node.getPsi() != null && node.getPsi() == this.target.getPsi()) {
                this.seenTarget = true;
            } else if ((this.seenTarget || this.target.equals(node.getReceiver())) && "show".equals(Lint.getMethodName(node))) {
                this.found = true;
            }
            return super.visitCallExpression(node);
        }

        public boolean visitReturnExpression(UReturnExpression node) {
            if (UastUtils.isChildOf((UElement)this.target, (UElement)node.getReturnExpression(), (boolean)true)) {
                this.found = true;
            }
            return super.visitReturnExpression(node);
        }

        boolean isShowCalled() {
            return this.found;
        }
    }
}

