/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.TypoLookup;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.StringHelper;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypoDetector
extends ResourceXmlDetector {
    private TypoLookup mLookup;
    private String mLastLanguage;
    private String mLastRegion;
    private String mLanguage;
    private String mRegion;
    public static final Issue ISSUE = Issue.create("Typos", "Spelling error", "This check looks through the string definitions, and if it finds any words that look like likely misspellings, they are flagged.", Category.MESSAGES, 7, Severity.WARNING, new Implementation(TypoDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES;
    }

    private void initLocale(XmlContext context2) {
        this.mLanguage = null;
        this.mRegion = null;
        LocaleQualifier locale = Lint.getLocale(context2);
        if (locale != null && locale.hasLanguage()) {
            this.mLanguage = locale.getLanguage();
            this.mRegion = locale.hasRegion() ? locale.getRegion() : null;
        }
    }

    @Override
    public void beforeCheckFile(Context context2) {
        this.initLocale((XmlContext)context2);
        if (this.mLanguage == null) {
            this.mLanguage = "en";
        }
        if (!Objects.equal((Object)this.mLastLanguage, (Object)this.mLanguage) || !Objects.equal((Object)this.mLastRegion, (Object)this.mRegion)) {
            this.mLookup = TypoLookup.Companion.get(context2.getClient(), this.mLanguage, this.mRegion);
            this.mLastLanguage = this.mLanguage;
            this.mLastRegion = this.mRegion;
        }
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("string", "string-array", "plurals");
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        if (this.mLookup == null) {
            return;
        }
        this.visit(context2, element, element);
    }

    private void visit(XmlContext context2, Element parent, Node node) {
        if (node.getNodeType() == 3) {
            this.check(context2, parent, node, node.getNodeValue());
        } else {
            NodeList children = node.getChildNodes();
            int n = children.getLength();
            for (int i = 0; i < n; ++i) {
                this.visit(context2, parent, children.item(i));
            }
        }
    }

    private void check(XmlContext context2, Element element, Node node, String text) {
        char c;
        int index;
        int max = text.length();
        int lastWordBegin = -1;
        int lastWordEnd = -1;
        boolean checkedTypos = false;
        for (index = 0; index < max; ++index) {
            c = text.charAt(index);
            if (Character.isWhitespace(c)) continue;
            if (c != '@' && c != '?') break;
            return;
        }
        while (index < max) {
            char c2;
            while (index < max) {
                c = text.charAt(index);
                if (c == '\\') {
                    ++index;
                } else if (Character.isLetter(c)) break;
                ++index;
            }
            if (index >= max) {
                return;
            }
            int begin = index;
            while (index < max && (c2 = text.charAt(index)) != '\\' && (Character.isLetter(c2) || c2 == '_')) {
                if (text.charAt(index) >= '\u0080') {
                    byte[] utf8Text;
                    if (checkedTypos) {
                        utf8Text = text.substring(begin).getBytes(Charsets.UTF_8);
                        this.check(context2, element, node, utf8Text, 0, utf8Text.length, text, begin);
                    } else {
                        utf8Text = text.getBytes(Charsets.UTF_8);
                        this.check(context2, element, node, utf8Text, 0, utf8Text.length, text, 0);
                    }
                    return;
                }
                ++index;
            }
            int end = ++index;
            checkedTypos = true;
            assert (this.mLookup != null);
            List<String> replacements = this.mLookup.getTypos(text, begin, end);
            if (replacements != null && TypoDetector.isTranslatable(element)) {
                this.reportTypo(context2, node, text, begin, replacements);
            }
            this.checkRepeatedWords(context2, element, node, text, lastWordBegin, lastWordEnd, begin, end);
            lastWordBegin = begin;
            lastWordEnd = end;
            index = end + 1;
        }
    }

    private void checkRepeatedWords(XmlContext context2, Element element, Node node, String text, int lastWordBegin, int lastWordEnd, int begin, int end) {
        if (lastWordBegin != -1 && end - begin == lastWordEnd - lastWordBegin && end - begin > 1) {
            boolean different = false;
            int i = lastWordBegin;
            int j = begin;
            while (i < lastWordEnd) {
                if (text.charAt(i) != text.charAt(j)) {
                    different = true;
                    break;
                }
                ++i;
                ++j;
            }
            if (!different && TypoDetector.onlySpace(text, lastWordEnd, begin) && TypoDetector.isTranslatable(element)) {
                this.reportRepeatedWord(context2, node, text, lastWordBegin, begin, end);
            }
        }
    }

    private static boolean onlySpace(String text, int fromInclusive, int toExclusive) {
        for (int i = fromInclusive; i < toExclusive; ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void check(XmlContext context2, Element element, Node node, byte[] utf8Text, int byteStart, int byteEnd, String text, int charStart) {
        int lastWordBegin = -1;
        int lastWordEnd = -1;
        int index = byteStart;
        while (index < byteEnd) {
            int end;
            List<String> replacements;
            while (index < byteEnd) {
                byte b = utf8Text[index];
                if (b == 92) {
                    ++charStart;
                    if (++index < byteEnd) {
                        b = utf8Text[index];
                    }
                } else if (TypoLookup.isLetter(b)) break;
                ++index;
                if ((b & 0x80) != 0 && (b & 0xC0) != 192) continue;
                ++charStart;
            }
            if (index >= byteEnd) {
                return;
            }
            int charEnd = charStart;
            int begin = index;
            while (index < byteEnd) {
                byte b = utf8Text[index];
                if (b == 92) {
                    ++charEnd;
                    if (++index >= byteEnd || ((b = utf8Text[index++]) & 0x80) != 0 && (b & 0xC0) != 192) break;
                    ++charEnd;
                    break;
                }
                if (!TypoLookup.isLetter(b)) break;
                ++index;
                if ((b & 0x80) != 0 && (b & 0xC0) != 192) continue;
                ++charEnd;
            }
            if ((replacements = this.mLookup.getTypos(utf8Text, begin, end = index)) != null && TypoDetector.isTranslatable(element)) {
                this.reportTypo(context2, node, text, charStart, replacements);
            }
            this.checkRepeatedWords(context2, element, node, text, lastWordBegin, lastWordEnd, charStart, charEnd);
            lastWordBegin = charStart;
            lastWordEnd = charEnd;
            charStart = charEnd;
        }
    }

    private static boolean isTranslatable(Element element) {
        Attr translatable = element.getAttributeNode("translatable");
        return translatable == null || Boolean.valueOf(translatable.getValue()) != false;
    }

    private void reportTypo(XmlContext context2, Node node, String text, int begin, List<String> replacements) {
        String message2;
        if (replacements.size() < 2) {
            return;
        }
        String typo = replacements.get(0);
        String word = text.substring(begin, begin + typo.length());
        String first = null;
        LintFix.GroupBuilder fixBuilder = this.fix().alternatives();
        boolean isCapitalized = Character.isUpperCase(word.charAt(0));
        StringBuilder sb = new StringBuilder(40);
        int n = replacements.size();
        for (int i = 1; i < n; ++i) {
            String replacement = replacements.get(i);
            if (first == null) {
                first = replacement;
            }
            if (sb.length() > 0) {
                sb.append(" or ");
            }
            sb.append('\"');
            if (isCapitalized) {
                replacement = StringHelper.capitalize((String)replacement);
            }
            sb.append(replacement);
            fixBuilder.add(this.fix().name("Replace with \"" + replacement + "\"").replace().text(word).with(replacement).build());
            sb.append('\"');
        }
        LintFix fix = fixBuilder.build();
        if (first != null && first.equalsIgnoreCase(word)) {
            if (first.equals(word)) {
                return;
            }
            message2 = String.format("\"%1$s\" is usually capitalized as \"%2$s\"", word, first);
        } else {
            message2 = String.format("\"%1$s\" is a common misspelling; did you mean %2$s ?", word, sb.toString());
        }
        int end = begin + word.length();
        context2.report(ISSUE, node, context2.getLocation(node, begin, end), message2, fix);
    }

    private void reportRepeatedWord(XmlContext context2, Node node, String text, int lastWordBegin, int begin, int end) {
        String word = text.substring(begin, end);
        if (TypoDetector.isAllowed(word)) {
            return;
        }
        String message2 = String.format("Repeated word \"%1$s\" in message: possible typo", word);
        String replace = lastWordBegin > 1 && text.charAt(lastWordBegin - 1) == ' ' ? ' ' + word : (end < text.length() - 1 && text.charAt(end) == ' ' ? word + ' ' : word);
        LintFix fix = this.fix().name("Delete repeated word").replace().text(replace).with("").build();
        Location location = context2.getLocation(node, lastWordBegin, end);
        context2.report(ISSUE, node, location, message2, fix);
    }

    private static boolean isAllowed(String word) {
        if (Character.isUpperCase(word.charAt(0))) {
            return true;
        }
        switch (word) {
            case "that": 
            case "yadda": 
            case "bye": 
            case "choo": 
            case "night": 
            case "dot": 
            case "tsk": 
            case "no": {
                return true;
            }
        }
        return false;
    }
}

