/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class UnpackedNativeCodeDetector
extends ResourceXmlDetector
implements XmlScanner,
SourceCodeScanner,
ClassScanner {
    public static final Issue ISSUE = Issue.create("UnpackedNativeCode", "Missing `android:extractNativeLibs=false`", "This app loads native libraries using `System.loadLibrary()`.\n\nConsider adding `android:extractNativeLibs=\"false\"` to the `<application>` tag in AndroidManifest.xml. Starting with Android 6.0, this will make installation faster, the app will take up less space on the device and updates will have smaller download sizes.", Category.PERFORMANCE, 6, Severity.WARNING, new Implementation(UnpackedNativeCodeDetector.class, EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE, Scope.JAVA_LIBRARIES), EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE))).setEnabledByDefault(false);
    private static final String SYSTEM_CLASS = "java.lang.System";
    private static final String RUNTIME_CLASS = "java.lang.Runtime";
    private static final String SYSTEM_CLASS_ALT = "java/lang/System";
    private static final String RUNTIME_CLASS_ALT = "java/lang/Runtime";
    private static final String LOAD_LIBRARY = "loadLibrary";
    private static final GradleVersion MIN_GRADLE_VERSION = GradleVersion.parse((String)"2.2.0");
    private boolean mHasNativeLibs;
    private Location.Handle mApplicationTagHandle;
    private boolean mSuppress;

    @Override
    public List<String> getApplicableCallNames() {
        if (this.mSuppress) {
            return null;
        }
        return Collections.singletonList(LOAD_LIBRARY);
    }

    @Override
    public void checkCall(ClassContext context2, ClassNode classNode, MethodNode method, MethodInsnNode call) {
        String owner = call.owner;
        String name = call.name;
        if (name.equals(LOAD_LIBRARY) && (owner.equals(SYSTEM_CLASS_ALT) || owner.equals(RUNTIME_CLASS_ALT))) {
            this.mHasNativeLibs = true;
        }
    }

    @Override
    public List<String> getApplicableMethodNames() {
        if (this.mSuppress) {
            return null;
        }
        return Collections.singletonList(LOAD_LIBRARY);
    }

    @Override
    public void visitMethodCall(JavaContext context2, UCallExpression call, PsiMethod method) {
        JavaEvaluator evaluator;
        if (LOAD_LIBRARY.equals(method.getName()) && ((evaluator = context2.getEvaluator()).isMemberInSubClassOf((PsiMember)method, RUNTIME_CLASS, false) || evaluator.isMemberInSubClassOf((PsiMember)method, SYSTEM_CLASS, false))) {
            this.mHasNativeLibs = true;
        }
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singleton("application");
    }

    @Override
    public void beforeCheckRootProject(Context context2) {
        this.mHasNativeLibs = false;
        this.mApplicationTagHandle = null;
        if (!context2.getMainProject().isGradleProject() || context2.getMainProject().getGradleModelVersion() == null) {
            this.mSuppress = true;
            return;
        }
        boolean projectSupportsAttribute = context2.getMainProject().getBuildSdk() >= 23;
        GradleVersion gradleVersion = context2.getMainProject().getGradleModelVersion();
        boolean gradleSupportsAttribute = MIN_GRADLE_VERSION.compareIgnoringQualifiers(gradleVersion) <= 0;
        this.mSuppress = !projectSupportsAttribute || !gradleSupportsAttribute;
    }

    @Override
    public void afterCheckRootProject(Context context2) {
        if (context2.getProject() == context2.getMainProject() && !context2.getMainProject().isLibrary() && this.mApplicationTagHandle != null && !this.mSuppress && this.mHasNativeLibs) {
            LintFix fix = this.fix().set("http://schemas.android.com/apk/res/android", "extractNativeLibs", "false").build();
            context2.report(ISSUE, this.mApplicationTagHandle.resolve(), "Missing attribute android:extractNativeLibs=\"false\" on the `<application>` tag.", fix);
        }
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        if (context2.getProject() != context2.getMainProject() || context2.getMainProject().isLibrary()) {
            return;
        }
        if (context2.getDriver().isSuppressed(context2, ISSUE, element)) {
            this.mSuppress = true;
            return;
        }
        if ("application".equals(element.getNodeName())) {
            Attr extractAttr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "extractNativeLibs");
            if (extractAttr != null) {
                this.mSuppress = true;
            } else {
                this.mApplicationTagHandle = context2.createLocationHandle(element);
            }
        }
    }
}

