/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/UnusedNavigationDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "referencesThis", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "target", "", "visitDocument", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "Companion", "android.sdktools.lint-checks"})
public final class UnusedNavigationDetector
extends ResourceXmlDetector {
    private static final Implementation IMPLEMENTATION_XML;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Companion Companion;

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.NAVIGATION;
    }

    @Override
    public void visitDocument(@NotNull XmlContext context2, @NotNull Document document) {
        LintClient client = context2.getClient();
        ResourceRepository resourceRepository = client.getResourceRepository(context2.getMainProject(), true, false);
        if (resourceRepository == null) {
            return;
        }
        ResourceRepository resources = resourceRepository;
        ListMultimap items = resources.getResources(ResourceNamespace.TODO(), ResourceType.LAYOUT);
        if (items.size() == 0 || items.size() > 25) {
            return;
        }
        String target = "@navigation/" + Lint.getBaseName(context2.file.getName());
        for (ResourceItem item : items.values()) {
            if (item.getSource() == null) {
                continue;
            }
            try {
                PathString file;
                XmlPullParser parser = client.createXmlPullParser(file);
                if (parser == null || !this.referencesThis(parser, target)) continue;
                return;
            }
            catch (XmlPullParserException xmlPullParserException) {
            }
            catch (IOException iOException) {
            }
        }
        XmlContext.report$default(context2, ISSUE, document.getDocumentElement(), context2.getElementLocation(document.getDocumentElement()), "This navigation graph is not referenced from any layout files (expected to find it in at least one layout " + "file with a `NavHostFragment` with `app:navGraph=\"" + target + "\"` attribute).", null, 16, null);
    }

    private final boolean referencesThis(XmlPullParser parser, String target) {
        while (true) {
            int event;
            if ((event = parser.next()) == 2) {
                String navGraph;
                String cls;
                String tag;
                if (parser.getName() == null) {
                    continue;
                }
                if (!Intrinsics.areEqual((Object)tag, (Object)"fragment") || !Intrinsics.areEqual((Object)(cls = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "name")), (Object)"androidx.navigation.fragment.NavHostFragment")) continue;
                if (parser.getAttributeValue(ResourceNamespace.TODO().getXmlNamespaceUri(), "navGraph") == null) {
                    continue;
                }
                if (!Intrinsics.areEqual((Object)navGraph, (Object)target)) continue;
                return true;
            }
            if (event == 1) break;
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION_XML = new Implementation(UnusedNavigationDetector.class, Scope.RESOURCE_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default(Issue.Companion, "UnusedNavigation", "Unused Navigation", "\n                Navigation resource files must be referenced from a `NavHostFragment` \\\n                in a layout in order to be relevant.\n                ", IMPLEMENTATION_XML, "https://developer.android.com/topic/libraries/architecture/navigation/navigation-implementing#Modify-activity", Category.CORRECTNESS, 2, Severity.ERROR, false, null, null, null, 3840, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/UnusedNavigationDetector$Companion;", "", "()V", "IMPLEMENTATION_XML", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

