/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class VectorDrawableCompatDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("VectorDrawableCompat", "Using VectorDrawableCompat", "To use VectorDrawableCompat, you need to make two modifications to your project. First, set `android.defaultConfig.vectorDrawables.useSupportLibrary = true` in your `build.gradle` file, and second, use `app:srcCompat` instead of `android:src` to refer to vector drawables.", Category.CORRECTNESS, 5, Severity.ERROR, new Implementation(VectorDrawableCompatDetector.class, Scope.ALL_RESOURCES_SCOPE, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("http://chris.banes.me/2016/02/25/appcompat-vector/#enabling-the-flag");
    private boolean mSkipChecks;
    private final Set<String> mVectors = Sets.newHashSet();
    private boolean mUseSupportLibrary;

    @Override
    public void beforeCheckRootProject(Context context2) {
        AndroidProject model = context2.getProject().getGradleProjectModel();
        if (model == null) {
            this.mSkipChecks = true;
            return;
        }
        if (context2.getProject().getMinSdk() >= 21) {
            this.mSkipChecks = true;
            return;
        }
        GradleVersion version = context2.getProject().getGradleModelVersion();
        if (version == null || version.getMajor() < 2) {
            this.mSkipChecks = true;
            return;
        }
        Variant currentVariant = context2.getProject().getCurrentVariant();
        if (currentVariant == null) {
            this.mSkipChecks = true;
            return;
        }
        if (Boolean.TRUE.equals(currentVariant.getMergedFlavor().getVectorDrawables().getUseSupportLibrary())) {
            this.mUseSupportLibrary = true;
        }
    }

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        if (this.mSkipChecks) {
            return false;
        }
        return folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.LAYOUT;
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        if (this.mSkipChecks) {
            return;
        }
        String resourceName = Lint.getBaseName(context2.file.getName());
        this.mVectors.add(resourceName);
    }

    @Override
    public Collection<String> getApplicableElements() {
        return this.mSkipChecks ? null : Arrays.asList("vector", "animated-vector");
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return this.mSkipChecks ? null : ImmutableList.of((Object)"src", (Object)"srcCompat");
    }

    @Override
    public void visitAttribute(XmlContext context2, Attr attribute) {
        String message2;
        Location location;
        Predicate<String> isVector;
        boolean incrementalMode;
        if (this.mSkipChecks) {
            return;
        }
        boolean bl = incrementalMode = !context2.getDriver().getScope().contains((Object)Scope.ALL_RESOURCE_FILES);
        if (!incrementalMode && this.mVectors.isEmpty()) {
            return;
        }
        if (!incrementalMode) {
            isVector = this.mVectors::contains;
        } else {
            LintClient client = context2.getClient();
            ResourceRepository resources = client.getResourceRepository(context2.getMainProject(), true, false);
            if (resources == null) {
                return;
            }
            isVector = name -> VectorDrawableCompatDetector.checkResourceRepository(resources, name);
        }
        String name2 = attribute.getLocalName();
        String namespace = attribute.getNamespaceURI();
        if ("src".equals(name2) && !"http://schemas.android.com/apk/res/android".equals(namespace) || "srcCompat".equals(name2) && !"http://schemas.android.com/apk/res-auto".equals(namespace)) {
            return;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)attribute.getValue());
        if (resourceUrl == null) {
            return;
        }
        if (this.mUseSupportLibrary && "src".equals(name2) && isVector.test(resourceUrl.name)) {
            location = context2.getNameLocation(attribute);
            message2 = "When using VectorDrawableCompat, you need to use `app:srcCompat`.";
            context2.report(ISSUE, attribute, location, message2);
        }
        if (!this.mUseSupportLibrary && "srcCompat".equals(name2) && isVector.test(resourceUrl.name)) {
            location = context2.getNameLocation(attribute);
            message2 = "To use VectorDrawableCompat, you need to set `android.defaultConfig.vectorDrawables.useSupportLibrary = true`.";
            context2.report(ISSUE, attribute, location, message2);
        }
    }

    private static boolean checkResourceRepository(ResourceRepository resources, String name) {
        List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.DRAWABLE, name);
        for (ResourceItem item : items) {
            PathString source = item.getSource();
            if (source == null) {
                return false;
            }
            File file = source.toFile();
            if (file == null) {
                return false;
            }
            if (!source.getFileName().endsWith(".xml")) continue;
            String rootTagName = XmlUtils.getRootTagName((File)file);
            return "vector".equals(rootTagName) || "animated-vector".equals(rootTagName);
        }
        return false;
    }
}

