/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Project;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u0080\u00012\u00020\u0001:\u0004\u0080\u0001\u0081\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u001c\u0010\u0014\u001a\u00020\u000e2\n\u0010\u0015\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u0018\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0003J\u001c\u0010\u0019\u001a\u00020\u000e2\n\u0010\u0015\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0003J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J$\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001cH\u0016JE\u0010%\u001a\u0004\u0018\u00010\t2\u0006\u0010$\u001a\u00020\t2\b\b\u0002\u0010&\u001a\u00020\u000e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010*\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010+J\u0014\u0010,\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\"\u0010-\u001a\u00020\u000e2\b\u0010.\u001a\u0004\u0018\u00010\u00172\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\u000eH&J!\u00101\u001a\b\u0012\u0004\u0012\u0002020(2\f\u00103\u001a\b\u0012\u0004\u0012\u0002020(H\u0016\u00a2\u0006\u0002\u00104J-\u00105\u001a\u0004\u0018\u0001022\b\u00106\u001a\u0004\u0018\u0001072\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0(\"\u00020\tH&\u00a2\u0006\u0002\u00109J+\u0010:\u001a\u0004\u0018\u0001022\u0006\u00106\u001a\u0002072\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0(\"\u00020\tH&\u00a2\u0006\u0002\u00109J\u0012\u0010;\u001a\u0004\u0018\u00010\u00172\u0006\u0010<\u001a\u00020\tH&J\u0012\u0010=\u001a\u0004\u0018\u00010\t2\u0006\u0010>\u001a\u00020?H&J\u0012\u0010=\u001a\u0004\u0018\u00010\t2\u0006\u0010>\u001a\u00020@H&J \u0010A\u001a\u0004\u0018\u00010B2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020D0C2\u0006\u0010E\u001a\u00020\tH\u0002J(\u0010A\u001a\u0004\u0018\u00010B2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020D0C2\u0006\u0010F\u001a\u00020\t2\u0006\u0010G\u001a\u00020\tH\u0002J\u0012\u0010H\u001a\u0004\u0018\u00010B2\u0006\u0010E\u001a\u00020\tH\u0016J \u0010H\u001a\u0004\u0018\u00010B2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020I0C2\u0006\u0010E\u001a\u00020\tH\u0002J(\u0010H\u001a\u0004\u0018\u00010B2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020I0C2\u0006\u0010F\u001a\u00020\t2\u0006\u0010G\u001a\u00020\tH\u0002J#\u0010J\u001a\b\u0012\u0004\u0012\u0002020(2\u0006\u0010K\u001a\u0002072\u0006\u0010L\u001a\u00020\u000eH&\u00a2\u0006\u0002\u0010MJ\u001e\u0010J\u001a\b\u0012\u0004\u0012\u00020O0N2\u0006\u0010K\u001a\u00020P2\u0006\u0010L\u001a\u00020\u000eH&J\u0014\u0010Q\u001a\u0004\u0018\u00010R2\b\u0010S\u001a\u0004\u0018\u00010\u0017H&J\"\u0010T\u001a\u0004\u0018\u00010\t2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000eH\u0017J\u0012\u0010U\u001a\u0004\u0018\u00010\t2\u0006\u0010S\u001a\u00020\u0017H\u0017J\u0012\u0010U\u001a\u0004\u0018\u00010\t2\u0006\u0010V\u001a\u00020RH\u0017J\u0012\u0010W\u001a\u0004\u0018\u00010\n2\u0006\u0010>\u001a\u00020?H\u0016J\u0014\u0010W\u001a\u0004\u0018\u00010\n2\b\u0010E\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010W\u001a\u0004\u0018\u00010\n2\u0006\u0010>\u001a\u00020@H\u0016J\u0012\u0010W\u001a\u0004\u0018\u00010\n2\u0006\u0010>\u001a\u00020XH\u0016J\"\u0010Y\u001a\u0004\u0018\u00010\t2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000eH\u0016J\u0012\u0010Z\u001a\u0004\u0018\u00010[2\u0006\u0010\\\u001a\u00020?H&J\u0012\u0010Z\u001a\u0004\u0018\u00010[2\u0006\u0010\\\u001a\u00020@H&J\u0012\u0010Z\u001a\u0004\u0018\u00010[2\u0006\u0010\\\u001a\u00020XH\u0016J\u0010\u0010]\u001a\u00020^2\u0006\u0010$\u001a\u00020\u001cH\u0016J\u0012\u0010_\u001a\u0004\u0018\u00010`2\u0006\u0010>\u001a\u00020?H\u0016J\u0012\u0010a\u001a\u0004\u0018\u00010\t2\u0006\u0010S\u001a\u00020\u0017H\u0016J\u0012\u0010a\u001a\u0004\u0018\u00010\t2\u0006\u0010V\u001a\u00020RH\u0016J\u0014\u0010b\u001a\u0004\u0018\u00010\u001c2\b\u0010$\u001a\u0004\u0018\u00010\u001cH\u0016J \u0010c\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u00172\u0006\u0010d\u001a\u00020\t2\u0006\u00100\u001a\u00020\u000eH&J\"\u0010e\u001a\u00020\u000e2\b\u0010.\u001a\u0004\u0018\u00010\u00172\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\u000eH\u0016J\u0012\u0010f\u001a\u00020\u000e2\b\u0010K\u001a\u0004\u0018\u000107H\u0016J\u0012\u0010g\u001a\u00020\u000e2\b\u0010K\u001a\u0004\u0018\u000107H\u0016J\u0018\u0010h\u001a\u00020\u000e2\u0006\u0010i\u001a\u0002022\u0006\u0010K\u001a\u000207H\u0016J\u0018\u0010h\u001a\u00020\u000e2\u0006\u0010i\u001a\u00020O2\u0006\u0010K\u001a\u000207H\u0016J\u0018\u0010h\u001a\u00020\u000e2\u0006\u0010i\u001a\u00020O2\u0006\u0010K\u001a\u00020PH\u0016J\u001a\u0010j\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010k2\u0006\u0010/\u001a\u00020\tH\u0016J \u0010l\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020k2\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\u000eH\u0016J\u0018\u0010m\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u001c2\b\b\u0002\u0010n\u001a\u00020\u000eJ\u0018\u0010m\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020X2\b\b\u0002\u0010n\u001a\u00020\u000eJ\u0012\u0010o\u001a\u00020\u000e2\b\u0010K\u001a\u0004\u0018\u000107H\u0016J\u0012\u0010p\u001a\u00020\u000e2\b\u0010K\u001a\u0004\u0018\u000107H\u0016J\u0012\u0010q\u001a\u00020\u000e2\b\u0010K\u001a\u0004\u0018\u000107H\u0016J\u0012\u0010r\u001a\u00020\u000e2\b\u0010K\u001a\u0004\u0018\u000107H\u0016J;\u0010s\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u001c2\b\u0010/\u001a\u0004\u0018\u00010\t2\u0006\u0010t\u001a\u00020\u000e2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0(\"\u00020\tH\u0016\u00a2\u0006\u0002\u0010uJ\"\u0010v\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010\u001c2\u0006\u0010w\u001a\u00020^2\u0006\u0010x\u001a\u00020\tH\u0016J)\u0010y\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u001c2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0(\"\u00020\tH\u0016\u00a2\u0006\u0002\u0010zJ\u0012\u0010{\u001a\u0004\u0018\u00010?2\u0006\u0010>\u001a\u00020?H\u0016J\u001d\u0010|\u001a\u00020}2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b~J\u001a\u0010\u007f\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010x\u001a\u00020\tH\u0016R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0082\u0001"}, d2={"Lcom/android/tools/lint/client/api/JavaEvaluator;", "", "()V", "dependencies", "Lcom/android/builder/model/Dependencies;", "getDependencies", "()Lcom/android/builder/model/Dependencies;", "jarToGroup", "", "", "Lcom/android/builder/model/MavenCoordinates;", "relevantAnnotations", "", "appendJvmEquivalentSignature", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "type", "Lcom/intellij/psi/PsiType;", "appendJvmEquivalentTypeName", "signature", "outerClass", "Lcom/intellij/psi/PsiClass;", "appendJvmSignature", "appendJvmTypeName", "areSignaturesEqual", "method1", "Lcom/intellij/psi/PsiMethod;", "method2", "computeArgumentMapping", "", "Lorg/jetbrains/uast/UExpression;", "Lcom/intellij/psi/PsiParameter;", "call", "Lorg/jetbrains/uast/UCallExpression;", "method", "constructMethodDescription", "includeName", "argumentTypes", "", "returnType", "includeReturn", "(Ljava/lang/String;Z[Lcom/intellij/psi/PsiType;Lcom/intellij/psi/PsiType;Z)Ljava/lang/String;", "erasure", "extendsClass", "cls", "className", "strict", "filterRelevantAnnotations", "Lcom/intellij/psi/PsiAnnotation;", "annotations", "([Lcom/intellij/psi/PsiAnnotation;)[Lcom/intellij/psi/PsiAnnotation;", "findAnnotation", "listOwner", "Lcom/intellij/psi/PsiModifierListOwner;", "annotationNames", "(Lcom/intellij/psi/PsiModifierListOwner;[Ljava/lang/String;)Lcom/intellij/psi/PsiAnnotation;", "findAnnotationInHierarchy", "findClass", "qualifiedName", "findJarPath", "element", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/uast/UElement;", "findOwnerJavaLibrary", "Lcom/android/builder/model/Library;", "", "Lcom/android/builder/model/JavaLibrary;", "jarFile", "pathPrefix", "pathSuffix", "findOwnerLibrary", "Lcom/android/builder/model/AndroidLibrary;", "getAllAnnotations", "owner", "inHierarchy", "(Lcom/intellij/psi/PsiModifierListOwner;Z)[Lcom/intellij/psi/PsiAnnotation;", "", "Lorg/jetbrains/uast/UAnnotation;", "Lorg/jetbrains/uast/UAnnotated;", "getClassType", "Lcom/intellij/psi/PsiClassType;", "psiClass", "getInternalDescription", "getInternalName", "psiClassType", "getLibrary", "Lorg/jetbrains/uast/UMethod;", "getMethodDescription", "getPackage", "Lcom/intellij/psi/PsiPackage;", "node", "getParameterCount", "", "getProject", "Lcom/android/tools/lint/detector/api/Project;", "getQualifiedName", "getSuperMethod", "implementsInterface", "interfaceName", "inheritsFrom", "isAbstract", "isFinal", "isInherited", "annotation", "isMemberInClass", "Lcom/intellij/psi/PsiMember;", "isMemberInSubClassOf", "isOverride", "includeInterfaces", "isPrivate", "isProtected", "isPublic", "isStatic", "methodMatches", "allowInherit", "(Lcom/intellij/psi/PsiMethod;Ljava/lang/String;Z[Ljava/lang/String;)Z", "parameterHasType", "parameterIndex", "typeName", "parametersMatch", "(Lcom/intellij/psi/PsiMethod;[Ljava/lang/String;)Z", "resolve", "setRelevantAnnotations", "", "setRelevantAnnotations$android_sdktools_lint_api", "typeMatches", "Companion", "MyMavenCoordinates", "android.sdktools.lint-api"})
public abstract class JavaEvaluator {
    private Set<String> relevantAnnotations;
    private Map<String, MavenCoordinates> jarToGroup;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public abstract Dependencies getDependencies();

    public abstract boolean extendsClass(@Nullable PsiClass var1, @NotNull String var2, boolean var3);

    public abstract boolean implementsInterface(@NotNull PsiClass var1, @NotNull String var2, boolean var3);

    public boolean isMemberInSubClassOf(@NotNull PsiMember method, @NotNull String className, boolean strict) {
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null && this.extendsClass(containingClass, className, strict);
    }

    public boolean isMemberInClass(@Nullable PsiMember method, @NotNull String className) {
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null && Intrinsics.areEqual((Object)className, (Object)containingClass.getQualifiedName());
    }

    public int getParameterCount(@NotNull PsiMethod method) {
        return method.getParameterList().getParametersCount();
    }

    public boolean inheritsFrom(@Nullable PsiClass cls, @NotNull String className, boolean strict) {
        if (cls == null) {
            return false;
        }
        return this.extendsClass(cls, className, strict) || this.implementsInterface(cls, className, strict);
    }

    public boolean methodMatches(@NotNull PsiMethod method, @Nullable String className, boolean allowInherit, String ... argumentTypes) {
        if (className != null && allowInherit && !this.isMemberInSubClassOf((PsiMember)method, className, false)) {
            return false;
        }
        return this.parametersMatch(method, Arrays.copyOf(argumentTypes, argumentTypes.length));
    }

    /*
     * WARNING - void declaration
     */
    public boolean parametersMatch(@NotNull PsiMethod method, String ... argumentTypes) {
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != argumentTypes.length) {
            return false;
        }
        PsiParameter[] parameters = parameterList.getParameters();
        int n = 0;
        int n2 = parameters.length;
        while (n < n2) {
            void i;
            PsiType type = parameters[i].getType();
            if (Intrinsics.areEqual((Object)type.getCanonicalText(), (Object)argumentTypes[i]) ^ true) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean parameterHasType(@Nullable PsiMethod method, int parameterIndex, @NotNull String typeName) {
        if (method == null) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        return parameterList.getParametersCount() > parameterIndex && this.typeMatches(parameterList.getParameters()[parameterIndex].getType(), typeName);
    }

    public boolean typeMatches(@Nullable PsiType type, @NotNull String typeName) {
        return type != null && Intrinsics.areEqual((Object)type.getCanonicalText(), (Object)typeName);
    }

    @Nullable
    public PsiElement resolve(@NotNull PsiElement element) {
        PsiMethod resolved;
        if (element instanceof PsiReference) {
            return ((PsiReference)element).resolve();
        }
        if (element instanceof PsiMethodCallExpression && (resolved = ((PsiMethodCallExpression)element).resolveMethod()) != null) {
            return (PsiElement)resolved;
        }
        return null;
    }

    public boolean isPublic(@Nullable PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("public");
        }
        return false;
    }

    public boolean isProtected(@Nullable PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("protected");
        }
        return false;
    }

    public boolean isStatic(@Nullable PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("static");
        }
        return false;
    }

    public boolean isPrivate(@Nullable PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("private");
        }
        return false;
    }

    public boolean isAbstract(@Nullable PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("abstract");
        }
        return false;
    }

    public boolean isFinal(@Nullable PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("final");
        }
        return false;
    }

    @Nullable
    public PsiMethod getSuperMethod(@Nullable PsiMethod method) {
        PsiMethod[] psiMethodArray;
        PsiMethod[] psiMethodArray2;
        if (method == null) {
            return null;
        }
        PsiMethod[] superMethods = method.findSuperMethods();
        if (superMethods.length > 1) {
            for (PsiMethod m : superMethods) {
                if (m instanceof PsiCompiledElement) continue;
                PsiClass psiClass = m.getContainingClass();
                if (psiClass == null) continue;
                if (psiClass.isInterface()) continue;
                return m;
            }
            for (PsiMethod m : superMethods) {
                PsiClass psiClass = m.getContainingClass();
                if (psiClass == null) continue;
                if (psiClass.isInterface()) continue;
                return m;
            }
            for (PsiMethod m : superMethods) {
                if (m instanceof PsiCompiledElement) continue;
                return m;
            }
        }
        return !((psiMethodArray2 = (psiMethodArray = superMethods)).length == 0) ? superMethods[0] : null;
    }

    @Nullable
    public String getQualifiedName(@NotNull PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null && (qualifiedName = psiClass.getName()) == null) {
            boolean bl = psiClass instanceof PsiAnonymousClass;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            PsiClass psiClass2 = psiClass.getContainingClass();
            if (psiClass2 == null) {
                Intrinsics.throwNpe();
            }
            return this.getQualifiedName(psiClass2);
        }
        return qualifiedName;
    }

    @Nullable
    public String getQualifiedName(@NotNull PsiClassType psiClassType) {
        return psiClassType.getCanonicalText();
    }

    @Deprecated(message="Most lint APIs (such as ApiLookup) no longer require internal JVM names and\n      accept qualified names that can be obtained by calling the\n      {@link #getQualifiedName(PsiClass)} method.")
    @Nullable
    public String getInternalName(@NotNull PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null && (qualifiedName = psiClass.getName()) == null) {
            boolean bl = psiClass instanceof PsiAnonymousClass;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            PsiClass psiClass2 = psiClass.getContainingClass();
            if (psiClass2 == null) {
                Intrinsics.throwNpe();
            }
            return this.getInternalName(psiClass2);
        }
        return ClassContext.Companion.getInternalName(qualifiedName);
    }

    @Deprecated(message="Most lint APIs (such as ApiLookup) no longer require internal JVM names and\n      accept qualified names that can be obtained by calling the\n      {@link #getQualifiedName(PsiClassType)} method.")
    @Nullable
    public String getInternalName(@NotNull PsiClassType psiClassType) {
        return ClassContext.Companion.getInternalName(psiClassType.getCanonicalText());
    }

    @Nullable
    public String getMethodDescription(@NotNull PsiMethod method, boolean includeName, boolean includeReturn) {
        boolean bl;
        boolean bl2 = bl = !includeName;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl3 = bl = !includeReturn;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        StringBuilder signature = new StringBuilder();
        if (includeName) {
            if (method.isConstructor()) {
                PsiClass outerClass;
                PsiClass declaringClass = method.getContainingClass();
                if (declaringClass != null && (outerClass = declaringClass.getContainingClass()) != null && !declaringClass.hasModifierProperty("static") && !this.appendJvmEquivalentTypeName(signature, outerClass)) {
                    return null;
                }
                signature.append("<init>");
            } else {
                signature.append(method.getName());
            }
        }
        signature.append('(');
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            if (this.appendJvmEquivalentSignature(signature, psiParameter.getType())) continue;
            return null;
        }
        signature.append(')');
        if (includeReturn) {
            if (!method.isConstructor()) {
                if (!this.appendJvmEquivalentSignature(signature, method.getReturnType())) {
                    return null;
                }
            } else {
                signature.append('V');
            }
        }
        return signature.toString();
    }

    @Nullable
    public String constructMethodDescription(@NotNull String method, boolean includeName, @NotNull PsiType[] argumentTypes, @Nullable PsiType returnType, boolean includeReturn) {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (includeName) {
            $receiver.append(method);
        }
        $receiver.append('(');
        for (PsiType argumentType : argumentTypes) {
            if (this.appendJvmEquivalentSignature($receiver, argumentType)) continue;
            return null;
        }
        $receiver.append(')');
        if (includeReturn && !this.appendJvmEquivalentSignature($receiver, returnType)) {
            return null;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Nullable
    public static /* synthetic */ String constructMethodDescription$default(JavaEvaluator javaEvaluator, String string, boolean bl, PsiType[] psiTypeArray, PsiType psiType, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: constructMethodDescription");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            psiType = null;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return javaEvaluator.constructMethodDescription(string, bl, psiTypeArray, psiType, bl2);
    }

    @Deprecated(message="Most lint APIs (such as ApiLookup) no longer require internal JVM method\n      descriptions and accept JVM equivalent descriptions that can be obtained by calling the\n      {@link #getMethodDescription} method.")
    @Nullable
    public String getInternalDescription(@NotNull PsiMethod method, boolean includeName, boolean includeReturn) {
        boolean bl;
        boolean bl2 = bl = !includeName;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl3 = bl = !includeReturn;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        StringBuilder signature = new StringBuilder();
        if (includeName) {
            if (method.isConstructor()) {
                PsiClass outerClass;
                PsiClass declaringClass = method.getContainingClass();
                if (declaringClass != null && (outerClass = declaringClass.getContainingClass()) != null && !declaringClass.hasModifierProperty("static") && !this.appendJvmTypeName(signature, outerClass)) {
                    return null;
                }
                signature.append("<init>");
            } else {
                signature.append(method.getName());
            }
        }
        signature.append('(');
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            if (this.appendJvmSignature(signature, psiParameter.getType())) continue;
            return null;
        }
        signature.append(')');
        if (includeReturn) {
            if (!method.isConstructor()) {
                if (!this.appendJvmSignature(signature, method.getReturnType())) {
                    return null;
                }
            } else {
                signature.append('V');
            }
        }
        return signature.toString();
    }

    private final boolean appendJvmEquivalentTypeName(StringBuilder signature, PsiClass outerClass) {
        String string = this.getQualifiedName(outerClass);
        if (string == null) {
            return false;
        }
        String className = string;
        signature.append('L').append(className).append(';');
        return true;
    }

    private final boolean appendJvmEquivalentSignature(StringBuilder buffer, PsiType type) {
        if (type == null) {
            return false;
        }
        PsiType psiType = this.erasure(type);
        if (psiType instanceof PsiArrayType) {
            buffer.append('[');
            this.appendJvmEquivalentSignature(buffer, ((PsiArrayType)psiType).getComponentType());
        } else if (psiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            if (psiClass == null) {
                return false;
            }
            PsiClass resolved = psiClass;
            if (!this.appendJvmEquivalentTypeName(buffer, resolved)) {
                return false;
            }
        } else if (psiType instanceof PsiPrimitiveType) {
            buffer.append(Companion.getPrimitiveSignature(((PsiPrimitiveType)psiType).getCanonicalText()));
        } else {
            return false;
        }
        return true;
    }

    @Deprecated(message="")
    private final boolean appendJvmTypeName(StringBuilder signature, PsiClass outerClass) {
        String string = this.getInternalName(outerClass);
        if (string == null) {
            return false;
        }
        String className = string;
        signature.append('L').append(className).append(';');
        return true;
    }

    @Deprecated(message="")
    private final boolean appendJvmSignature(StringBuilder buffer, PsiType type) {
        if (type == null) {
            return false;
        }
        PsiType psiType = this.erasure(type);
        PsiType psiType2 = psiType;
        if (psiType2 instanceof PsiArrayType) {
            buffer.append('[');
            this.appendJvmSignature(buffer, ((PsiArrayType)psiType).getComponentType());
        } else if (psiType2 instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            if (psiClass == null) {
                return false;
            }
            PsiClass resolved = psiClass;
            if (!this.appendJvmTypeName(buffer, resolved)) {
                return false;
            }
        } else if (psiType2 instanceof PsiPrimitiveType) {
            buffer.append(Companion.getPrimitiveSignature(((PsiPrimitiveType)psiType).getCanonicalText()));
        } else {
            return false;
        }
        return true;
    }

    public boolean areSignaturesEqual(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        PsiParameterList parameterList1 = method1.getParameterList();
        PsiParameterList parameterList2 = method2.getParameterList();
        if (parameterList1.getParametersCount() != parameterList2.getParametersCount()) {
            return false;
        }
        PsiParameter[] parameters1 = parameterList1.getParameters();
        PsiParameter[] parameters2 = parameterList2.getParameters();
        int n = parameters1.length;
        for (int i = 0; i < n; ++i) {
            PsiType type2;
            PsiParameter parameter1 = parameters1[i];
            PsiParameter parameter2 = parameters2[i];
            PsiType type1 = parameter1.getType();
            if (!(Intrinsics.areEqual((Object)type1, (Object)(type2 = parameter2.getType())) ^ true) || !(Intrinsics.areEqual((Object)(type1 = this.erasure(parameter1.getType())), (Object)(type2 = this.erasure(parameter2.getType()))) ^ true)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public PsiType erasure(@Nullable PsiType type) {
        PsiType psiType = type;
        return psiType != null ? (PsiType)psiType.accept((PsiTypeVisitor)new PsiTypeVisitor<PsiType>(){

            @Nullable
            public PsiType visitType(@Nullable PsiType type) {
                return type;
            }

            @Nullable
            public PsiType visitClassType(@NotNull PsiClassType classType) {
                return (PsiType)classType.rawType();
            }

            @Nullable
            public PsiType visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                return (PsiType)wildcardType;
            }

            @Nullable
            public PsiType visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
                return (PsiType)primitiveType;
            }

            @Nullable
            public PsiType visitEllipsisType(@NotNull PsiEllipsisType ellipsisType) {
                PsiType psiType;
                PsiType componentType = ellipsisType.getComponentType();
                PsiType newComponentType = (PsiType)componentType.accept((PsiTypeVisitor)this);
                if (newComponentType == componentType) {
                    psiType = (PsiType)ellipsisType;
                } else {
                    PsiType psiType2 = newComponentType;
                    psiType = (PsiType)(psiType2 != null ? psiType2.createArrayType() : null);
                }
                return psiType;
            }

            @Nullable
            public PsiType visitArrayType(@NotNull PsiArrayType arrayType) {
                PsiType psiType;
                PsiType componentType = arrayType.getComponentType();
                PsiType newComponentType = (PsiType)componentType.accept((PsiTypeVisitor)this);
                if (newComponentType == componentType) {
                    psiType = (PsiType)arrayType;
                } else {
                    PsiType psiType2 = newComponentType;
                    psiType = (PsiType)(psiType2 != null ? psiType2.createArrayType() : null);
                }
                return psiType;
            }
        }) : null;
    }

    @Nullable
    public abstract PsiClass findClass(@NotNull String var1);

    @Nullable
    public abstract PsiClassType getClassType(@Nullable PsiClass var1);

    @NotNull
    public abstract List<UAnnotation> getAllAnnotations(@NotNull UAnnotated var1, boolean var2);

    @NotNull
    public abstract PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner var1, boolean var2);

    @Nullable
    public abstract PsiAnnotation findAnnotationInHierarchy(@NotNull PsiModifierListOwner var1, String ... var2);

    @Nullable
    public abstract PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner var1, String ... var2);

    @Nullable
    public abstract String findJarPath(@NotNull PsiElement var1);

    @Nullable
    public abstract String findJarPath(@NotNull UElement var1);

    public boolean isInherited(@NotNull PsiAnnotation annotation, @NotNull PsiModifierListOwner owner) {
        PsiAnnotationOwner annotationOwner = annotation.getOwner();
        return annotationOwner == null || Intrinsics.areEqual((Object)annotationOwner, (Object)owner.getModifierList()) ^ true;
    }

    public boolean isInherited(@NotNull UAnnotation annotation, @NotNull PsiModifierListOwner owner) {
        PsiElement psi = annotation.getPsi();
        if (psi instanceof PsiAnnotation) {
            PsiAnnotationOwner annotationOwner = ((PsiAnnotation)psi).getOwner();
            return annotationOwner == null || Intrinsics.areEqual((Object)annotationOwner, (Object)owner.getModifierList()) ^ true;
        }
        return true;
    }

    public boolean isInherited(@NotNull UAnnotation annotation, @NotNull UAnnotated owner) {
        return owner.getAnnotations().contains(annotation);
    }

    @Nullable
    public abstract PsiPackage getPackage(@NotNull PsiElement var1);

    @Nullable
    public abstract PsiPackage getPackage(@NotNull UElement var1);

    @Nullable
    public PsiPackage getPackage(@NotNull UMethod node) {
        UMethod uMethod = node;
        if (uMethod == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
        }
        return this.getPackage((PsiElement)uMethod);
    }

    @Nullable
    public Project getProject(@NotNull PsiElement element) {
        return null;
    }

    @Nullable
    public MavenCoordinates getLibrary(@NotNull PsiElement element) {
        if (!(element instanceof PsiCompiledElement)) {
            return null;
        }
        return this.getLibrary(this.findJarPath(element));
    }

    @Nullable
    public MavenCoordinates getLibrary(@NotNull UElement element) {
        if (!(element instanceof PsiCompiledElement)) {
            return null;
        }
        return this.getLibrary(this.findJarPath(element));
    }

    @Nullable
    public MavenCoordinates getLibrary(@NotNull UMethod element) {
        UMethod uMethod = element;
        if (uMethod == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
        }
        return this.getLibrary((PsiElement)uMethod);
    }

    /*
     * WARNING - void declaration
     */
    private final MavenCoordinates getLibrary(String jarFile) {
        if (jarFile != null) {
            MavenCoordinates coordinates;
            if (this.jarToGroup == null) {
                this.jarToGroup = Maps.newHashMap();
            }
            Map<String, MavenCoordinates> map = this.jarToGroup;
            if (map == null) {
                Intrinsics.throwNpe();
            }
            if ((coordinates = map.get(jarFile)) == null) {
                int index;
                Library library = this.findOwnerLibrary(StringsKt.replace$default((String)jarFile, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null));
                if (library != null) {
                    coordinates = library.getResolvedCoordinates();
                }
                if (coordinates == null && (index = StringsKt.indexOf$default((CharSequence)jarFile, (String)"exploded-aar", (int)0, (boolean)false, (int)6, null)) != -1) {
                    block0: for (int i = index += 13; i < jarFile.length(); ++i) {
                        char c = jarFile.charAt(i);
                        if (c != '/' && c != File.separatorChar) continue;
                        String string = jarFile;
                        String string2 = string.substring(index, i);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String groupId = string2;
                        int n = ++i;
                        int n2 = jarFile.length();
                        while (n < n2) {
                            void j;
                            c = jarFile.charAt((int)j);
                            if (c == '/' || c == File.separatorChar) {
                                String string3 = jarFile;
                                String string4 = string3.substring(i, (int)j);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                String artifactId = string4;
                                coordinates = new MyMavenCoordinates(groupId, artifactId);
                                break block0;
                            }
                            ++j;
                        }
                        break;
                    }
                }
                if (coordinates == null) {
                    coordinates = MyMavenCoordinates.Companion.getNONE();
                }
                Map<String, MavenCoordinates> map2 = this.jarToGroup;
                if (map2 == null) {
                    Intrinsics.throwNpe();
                }
                Map<String, MavenCoordinates> map3 = map2;
                MavenCoordinates mavenCoordinates = coordinates;
                map3.put(jarFile, mavenCoordinates);
            }
            return coordinates == MyMavenCoordinates.Companion.getNONE() ? null : coordinates;
        }
        return null;
    }

    @Nullable
    public Library findOwnerLibrary(@NotNull String jarFile) {
        Dependencies dependencies = this.getDependencies();
        if (dependencies != null) {
            int prefixEnd;
            int suffixStart;
            int aar;
            Library aarMatch = this.findOwnerLibrary(dependencies.getLibraries(), jarFile);
            if (aarMatch != null) {
                return aarMatch;
            }
            Library jarMatch = this.findOwnerJavaLibrary(dependencies.getJavaLibraries(), jarFile);
            if (jarMatch != null) {
                return jarMatch;
            }
            if (StringsKt.contains$default((CharSequence)jarFile, (CharSequence)".gradle", (boolean)false, (int)2, null) && (aar = StringsKt.indexOf$default((CharSequence)jarFile, (String)(".aar" + File.separator), (int)0, (boolean)false, (int)6, null)) != -1 && (suffixStart = StringsKt.indexOf$default((CharSequence)jarFile, (char)File.separatorChar, (int)((prefixEnd = aar + 5) + 1), (boolean)false, (int)4, null)) != -1) {
                String string;
                String string2 = jarFile;
                int n = 0;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, prefixEnd);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String prefix = string4;
                String string5 = string = jarFile;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(suffixStart);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                String suffix = string6;
                Library aarPrefixMatch = this.findOwnerLibrary(dependencies.getLibraries(), prefix, suffix);
                if (aarPrefixMatch != null) {
                    return aarPrefixMatch;
                }
                Library jarPrefixMatch = this.findOwnerJavaLibrary(dependencies.getJavaLibraries(), prefix, suffix);
                if (jarPrefixMatch != null) {
                    return jarPrefixMatch;
                }
            }
        }
        return null;
    }

    private final Library findOwnerJavaLibrary(Collection<? extends JavaLibrary> dependencies, String jarFile) {
        for (JavaLibrary javaLibrary : dependencies) {
            if (Intrinsics.areEqual((Object)jarFile, (Object)javaLibrary.getJarFile().getPath())) {
                return javaLibrary;
            }
            Library match = this.findOwnerJavaLibrary((Collection<? extends JavaLibrary>)javaLibrary.getDependencies(), jarFile);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private final Library findOwnerJavaLibrary(Collection<? extends JavaLibrary> dependencies, String pathPrefix, String pathSuffix) {
        for (JavaLibrary javaLibrary : dependencies) {
            String path2 = javaLibrary.getJarFile().getPath();
            if (StringsKt.startsWith$default((String)path2, (String)pathPrefix, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)path2, (String)pathSuffix, (boolean)false, (int)2, null)) {
                return javaLibrary;
            }
            Library match = this.findOwnerJavaLibrary((Collection<? extends JavaLibrary>)javaLibrary.getDependencies(), pathPrefix, pathSuffix);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private final Library findOwnerLibrary(Collection<? extends AndroidLibrary> dependencies, String jarFile) {
        for (AndroidLibrary androidLibrary : dependencies) {
            if (Intrinsics.areEqual((Object)jarFile, (Object)androidLibrary.getJarFile().getPath())) {
                return androidLibrary;
            }
            for (File jar : androidLibrary.getLocalJars()) {
                if (!Intrinsics.areEqual((Object)jarFile, (Object)jar.getPath())) continue;
                return androidLibrary;
            }
            Library match = this.findOwnerLibrary((Collection<? extends AndroidLibrary>)androidLibrary.getLibraryDependencies(), jarFile);
            if (match != null) {
                return match;
            }
            match = this.findOwnerJavaLibrary(androidLibrary.getJavaDependencies(), jarFile);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private final Library findOwnerLibrary(Collection<? extends AndroidLibrary> dependencies, String pathPrefix, String pathSuffix) {
        for (AndroidLibrary androidLibrary : dependencies) {
            String path2 = androidLibrary.getJarFile().getPath();
            if (StringsKt.startsWith$default((String)path2, (String)pathPrefix, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)path2, (String)pathSuffix, (boolean)false, (int)2, null)) {
                return androidLibrary;
            }
            for (File jar : androidLibrary.getLocalJars()) {
                String localPath = jar.getPath();
                if (!StringsKt.startsWith$default((String)localPath, (String)pathPrefix, (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)localPath, (String)pathSuffix, (boolean)false, (int)2, null)) continue;
                return androidLibrary;
            }
            Library match = this.findOwnerLibrary((Collection<? extends AndroidLibrary>)androidLibrary.getLibraryDependencies(), pathPrefix, pathSuffix);
            if (match != null) {
                return match;
            }
            match = this.findOwnerJavaLibrary(androidLibrary.getJavaDependencies(), pathPrefix, pathSuffix);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    @NotNull
    public Map<UExpression, PsiParameter> computeArgumentMapping(@NotNull UCallExpression call, @NotNull PsiMethod method) {
        return MapsKt.emptyMap();
    }

    public final void setRelevantAnnotations$android_sdktools_lint_api(@Nullable Set<String> relevantAnnotations) {
        this.relevantAnnotations = relevantAnnotations;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiAnnotation[] filterRelevantAnnotations(@NotNull PsiAnnotation[] annotations) {
        PsiAnnotation[] psiAnnotationArray;
        if (this.relevantAnnotations == null) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        List result = null;
        int length = annotations.length;
        if (length == 0) {
            return annotations;
        }
        for (PsiAnnotation annotation : annotations) {
            PsiJavaCodeReferenceElement ref;
            String signature = annotation.getQualifiedName();
            if (signature == null) continue;
            if (StringsKt.startsWith$default((String)signature, (String)"java.", (boolean)false, (int)2, null)) {
                Set<String> set = this.relevantAnnotations;
                if (set == null) {
                    Intrinsics.throwNpe();
                }
                if (!set.contains(signature)) continue;
            }
            Set<String> set = this.relevantAnnotations;
            if (set == null) {
                Intrinsics.throwNpe();
            }
            if (set.contains(signature)) {
                if (length == 1) {
                    return annotations;
                }
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(annotation);
                continue;
            }
            if (annotation.getNameReferenceElement() == null) {
                continue;
            }
            PsiElement resolved = ref.resolve();
            if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
            PsiClass cls = (PsiClass)resolved;
            PsiAnnotation[] innerAnnotations = this.getAllAnnotations((PsiModifierListOwner)cls, false);
            int n = 0;
            int n2 = innerAnnotations.length;
            while (n < n2) {
                void j;
                PsiAnnotation inner = innerAnnotations[j];
                String a = inner.getQualifiedName();
                if (a != null) {
                    Set<String> set2 = this.relevantAnnotations;
                    if (set2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (set2.contains(a)) {
                        if (length == 1 && j == innerAnnotations.length - 1 && result == null) {
                            return innerAnnotations;
                        }
                        if (result == null) {
                            result = new ArrayList(2);
                        }
                        result.add(inner);
                    }
                }
                ++j;
            }
        }
        if (result != null) {
            Collection $receiver$iv;
            Collection thisCollection$iv = $receiver$iv = (Collection)result;
            PsiAnnotation[] psiAnnotationArray2 = thisCollection$iv.toArray(new PsiAnnotation[0]);
            if (psiAnnotationArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            psiAnnotationArray = psiAnnotationArray2;
        } else {
            psiAnnotationArray = PsiAnnotation.EMPTY_ARRAY;
        }
        return psiAnnotationArray;
    }

    public final boolean isOverride(@NotNull UMethod method, boolean includeInterfaces) {
        if (this.isStatic((PsiModifierListOwner)method)) {
            return false;
        }
        if (this.isPublic((PsiModifierListOwner)method) || this.isProtected((PsiModifierListOwner)method)) {
            UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)method));
            if (uClass == null) {
                return false;
            }
            UClass cls = uClass;
            UClass uClass2 = cls.getSuperClass();
            if (uClass2 == null) {
                return false;
            }
            UClass superCls = uClass2;
            if (includeInterfaces) {
                PsiMethod[] superMethods = method.findSuperMethods();
                PsiMethod[] psiMethodArray = superMethods;
                PsiMethod[] psiMethodArray2 = psiMethodArray;
                return !(psiMethodArray2.length == 0);
            }
            PsiMethod superMethod = superCls.findMethodBySignature(method.getPsi(), true);
            return superMethod != null;
        }
        return false;
    }

    public static /* synthetic */ boolean isOverride$default(JavaEvaluator javaEvaluator, UMethod uMethod, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isOverride");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return javaEvaluator.isOverride(uMethod, bl);
    }

    public final boolean isOverride(@NotNull PsiMethod method, boolean includeInterfaces) {
        if (this.isStatic((PsiModifierListOwner)method)) {
            return false;
        }
        if (this.isPublic((PsiModifierListOwner)method) || this.isProtected((PsiModifierListOwner)method)) {
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return false;
            }
            PsiClass cls = psiClass;
            PsiClass psiClass2 = cls.getSuperClass();
            if (psiClass2 == null) {
                return false;
            }
            PsiClass superCls = psiClass2;
            if (includeInterfaces) {
                PsiMethod[] superMethods = method.findSuperMethods();
                PsiMethod[] psiMethodArray = superMethods;
                PsiMethod[] psiMethodArray2 = psiMethodArray;
                return !(psiMethodArray2.length == 0);
            }
            PsiMethod superMethod = superCls.findMethodBySignature(method, true);
            return superMethod != null;
        }
        return false;
    }

    public static /* synthetic */ boolean isOverride$default(JavaEvaluator javaEvaluator, PsiMethod psiMethod, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isOverride");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return javaEvaluator.isOverride(psiMethod, bl);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/client/api/JavaEvaluator$MyMavenCoordinates;", "Lcom/android/builder/model/MavenCoordinates;", "groupId", "", "artifactId", "(Ljava/lang/String;Ljava/lang/String;)V", "getArtifactId", "getClassifier", "getGroupId", "getPackaging", "getVersion", "getVersionlessId", "Companion", "android.sdktools.lint-api"})
    private static final class MyMavenCoordinates
    implements MavenCoordinates {
        private final String groupId;
        private final String artifactId;
        @NotNull
        private static final MyMavenCoordinates NONE;
        public static final Companion Companion;

        @Override
        @NotNull
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        @NotNull
        public String getArtifactId() {
            return this.artifactId;
        }

        @Override
        @NotNull
        public String getVersion() {
            return "";
        }

        @Override
        @NotNull
        public String getPackaging() {
            return "";
        }

        @Override
        @Nullable
        public String getClassifier() {
            return "";
        }

        @Override
        @NotNull
        public String getVersionlessId() {
            return this.groupId + ':' + this.artifactId;
        }

        public MyMavenCoordinates(@NotNull String groupId, @NotNull String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        static {
            Companion = new Companion(null);
            NONE = new MyMavenCoordinates("", "");
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/client/api/JavaEvaluator$MyMavenCoordinates$Companion;", "", "()V", "NONE", "Lcom/android/tools/lint/client/api/JavaEvaluator$MyMavenCoordinates;", "getNONE", "()Lcom/android/tools/lint/client/api/JavaEvaluator$MyMavenCoordinates;", "android.sdktools.lint-api"})
        public static final class Companion {
            @NotNull
            public final MyMavenCoordinates getNONE() {
                return NONE;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/client/api/JavaEvaluator$Companion;", "", "()V", "getPrimitiveSignature", "", "typeName", "android.sdktools.lint-api"})
    public static final class Companion {
        @Nullable
        public final String getPrimitiveSignature(@NotNull String typeName) {
            String string;
            switch (typeName) {
                case "boolean": {
                    string = "Z";
                    break;
                }
                case "byte": {
                    string = "B";
                    break;
                }
                case "char": {
                    string = "C";
                    break;
                }
                case "short": {
                    string = "S";
                    break;
                }
                case "int": {
                    string = "I";
                    break;
                }
                case "long": {
                    string = "J";
                    break;
                }
                case "float": {
                    string = "F";
                    break;
                }
                case "double": {
                    string = "D";
                    break;
                }
                case "void": {
                    string = "V";
                    break;
                }
                default: {
                    string = null;
                }
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

