/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.Variant;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.LintJavaUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.CharSequences;
import com.android.utils.PositionXmlParser;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinUastResolveProviderService;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u00a0\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u001c\n\u0002\b\u0006\u001a\u0006\u0010\t\u001a\u00020\u0004\u001a)\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\u0004\b\u0000\u0010\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u000b0\r\"\u0002H\u000bH\u0007\u00a2\u0006\u0002\u0010\u000e\u001a$\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\"\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u00012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00012\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u001a#\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010\r\u00a2\u0006\u0002\u0010%\u001a&\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0004\u001a \u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020\u00012\b\b\u0002\u0010/\u001a\u00020(\u001a\u0016\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u0001\u001a$\u00103\u001a\u0004\u0018\u00010\u00012\u0006\u00101\u001a\u00020\u00012\b\u0010\u0018\u001a\u0004\u0018\u00010\u00012\b\u00102\u001a\u0004\u0018\u00010\u0001\u001a\u001e\u00104\u001a\u00020\u00012\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u0001062\b\b\u0002\u00107\u001a\u00020(\u001a2\u00104\u001a\u00020\u00012\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u0001062\b\b\u0002\u00107\u001a\u00020(2\b\b\u0002\u00108\u001a\u00020\u00042\b\b\u0002\u00109\u001a\u00020\u0004\u001a\u0010\u0010:\u001a\u0004\u0018\u00010\u00012\u0006\u0010;\u001a\u00020\u0001\u001a\u000e\u0010<\u001a\u00020\u00012\u0006\u0010=\u001a\u00020\u0001\u001a\u000e\u0010>\u001a\u00020(2\u0006\u0010?\u001a\u00020@\u001a\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020B062\u0006\u0010?\u001a\u00020@\u001a\u0018\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020D2\u0006\u0010F\u001a\u00020D\u001a\u0016\u0010C\u001a\u0004\u0018\u00010D2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020D06\u001a\u001e\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020D2\u0006\u0010M\u001a\u00020\u0004\u001a\u0018\u0010H\u001a\u00020I2\b\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010M\u001a\u00020\u0004\u001a\u0016\u0010P\u001a\u00020\u00012\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020Q\u001a\u0016\u0010P\u001a\u00020\u00012\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020D\u001a\u001c\u0010R\u001a\b\u0012\u0004\u0012\u00020\u0001062\u0006\u0010S\u001a\u00020\u00012\u0006\u0010T\u001a\u00020\u0001\u001a&\u0010U\u001a\n\u0012\u0004\u0012\u00020V\u0018\u0001062\u0006\u0010\u001d\u001a\u00020W2\u0006\u0010J\u001a\u00020K2\u0006\u0010X\u001a\u00020\u0001\u001a\u000e\u0010Y\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0010\u0010Z\u001a\u0004\u0018\u00010\u00012\u0006\u0010[\u001a\u00020\\\u001a\u0016\u0010]\u001a\u00020^2\u0006\u0010\u001d\u001a\u00020W2\u0006\u0010_\u001a\u00020^\u001a\u0016\u0010]\u001a\u00020^2\u0006\u0010`\u001a\u00020a2\u0006\u0010_\u001a\u00020^\u001a\u0016\u0010]\u001a\u00020^2\u0006\u0010`\u001a\u00020b2\u0006\u0010_\u001a\u00020^\u001a\u000e\u0010c\u001a\u00020\u00012\u0006\u0010d\u001a\u00020D\u001a\u0010\u0010e\u001a\u0004\u0018\u00010f2\u0006\u0010g\u001a\u00020h\u001a\u0010\u0010e\u001a\u0004\u0018\u00010f2\u0006\u0010i\u001a\u00020\u0001\u001a\u0010\u0010j\u001a\u0004\u0018\u00010\u00012\u0006\u0010k\u001a\u00020\u0001\u001a\u0010\u0010l\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0010\u0010m\u001a\u0004\u0018\u00010n2\u0006\u0010?\u001a\u00020n\u001a\u000e\u0010o\u001a\u00020(2\u0006\u0010?\u001a\u00020n\u001a\u0010\u0010p\u001a\u0004\u0018\u00010n2\u0006\u0010?\u001a\u00020n\u001a\u000e\u0010q\u001a\u00020(2\u0006\u0010?\u001a\u00020n\u001a\u0010\u0010r\u001a\u0004\u0018\u00010\u00012\u0006\u0010s\u001a\u00020\u0001\u001a\u001c\u0010t\u001a\b\u0012\u0004\u0012\u00020u062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010v\u001a\u00020w\u001a6\u0010x\u001a\n\u0012\u0004\u0012\u00020y\u0018\u0001062\u0006\u0010\u001d\u001a\u00020W2\u0006\u0010J\u001a\u00020K2\u0006\u0010X\u001a\u00020\u00012\u0006\u0010z\u001a\u00020\u00012\u0006\u0010{\u001a\u00020\u0001\u001a\u001c\u0010|\u001a\b\u0012\u0004\u0012\u00020u062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010v\u001a\u00020w\u001a \u0010}\u001a\u00020~2\u0006\u0010J\u001a\u00020K2\u0006\u0010\u007f\u001a\u00020D2\b\u00101\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010}\u001a\u00020~2\u0006\u0010\u001d\u001a\u00020W\u001a\u001d\u0010\u0080\u0001\u001a\u00020\u00042\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u00012\t\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u0001\u001a\u0011\u0010\u0083\u0001\u001a\u00020\u00042\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001\u001a\u0010\u0010\u0086\u0001\u001a\u00020\u00042\u0007\u0010\u0087\u0001\u001a\u00020\u0001\u001a\u001f\u0010\u0088\u0001\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020\u00012\u0006\u0010/\u001a\u00020(\u001a\u0018\u0010\u0089\u0001\u001a\u00020\u00042\u0006\u0010g\u001a\u00020h2\u0007\u0010\u008a\u0001\u001a\u00020\u0004\u001a\u0011\u0010\u008b\u0001\u001a\u00020\u00042\b\u0010`\u001a\u0004\u0018\u00010a\u001a\u0011\u0010\u008c\u0001\u001a\u00020\u00042\b\u0010\u008d\u0001\u001a\u00030\u008e\u0001\u001a\u0013\u0010\u008f\u0001\u001a\u00020\u00042\n\u0010\u0090\u0001\u001a\u0005\u0018\u00010\u0091\u0001\u001a\u0011\u0010\u008f\u0001\u001a\u00020\u00042\b\u0010`\u001a\u0004\u0018\u00010a\u001a\u0010\u0010\u0092\u0001\u001a\u00020\u00042\u0007\u0010\u0093\u0001\u001a\u00020\u0001\u001a\u0013\u0010\u0094\u0001\u001a\u00020\u00042\n\u0010\u0090\u0001\u001a\u0005\u0018\u00010\u0091\u0001\u001a\u0011\u0010\u0094\u0001\u001a\u00020\u00042\b\u0010`\u001a\u0004\u0018\u00010a\u001a\u0010\u0010\u0095\u0001\u001a\u00020\u00042\u0007\u0010\u0093\u0001\u001a\u00020\u0001\u001a\u0012\u0010\u0096\u0001\u001a\u00020\u00042\t\u0010\u0097\u0001\u001a\u0004\u0018\u00010D\u001a\u0010\u0010\u0098\u0001\u001a\u00020\u00042\u0007\u0010\u0087\u0001\u001a\u00020\u0001\u001a5\u0010\u0099\u0001\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020W2\u0007\u0010\u009a\u0001\u001a\u00020(2\u0007\u0010\u009b\u0001\u001a\u00020(2\u0007\u0010\u009c\u0001\u001a\u00020(2\t\b\u0002\u0010\u009d\u0001\u001a\u00020\u0004\u001a\u0011\u0010\u009e\u0001\u001a\u00020\u00042\b\u0010`\u001a\u0004\u0018\u00010a\u001a\u0011\u0010\u009f\u0001\u001a\u00020\u00042\b\u0010-\u001a\u0004\u0018\u00010\u0001\u001a\u000f\u0010\u00a0\u0001\u001a\u00020\u00042\u0006\u0010`\u001a\u00020B\u001a\u001b\u0010\u00a1\u0001\u001a\u00020\u00042\b\u0010E\u001a\u0004\u0018\u00010D2\b\u0010F\u001a\u0004\u0018\u00010D\u001a\u0011\u0010\u00a2\u0001\u001a\u00020\u00042\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001\u001a\u0011\u0010\u00a3\u0001\u001a\u00020\u00042\b\u0010\u008d\u0001\u001a\u00030\u00a4\u0001\u001a\u0013\u0010\u00a5\u0001\u001a\u00020\u00042\b\u0010\u00a6\u0001\u001a\u00030\u00a7\u0001H\u0002\u001a\u0011\u0010\u00a8\u0001\u001a\u00020\u00042\b\u0010`\u001a\u0004\u0018\u00010a\u001a\u000f\u0010\u00a9\u0001\u001a\u00020\u00042\u0006\u0010L\u001a\u00020D\u001a\u0013\u0010\u00aa\u0001\u001a\u0004\u0018\u00010a2\b\u0010`\u001a\u0004\u0018\u00010a\u001a\u001b\u0010\u00ab\u0001\u001a\u00020\u00012\u0007\u0010\u00ac\u0001\u001a\u00020(2\u0007\u0010\u00ad\u0001\u001a\u00020\u0001H\u0002\u001a\u0013\u0010\u00ae\u0001\u001a\u0004\u0018\u00010a2\b\u0010`\u001a\u0004\u0018\u00010a\u001a#\u0010\u00af\u0001\u001a\u0004\u0018\u00010O2\u0006\u0010J\u001a\u00020K2\u0007\u0010\u00b0\u0001\u001a\u00020\u00012\u0007\u0010\u00b1\u0001\u001a\u00020(\u001a#\u0010\u00b2\u0001\u001a\u0004\u0018\u00010\u00012\u0006\u0010J\u001a\u00020K2\u0007\u0010\u00b0\u0001\u001a\u00020\u00012\u0007\u0010\u00b1\u0001\u001a\u00020(\u001a\u000f\u0010\u00b3\u0001\u001a\u00020\u00012\u0006\u0010`\u001a\u00020B\u001a\u001b\u0010\u00b4\u0001\u001a\u0004\u0018\u00010\u00012\b\u0010\u001d\u001a\u0004\u0018\u00010W2\u0006\u0010\u0019\u001a\u00020\u0001\u001a5\u0010\u00b5\u0001\u001a\u0004\u0018\u00010\u00012\b\u0010\u001d\u001a\u0004\u0018\u00010W2\u0007\u0010\u00b6\u0001\u001a\u00020\u00012\u0017\b\u0002\u0010\u00b7\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0010\u001a\u0013\u0010\u00b8\u0001\u001a\u0004\u0018\u00010a2\b\u0010`\u001a\u0004\u0018\u00010a\u001a\u0013\u0010\u00b8\u0001\u001a\u0004\u0018\u00010b2\b\u0010`\u001a\u0004\u0018\u00010b\u001a\u0017\u0010\u00b9\u0001\u001a\t\u0012\u0004\u0012\u00020\u00010\u00ba\u00012\u0007\u0010\u00bb\u0001\u001a\u00020\u0001\u001a \u0010\u00bc\u0001\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00012\u0007\u0010\u00bd\u0001\u001a\u00020(\u001a\u0012\u0010\u00be\u0001\u001a\u00020\u00012\t\u0010\u00bf\u0001\u001a\u0004\u0018\u00010\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u00c0\u0001"}, d2={"UTF_16", "", "UTF_16LE", "tryPrefixLookup", "", "getTryPrefixLookup", "()Z", "setTryPrefixLookup", "(Z)V", "assertionsEnabled", "coalesce", "T", "ts", "", "([Ljava/lang/Object;)Ljava/lang/Object;", "computeKotlinArgumentMapping", "", "Lorg/jetbrains/uast/UExpression;", "Lcom/intellij/psi/PsiParameter;", "call", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "computeResourceName", "prefix", "name", "folderType", "Lcom/android/resources/ResourceFolderType;", "computeResourcePrefix", "project", "Lcom/android/builder/model/AndroidProject;", "convertVersion", "Lcom/android/sdklib/AndroidVersion;", "api", "Lcom/android/builder/model/ApiVersion;", "targets", "Lcom/android/sdklib/IAndroidTarget;", "(Lcom/android/builder/model/ApiVersion;[Lcom/android/sdklib/IAndroidTarget;)Lcom/android/sdklib/AndroidVersion;", "describeCounts", "errorCount", "", "warningCount", "comma", "capitalize", "editDistance", "s", "t", "max", "endsWith", "string", "suffix", "findSubstring", "formatList", "strings", "", "maxItems", "sort", "useConjunction", "getAutoBoxedType", "primitive", "getBaseName", "fileName", "getChildCount", "node", "Lorg/w3c/dom/Node;", "getChildren", "Lorg/w3c/dom/Element;", "getCommonParent", "Ljava/io/File;", "file1", "file2", "files", "getEncodedString", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "file", "createString", "data", "", "getFileNameWithParent", "Lcom/android/ide/common/util/PathString;", "getFormattedParameters", "format", "errorMessage", "getInheritedStyles", "Lcom/android/ide/common/rendering/api/StyleResourceValue;", "Lcom/android/tools/lint/detector/api/Project;", "styleUrl", "getInternalMethodName", "getInternalName", "psiClass", "Lcom/intellij/psi/PsiClass;", "getLanguageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "defaultLevel", "element", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/uast/UElement;", "getLayoutName", "layoutFile", "getLocale", "Lcom/android/ide/common/resources/configuration/LocaleQualifier;", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "parent", "getLocaleAndRegion", "folderName", "getMethodName", "getNextInstruction", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "getNextOpcode", "getPrevInstruction", "getPrevOpcode", "getPrimitiveType", "autoBoxedType", "getSourceProviders", "Lcom/android/builder/model/SourceProvider;", "variant", "Lcom/android/builder/model/Variant;", "getStyleAttributes", "Lcom/android/ide/common/rendering/api/ResourceValue;", "namespaceUri", "attribute", "getTestSourceProviders", "guessGradleLocation", "Lcom/android/tools/lint/detector/api/Location;", "projectDir", "idReferencesMatch", "id1", "id2", "isAnonymousClass", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "isDataBindingExpression", "expression", "isEditableTo", "isEnglishResource", "assumeForBase", "isFalseLiteral", "isFileBasedResourceType", "type", "Lcom/android/resources/ResourceType;", "isJava", "language", "Lcom/intellij/lang/Language;", "isJavaKeyword", "keyword", "isKotlin", "isKotlinHardKeyword", "isManifestFolder", "dir", "isManifestPlaceHolderExpression", "isModelOlderThan", "major", "minor", "micro", "defaultForNonGradleProjects", "isNullLiteral", "isNumberString", "isRootElement", "isSameResourceFile", "isStaticInnerClass", "isString", "Lcom/intellij/psi/PsiType;", "isTestArtifact", "extra", "Lcom/android/builder/model/SourceProviderContainer;", "isTrueLiteral", "isXmlFile", "nextNonWhitespace", "pluralize", "count", "one", "prevNonWhitespace", "readUrlData", "query", "timeout", "readUrlDataAsString", "resolveManifestName", "resolvePlaceHolder", "resolvePlaceHolders", "value", "fallbacks", "skipParentheses", "splitPath", "", "path", "startsWith", "offset", "stripIdPrefix", "id", "android.sdktools.lint-api"})
@JvmName(name="Lint")
public final class Lint {
    private static boolean tryPrefixLookup = true;
    private static final String UTF_16 = "UTF_16";
    private static final String UTF_16LE = "UTF_16LE";

    public static final boolean getTryPrefixLookup() {
        return tryPrefixLookup;
    }

    public static final void setTryPrefixLookup(boolean bl) {
        tryPrefixLookup = bl;
    }

    @Nullable
    public static final String getInternalName(@NotNull PsiClass psiClass) {
        PsiClass parent;
        if (psiClass instanceof PsiAnonymousClass && (parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)psiClass), PsiClass.class)) != null) {
            String string = Lint.getInternalName(parent);
            if (string == null) {
                return null;
            }
            String internalName = string;
            StringBuilder stringBuilder = new StringBuilder().append(internalName);
            String string2 = JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)psiClass));
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            return stringBuilder.append(string2).toString();
        }
        String sig = ClassUtil.getJVMClassName((PsiClass)psiClass);
        if (sig == null) {
            String qualifiedName = psiClass.getQualifiedName();
            return qualifiedName != null ? ClassContext.Companion.getInternalName(qualifiedName) : null;
        }
        if (StringsKt.indexOf$default((CharSequence)sig, (char)'.', (int)0, (boolean)false, (int)6, null) != -1) {
            sig = ClassContext.Companion.getInternalName(sig);
        }
        return sig;
    }

    @NotNull
    public static final String getInternalMethodName(@NotNull PsiMethod method) {
        return method.isConstructor() ? "<init>" : method.getName();
    }

    @NotNull
    public static final String formatList(@NotNull List<String> strings, int maxItems) {
        return Lint.formatList$default(strings, maxItems, true, false, 8, null);
    }

    @NotNull
    public static /* synthetic */ String formatList$default(List list2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return Lint.formatList(list2, n);
    }

    @NotNull
    public static final String formatList(@NotNull List<String> strings, int maxItems, boolean sort, boolean useConjunction) {
        List sortedStrings = strings;
        if (sort) {
            ArrayList sorted = new ArrayList(sortedStrings);
            CollectionsKt.sort((List)sorted);
            sortedStrings = sorted;
        }
        StringBuilder sb = new StringBuilder(20 * sortedStrings.size());
        int n = sortedStrings.size();
        for (int i = 0; i < n; ++i) {
            CharSequence charSequence = sb;
            if (charSequence.length() > 0) {
                if (useConjunction && i == n - 1) {
                    sb.append(" and ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append((String)sortedStrings.get(i));
            if (maxItems <= 0 || i != maxItems - 1 || n <= maxItems) continue;
            charSequence = StringCompanionObject.INSTANCE;
            String string = "... (%1$d more)";
            Object[] objectArray = new Object[]{n - i - 1};
            StringBuilder stringBuilder = sb;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            stringBuilder.append(string3);
            break;
        }
        return sb.toString();
    }

    @NotNull
    public static /* synthetic */ String formatList$default(List list2, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return Lint.formatList(list2, n, bl, bl2);
    }

    public static final boolean isFileBasedResourceType(@NotNull ResourceType type) {
        List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)type);
        for (ResourceFolderType folderType : folderTypes) {
            if (folderType == ResourceFolderType.VALUES) continue;
            return type != ResourceType.ID;
        }
        return false;
    }

    public static final boolean isXmlFile(@NotNull File file) {
        return SdkUtils.endsWithIgnoreCase((String)file.getPath(), (String)".xml");
    }

    public static final boolean endsWith(@NotNull String string, @NotNull String suffix) {
        return StringsKt.regionMatches((String)string, (int)(string.length() - suffix.length()), (String)suffix, (int)0, (int)suffix.length(), (boolean)true);
    }

    public static final boolean startsWith(@NotNull String string, @NotNull String prefix, int offset) {
        return StringsKt.regionMatches((String)string, (int)offset, (String)prefix, (int)0, (int)prefix.length(), (boolean)true);
    }

    @NotNull
    public static final String getBaseName(@NotNull String fileName) {
        String string;
        int extension = StringsKt.indexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (extension > 0) {
            String string2 = fileName;
            int n = 0;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, extension);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = fileName;
        }
        return string;
    }

    @NotNull
    public static final String describeCounts(int errorCount, int warningCount, boolean comma, boolean capitalize) {
        String string;
        if (errorCount == 0 && warningCount == 0) {
            return capitalize ? "No errors or warnings" : "no errors or warnings";
        }
        String errors = Lint.pluralize(errorCount, "error");
        String warnings = Lint.pluralize(warningCount, "warning");
        if (errorCount == 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%1$d %2$s";
            Object[] objectArray = new Object[]{warningCount, warnings};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        } else if (warningCount == 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string4 = "%1$d %2$s";
            Object[] objectArray = new Object[]{errorCount, errors};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
        } else {
            String conjunction = comma ? "," : " and";
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string6 = "%1$d %2$s%3$s %4$d %5$s";
            Object[] objectArray = new Object[]{errorCount, errors, conjunction, warningCount, warnings};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(format, *args)");
        }
        return string;
    }

    private static final String pluralize(int count, String one) {
        return count == 1 ? one : one + "s";
    }

    @NotNull
    public static final List<Element> getChildren(@NotNull Node node) {
        NodeList childNodes = node.getChildNodes();
        ArrayList<Element> children = new ArrayList<Element>(childNodes.getLength());
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            Node node2 = child;
            if (node2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            children.add((Element)node2);
        }
        return children;
    }

    public static final int getChildCount(@NotNull Node node) {
        return XmlUtils.getSubTagCount((Node)node);
    }

    public static final boolean isRootElement(@NotNull Element element) {
        return element == element.getOwnerDocument().getDocumentElement();
    }

    @NotNull
    public static final String stripIdPrefix(@Nullable String id) {
        String string;
        if (id == null) {
            string = "";
        } else if (StringsKt.startsWith$default((String)id, (String)"@+id/", (boolean)false, (int)2, null)) {
            String string2 = id;
            int n = "@+id/".length();
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        } else if (StringsKt.startsWith$default((String)id, (String)"@id/", (boolean)false, (int)2, null)) {
            String string4 = id;
            int n = "@id/".length();
            String string5 = string4.substring(n);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = id;
        }
        return string;
    }

    public static final boolean idReferencesMatch(@Nullable String id1, @Nullable String id2) {
        boolean bl;
        CharSequence charSequence;
        if (id1 == null || id2 == null || (charSequence = (CharSequence)id1).length() == 0 || (charSequence = (CharSequence)id2).length() == 0) {
            return false;
        }
        if (StringsKt.startsWith$default((String)id1, (String)"@+id/", (boolean)false, (int)2, null)) {
            boolean bl2;
            if (StringsKt.startsWith$default((String)id2, (String)"@+id/", (boolean)false, (int)2, null)) {
                bl2 = Intrinsics.areEqual((Object)id1, (Object)id2);
            } else {
                boolean bl3 = StringsKt.startsWith$default((String)id2, (String)"@id/", (boolean)false, (int)2, null);
                if (_Assertions.ENABLED && !bl3) {
                    boolean bl4 = false;
                    String string = id2;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                bl2 = id1.length() - id2.length() == 1 && StringsKt.regionMatches$default((String)id1, (int)"@+id/".length(), (String)id2, (int)"@id/".length(), (int)(id2.length() - "@id/".length()), (boolean)false, (int)16, null);
            }
            return bl2;
        }
        boolean bl5 = StringsKt.startsWith$default((String)id1, (String)"@id/", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl5) {
            boolean bl6 = false;
            String string = id1;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (StringsKt.startsWith$default((String)id2, (String)"@id/", (boolean)false, (int)2, null)) {
            bl = Intrinsics.areEqual((Object)id1, (Object)id2);
        } else {
            bl5 = StringsKt.startsWith$default((String)id2, (String)"@+id/", (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl5) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            bl = id2.length() - id1.length() == 1 && StringsKt.regionMatches$default((String)id2, (int)"@+id/".length(), (String)id1, (int)"@id/".length(), (int)(id1.length() - "@id/".length()), (boolean)false, (int)16, null);
        }
        return bl;
    }

    @NotNull
    public static final String getFileNameWithParent(@NotNull LintClient client, @NotNull File file) {
        return client.getDisplayPath(new File(file.getParentFile().getName(), file.getName()));
    }

    @NotNull
    public static final String getFileNameWithParent(@NotNull LintClient client, @NotNull PathString file) {
        PathString pathString = file.getParent();
        if (pathString == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        PathString parent = pathString;
        return client.getDisplayPath(new File(parent.getFileName(), file.getFileName()));
    }

    public static final boolean isEditableTo(@NotNull String s, @NotNull String t, int max) {
        return Lint.editDistance(s, t, max) <= max;
    }

    /*
     * WARNING - void declaration
     */
    public static final int editDistance(@NotNull String s, @NotNull String t, int max) {
        int j;
        int i;
        int i$iv;
        if (Intrinsics.areEqual((Object)s, (Object)t)) {
            return 0;
        }
        if (Math.abs(s.length() - t.length()) > max) {
            return Integer.MAX_VALUE;
        }
        int m = s.length();
        int n = t.length();
        int size$iv = m + 1;
        int[][] result$iv = new int[size$iv][];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            void var10_10 = i$iv;
            int n4 = i$iv++;
            int[][] nArrayArray = result$iv;
            boolean bl = false;
            int[] nArray = new int[n + 1];
            nArrayArray[n4] = nArray;
        }
        int[][] d = result$iv;
        size$iv = 0;
        int n5 = m;
        if (size$iv <= n5) {
            while (true) {
                d[i][0] = i;
                if (i == n5) break;
                ++i;
            }
        }
        if ((i = 0) <= (n5 = n)) {
            while (true) {
                d[0][j] = j;
                if (j == n5) break;
                ++j;
            }
        }
        if ((j = 1) <= (n5 = n)) {
            while (true) {
                if ((i$iv = 1) <= (n3 = m)) {
                    while (true) {
                        void i2;
                        if (s.charAt((int)(i2 - true)) == t.charAt(j - 1)) {
                            d[i2][j] = d[i2 - true][j - 1];
                        } else {
                            int deletion = d[i2 - true][j] + 1;
                            int insertion = d[i2][j - 1] + 1;
                            int substitution = d[i2 - true][j - 1] + 1;
                            d[i2][j] = Math.min(deletion, Math.min(insertion, substitution));
                        }
                        if (i2 == n3) break;
                        ++i2;
                    }
                }
                if (j == n5) break;
                ++j;
            }
        }
        return d[m][n];
    }

    public static /* synthetic */ int editDistance$default(String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        return Lint.editDistance(string, string2, n);
    }

    public static final boolean assertionsEnabled() {
        return LintJavaUtils.assertionsEnabled();
    }

    @NotNull
    public static final String getLayoutName(@NotNull File layoutFile) {
        String name = layoutFile.getName();
        int dotIndex = StringsKt.indexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dotIndex != -1) {
            String string = name;
            int n = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, dotIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            name = string3;
        }
        return name;
    }

    @NotNull
    public static final Iterable<String> splitPath(@NotNull String path2) {
        if (StringsKt.indexOf$default((CharSequence)path2, (char)';', (int)0, (boolean)false, (int)6, null) != -1) {
            return Splitter.on((char)';').omitEmptyStrings().trimResults().split((CharSequence)path2);
        }
        ArrayList<String> combined = new ArrayList<String>();
        Iterables.addAll((Collection)combined, (Iterable)Splitter.on((char)':').omitEmptyStrings().trimResults().split((CharSequence)path2));
        int n = combined.size();
        for (int i = 0; i < n; ++i) {
            CharSequence charSequence;
            String p = (String)combined.get(i);
            if (p.length() != 1 || i >= n - 1 || !Character.isLetter(p.charAt(0)) || (charSequence = (CharSequence)combined.get(i + 1)).length() == 0 || ((String)combined.get(i + 1)).charAt(0) != '\\') continue;
            combined.set(i, p + ":" + (String)combined.get(i + 1));
            combined.remove(i + 1);
            --n;
        }
        return combined;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final File getCommonParent(@NotNull List<? extends File> files) {
        int fileCount = files.size();
        switch (fileCount) {
            case 0: {
                return null;
            }
            case 1: {
                return files.get(0);
            }
            case 2: {
                return Lint.getCommonParent(files.get(0), files.get(1));
            }
        }
        File common = files.get(0);
        int n = 1;
        int n2 = fileCount;
        while (n < n2) {
            void i;
            File file = common;
            if (file == null) {
                Intrinsics.throwNpe();
            }
            if ((common = Lint.getCommonParent(file, files.get((int)i))) == null) {
                return null;
            }
            ++i;
        }
        return common;
    }

    @Nullable
    public static final File getCommonParent(@NotNull File file1, @NotNull File file2) {
        if (Intrinsics.areEqual((Object)file1, (Object)file2)) {
            return file1;
        }
        if (StringsKt.startsWith$default((String)file1.getPath(), (String)file2.getPath(), (boolean)false, (int)2, null)) {
            return file2;
        }
        if (StringsKt.startsWith$default((String)file2.getPath(), (String)file1.getPath(), (boolean)false, (int)2, null)) {
            return file1;
        }
        for (File first = file1.getParentFile(); first != null; first = first.getParentFile()) {
            for (File second = file2.getParentFile(); second != null; second = second.getParentFile()) {
                if (!Intrinsics.areEqual((Object)first, (Object)second)) continue;
                return first;
            }
        }
        return null;
    }

    @NotNull
    public static final CharSequence getEncodedString(@NotNull LintClient client, @NotNull File file, boolean createString) throws IOException {
        byte[] bytes = client.readBytes(file);
        return Lint.endsWith(file.getName(), ".xml") ? (CharSequence)PositionXmlParser.getXmlString((byte[])bytes) : Lint.getEncodedString(bytes, createString);
    }

    public static final boolean isDataBindingExpression(@NotNull String expression) {
        return StringsKt.startsWith$default((String)expression, (String)"@{", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)expression, (String)"@={", (boolean)false, (int)2, null);
    }

    public static final boolean isManifestPlaceHolderExpression(@NotNull String expression) {
        return StringsKt.contains$default((CharSequence)expression, (CharSequence)"${", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CharSequence getEncodedString(@Nullable byte[] data, boolean createString) {
        if (data == null) {
            return "";
        }
        int offset = 0;
        String defaultCharset = "UTF-8";
        String charset = null;
        if (data.length > 4) {
            if (data[0] == (byte)239 && data[1] == (byte)187 && data[2] == (byte)191) {
                defaultCharset = charset = "UTF-8";
                offset += 3;
            } else if (data[0] == (byte)254 && data[1] == (byte)255) {
                defaultCharset = charset = UTF_16;
                offset += 2;
            } else if (data[0] == (byte)0 && data[1] == (byte)0 && data[2] == (byte)254 && data[3] == (byte)255) {
                defaultCharset = charset = "UTF_32";
                offset += 4;
            } else if (data[0] == (byte)255 && data[1] == (byte)254 && data[2] == (byte)0 && data[3] == (byte)0) {
                defaultCharset = charset = "UTF_32LE";
                offset += 4;
            } else if (data[0] == (byte)255 && data[1] == (byte)254) {
                defaultCharset = charset = UTF_16LE;
                offset += 2;
            }
        }
        int length = data.length - offset;
        boolean seenOddZero = false;
        boolean seenEvenZero = false;
        int n = offset;
        int n2 = data.length;
        while (n < n2) {
            void lineEnd;
            if (data[lineEnd] == 0) {
                if ((lineEnd - offset) % 2 == false) {
                    seenEvenZero = true;
                } else {
                    seenOddZero = true;
                }
            } else if (data[lineEnd] == (byte)10 || data[lineEnd] == (byte)13) break;
            ++lineEnd;
        }
        if (charset == null) {
            String string = seenOddZero ? UTF_16LE : (charset = seenEvenZero ? UTF_16 : "UTF-8");
        }
        if (!createString && Intrinsics.areEqual((Object)"UTF-8", (Object)charset)) {
            ByteBuffer bytes = ByteBuffer.wrap(data, offset, length);
            try {
                boolean bl;
                CharBuffer decode = Charsets.UTF_8.newDecoder().decode(bytes);
                decode.compact();
                int size = decode.position();
                boolean bl2 = bl = size <= decode.limit();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                char[] array = decode.array();
                return CharSequences.createSequence((char[])array, (int)0, (int)size);
            }
            catch (CharacterCodingException decode) {
                // empty catch block
            }
        }
        CharSequence text = null;
        try {
            Charset charset2 = Charset.forName(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)charset2, (String)"Charset.forName(charsetName)");
            Charset decode = charset2;
            text = new String(data, offset, length, decode);
        }
        catch (UnsupportedEncodingException e) {
            try {
                if (Intrinsics.areEqual((Object)charset, (Object)defaultCharset) ^ true) {
                    Charset charset3 = Charset.forName(defaultCharset);
                    Intrinsics.checkExpressionValueIsNotNull((Object)charset3, (String)"Charset.forName(charsetName)");
                    Charset charset4 = charset3;
                    text = new String(data, offset, length, charset4);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (text == null) {
            text = new String(data, offset, length, kotlin.text.Charsets.UTF_8);
        }
        return text;
    }

    public static final boolean isStaticInnerClass(@NotNull ClassNode classNode) {
        List fieldList = classNode.fields;
        Iterator iterator = fieldList.iterator();
        while (iterator.hasNext()) {
            Object f;
            Object e = f = iterator.next();
            if (e == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.objectweb.asm.tree.FieldNode");
            }
            FieldNode field = (FieldNode)e;
            if (!StringsKt.startsWith$default((String)field.name, (String)"this$", (boolean)false, (int)2, null) || (field.access & 0x1000) == 0) continue;
            return false;
        }
        return true;
    }

    public static final boolean isAnonymousClass(@NotNull ClassNode classNode) {
        if (classNode.outerClass == null) {
            return false;
        }
        String name = classNode.name;
        int index = StringsKt.lastIndexOf$default((CharSequence)name, (char)'$', (int)0, (boolean)false, (int)6, null);
        return index == -1 || index == name.length() - 1 ? false : Character.isDigit(name.charAt(index + 1));
    }

    public static final int getPrevOpcode(@NotNull AbstractInsnNode node) {
        AbstractInsnNode prev;
        AbstractInsnNode abstractInsnNode = prev = Lint.getPrevInstruction(node);
        return abstractInsnNode != null ? abstractInsnNode.getOpcode() : 0;
    }

    @Nullable
    public static final AbstractInsnNode getPrevInstruction(@NotNull AbstractInsnNode node) {
        int type;
        AbstractInsnNode prev = node;
        do {
            AbstractInsnNode abstractInsnNode = prev;
            if (abstractInsnNode == null) {
                Intrinsics.throwNpe();
            }
            if ((prev = abstractInsnNode.getPrevious()) != null) continue;
            return null;
        } while ((type = prev.getType()) == 15 || type == 8 || type == 14);
        return prev;
    }

    public static final int getNextOpcode(@NotNull AbstractInsnNode node) {
        AbstractInsnNode next;
        AbstractInsnNode abstractInsnNode = next = Lint.getNextInstruction(node);
        return abstractInsnNode != null ? abstractInsnNode.getOpcode() : 0;
    }

    @Nullable
    public static final AbstractInsnNode getNextInstruction(@NotNull AbstractInsnNode node) {
        int type;
        AbstractInsnNode next = node;
        do {
            AbstractInsnNode abstractInsnNode = next;
            if (abstractInsnNode == null) {
                Intrinsics.throwNpe();
            }
            if ((next = abstractInsnNode.getNext()) != null) continue;
            return null;
        } while ((type = next.getType()) == 15 || type == 8 || type == 14);
        return next;
    }

    public static final boolean isManifestFolder(@Nullable File dir) {
        File file = dir;
        if (file == null) {
            return false;
        }
        File current = file;
        boolean hasManifest = new File(current, "AndroidManifest.xml").exists();
        if (hasManifest && Intrinsics.areEqual((Object)current.getName(), (Object)"bin") && (current = current.getParentFile()) != null && Lint.isManifestFolder(current)) {
            return false;
        }
        return hasManifest;
    }

    @Nullable
    public static final String getLocaleAndRegion(@NotNull String folderName) {
        if (StringsKt.indexOf$default((CharSequence)folderName, (char)'-', (int)0, (boolean)false, (int)6, null) == -1) {
            return null;
        }
        String locale = null;
        for (String qualifier : FolderConfiguration.QUALIFIER_SPLITTER.split((CharSequence)folderName)) {
            char c;
            char second;
            char first;
            int qualifierLength = qualifier.length();
            if (qualifierLength == 2) {
                first = qualifier.charAt(0);
                second = qualifier.charAt(1);
                c = first;
                if ('a' > c || 'z' < c || 'a' > (c = second) || 'z' < c) continue;
                locale = qualifier;
                continue;
            }
            if (qualifierLength == 3 && qualifier.charAt(0) == 'r' && locale != null) {
                first = qualifier.charAt(1);
                second = qualifier.charAt(2);
                c = first;
                if ('A' > c || 'Z' < c || 'A' > (c = second) || 'Z' < c) break;
                return locale + "-" + qualifier;
            }
            if (!StringsKt.startsWith$default((String)qualifier, (String)"b+", (boolean)false, (int)2, null)) continue;
            return qualifier;
        }
        return locale;
    }

    @Nullable
    public static final List<ResourceValue> getStyleAttributes(@NotNull Project project, @NotNull LintClient client, @NotNull String styleUrl, @NotNull String namespaceUri, @NotNull String attribute) {
        if (!client.supportsProjectResources()) {
            return null;
        }
        ResourceRepository resourceRepository = client.getResourceRepository(project, true, true);
        if (resourceRepository == null) {
            return null;
        }
        ResourceRepository resources = resourceRepository;
        ResourceUrl style = ResourceUrl.parse((String)styleUrl);
        if (style == null || style.isFramework()) {
            return null;
        }
        List result = null;
        ArrayDeque<ResourceValueImpl> queue = new ArrayDeque<ResourceValueImpl>();
        queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, style.type, style.name, null));
        HashSet<String> seen = new HashSet<String>();
        for (int count = 0; count < 30 && !queue.isEmpty(); ++count) {
            ResourceValue front = (ResourceValue)queue.remove();
            String name = front.getName();
            seen.add(name);
            List items = resources.getResources(ResourceNamespace.TODO(), front.getResourceType(), name);
            for (ResourceItem item : items) {
                String parentName;
                int index;
                ResourceUrl p;
                String parent;
                ResourceValue rv = item.getResourceValue();
                if (!(rv instanceof StyleResourceValue)) continue;
                StyleResourceValue srv = (StyleResourceValue)rv;
                ResourceNamespace namespace = (ResourceNamespace)MoreObjects.firstNonNull((Object)ResourceNamespace.fromNamespaceUri((String)namespaceUri), (Object)ResourceNamespace.TODO());
                StyleItemResourceValue value = srv.getItem(namespace, attribute);
                if (value != null) {
                    if (result == null) {
                        result = new ArrayList();
                    }
                    if (!result.contains(value)) {
                        result.add(value);
                    }
                }
                if (!((parent = srv.getParentStyleName()) == null || StringsKt.startsWith$default((String)parent, (String)"@android:", (boolean)false, (int)2, null) || (p = ResourceUrl.parse((String)parent)) == null || p.isFramework() || seen.contains(p.name))) {
                    seen.add(p.name);
                    queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STYLE, p.name, null));
                }
                if ((index = StringsKt.lastIndexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null)) <= 0) continue;
                String string = name;
                int n = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n, index), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                if (seen.contains(parentName)) continue;
                seen.add(parentName);
                queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STYLE, parentName, null));
            }
        }
        return result;
    }

    @Nullable
    public static final List<StyleResourceValue> getInheritedStyles(@NotNull Project project, @NotNull LintClient client, @NotNull String styleUrl) {
        if (!client.supportsProjectResources()) {
            return null;
        }
        ResourceRepository resourceRepository = client.getResourceRepository(project, true, true);
        if (resourceRepository == null) {
            return null;
        }
        ResourceRepository resources = resourceRepository;
        ResourceUrl style = ResourceUrl.parse((String)styleUrl);
        if (style == null || style.isFramework()) {
            return null;
        }
        List result = null;
        ArrayDeque<ResourceValueImpl> queue = new ArrayDeque<ResourceValueImpl>();
        queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, style.type, style.name, null));
        HashSet<String> seen = new HashSet<String>();
        for (int count = 0; count < 30 && !queue.isEmpty(); ++count) {
            ResourceValue front = (ResourceValue)queue.remove();
            String name = front.getName();
            seen.add(name);
            List items = resources.getResources(ResourceNamespace.TODO(), front.getResourceType(), name);
            for (ResourceItem item : items) {
                String parentName;
                int index;
                ResourceUrl p;
                ResourceValue rv = item.getResourceValue();
                if (!(rv instanceof StyleResourceValue)) continue;
                if (result == null) {
                    result = new ArrayList();
                }
                result.add(rv);
                String parent = ((StyleResourceValue)rv).getParentStyleName();
                if (!(parent == null || StringsKt.startsWith$default((String)parent, (String)"@android:", (boolean)false, (int)2, null) || (p = ResourceUrl.parse((String)parent)) == null || p.isFramework() || seen.contains(p.name))) {
                    seen.add(p.name);
                    queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STYLE, p.name, null));
                }
                if ((index = StringsKt.lastIndexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null)) <= 0) continue;
                String string = name;
                int n = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n, index), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                if (seen.contains(parentName)) continue;
                seen.add(parentName);
                queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STYLE, parentName, null));
            }
        }
        return result;
    }

    public static final boolean isSameResourceFile(@Nullable File file1, @Nullable File file2) {
        if (file1 != null && file2 != null && Intrinsics.areEqual((Object)file1.getName(), (Object)file2.getName())) {
            File parent1 = file1.getParentFile();
            File parent2 = file2.getParentFile();
            if (parent1 != null && parent2 != null && Intrinsics.areEqual((Object)parent1.getName(), (Object)parent2.getName())) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static final String computeResourcePrefix(@Nullable AndroidProject project) {
        try {
            if (tryPrefixLookup && project != null) {
                return project.getResourcePrefix();
            }
        }
        catch (Exception e) {
            tryPrefixLookup = false;
        }
        return null;
    }

    @NotNull
    public static final String computeResourceName(@NotNull String prefix, @NotNull String name, @Nullable ResourceFolderType folderType) {
        String string;
        CharSequence charSequence;
        Object object;
        String newPrefix = prefix;
        String newName = name;
        CharSequence charSequence2 = newPrefix;
        if (charSequence2.length() == 0) {
            return newName;
        }
        if (folderType != null && folderType != ResourceFolderType.VALUES) {
            charSequence2 = newName;
            object = Locale.ROOT;
            CharSequence charSequence3 = charSequence2;
            if (charSequence3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)charSequence3).toLowerCase((Locale)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
            newName = string2;
            String underlined = SdkVersionInfo.camelCaseToUnderlines((String)newPrefix);
            if (Intrinsics.areEqual((Object)newPrefix, (Object)underlined) ^ true) {
                if (!StringsKt.endsWith$default((String)underlined, (String)"_", (boolean)false, (int)2, null)) {
                    underlined = underlined + "_";
                }
                newPrefix = underlined;
            }
        }
        if (!((charSequence2 = (CharSequence)newName).length() == 0) && Character.isUpperCase(newName.charAt(0))) {
            if (StringsKt.indexOf$default((CharSequence)newPrefix, (char)'_', (int)0, (boolean)false, (int)6, null) != -1) {
                newPrefix = SdkVersionInfo.underlinesToCamelCase((String)newPrefix);
            }
            char c = Character.toUpperCase(newPrefix.charAt(0));
            object = newPrefix;
            int n = 1;
            Object object2 = object;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = ((String)object2).substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            object = string3;
            newPrefix = String.valueOf(c) + (String)object;
            if (StringsKt.endsWith$default((String)newPrefix, (String)"_", (boolean)false, (int)2, null)) {
                String string4 = newPrefix;
                int n2 = 0;
                n = newPrefix.length() - 1;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n2, n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                newPrefix = string6;
            }
        }
        if ((charSequence = (CharSequence)newName).length() == 0) {
            string = newPrefix;
        } else if (StringsKt.endsWith$default((String)newPrefix, (String)"_", (boolean)false, (int)2, null)) {
            string = newPrefix + newName;
        } else {
            charSequence = newName;
            int n = 1;
            StringBuilder stringBuilder = new StringBuilder().append(newPrefix).append(Character.toUpperCase(newName.charAt(0)));
            CharSequence charSequence4 = charSequence;
            if (charSequence4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = ((String)charSequence4).substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            String string8 = string7;
            string = stringBuilder.append(string8).toString();
        }
        return string;
    }

    @NotNull
    public static /* synthetic */ String computeResourceName$default(String string, String string2, ResourceFolderType resourceFolderType, int n, Object object) {
        if ((n & 4) != 0) {
            resourceFolderType = null;
        }
        return Lint.computeResourceName(string, string2, resourceFolderType);
    }

    @NotNull
    public static final AndroidVersion convertVersion(@NotNull ApiVersion api, @Nullable IAndroidTarget[] targets) {
        String codename = api.getCodename();
        if (codename != null) {
            AndroidVersion version = SdkVersionInfo.getVersion((String)codename, (IAndroidTarget[])targets);
            AndroidVersion androidVersion = version;
            if (androidVersion == null) {
                androidVersion = new AndroidVersion(api.getApiLevel(), codename);
            }
            return androidVersion;
        }
        return new AndroidVersion(api.getApiLevel(), null);
    }

    public static final boolean isModelOlderThan(@NotNull Project project, int major, int minor, int micro, boolean defaultForNonGradleProjects) {
        GradleVersion gradleVersion = project.getGradleModelVersion();
        if (gradleVersion == null) {
            return defaultForNonGradleProjects;
        }
        GradleVersion version = gradleVersion;
        if (version.getMajor() != major) {
            return version.getMajor() < major;
        }
        return version.getMinor() != minor ? version.getMinor() < minor : version.getMicro() < micro;
    }

    public static /* synthetic */ boolean isModelOlderThan$default(Project project, int n, int n2, int n3, boolean bl, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            bl = false;
        }
        return Lint.isModelOlderThan(project, n, n2, n3, bl);
    }

    @NotNull
    public static final LanguageLevel getLanguageLevel(@NotNull UElement element, @NotNull LanguageLevel defaultLevel) {
        UFile uFile = UastUtils.getContainingFile((UElement)element);
        if (uFile == null) {
            return defaultLevel;
        }
        UFile containingFile = uFile;
        return Lint.getLanguageLevel((PsiElement)containingFile.getPsi(), defaultLevel);
    }

    @NotNull
    public static final LanguageLevel getLanguageLevel(@NotNull PsiElement element, @NotNull LanguageLevel defaultLevel) {
        PsiJavaFile psiJavaFile;
        PsiFile containingFile;
        PsiFile psiFile;
        PsiFile psiFile2;
        PsiElement psiElement = element;
        if (!(psiElement instanceof PsiFile)) {
            psiElement = null;
        }
        if ((psiFile2 = (PsiFile)psiElement) == null) {
            psiFile2 = element.getContainingFile();
        }
        if (!((psiFile = (containingFile = psiFile2)) instanceof PsiJavaFile)) {
            psiFile = null;
        }
        if ((psiJavaFile = (PsiJavaFile)psiFile) == null || (psiJavaFile = psiJavaFile.getLanguageLevel()) == null) {
            psiJavaFile = defaultLevel;
        }
        return psiJavaFile;
    }

    @NotNull
    public static final LanguageLevel getLanguageLevel(@NotNull Project project, @NotNull LanguageLevel defaultLevel) {
        com.intellij.openapi.project.Project project2 = project.getIdeaProject();
        if (project2 == null) {
            return defaultLevel;
        }
        com.intellij.openapi.project.Project p = project2;
        LanguageLevelProjectExtension languageLevelProjectExtension = LanguageLevelProjectExtension.getInstance((com.intellij.openapi.project.Project)p);
        if (languageLevelProjectExtension == null) {
            return defaultLevel;
        }
        LanguageLevelProjectExtension extension = languageLevelProjectExtension;
        return extension.getLanguageLevel();
    }

    @Nullable
    public static final String findSubstring(@NotNull String string, @Nullable String prefix, @Nullable String suffix) {
        String string2;
        int start = 0;
        if (prefix != null) {
            start = StringsKt.indexOf$default((CharSequence)string, (String)prefix, (int)0, (boolean)false, (int)6, null);
            if (start == -1) {
                return null;
            }
            start += prefix.length();
        }
        if (suffix != null) {
            String string3;
            int end = StringsKt.indexOf$default((CharSequence)string, (String)suffix, (int)start, (boolean)false, (int)4, null);
            if (end == -1) {
                string3 = null;
            } else {
                String string4;
                String string5 = string4 = string;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(start, end);
                string3 = string6;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            }
            return string3;
        }
        String string7 = string2 = string;
        if (string7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.substring(start);
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
        return string8;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getFormattedParameters(@NotNull String format, @NotNull String errorMessage) {
        int n;
        StringBuilder pattern = new StringBuilder(format.length());
        int parameter = 1;
        boolean bl = false;
        int n2 = format.length();
        for (int i = 0; i < n2; ++i) {
            char c = format.charAt(i);
            if (c == '%') {
                int n3 = n = i < format.length() - 4 ? 1 : 0;
                if (_Assertions.ENABLED && n == 0) {
                    boolean bl2 = false;
                    String string = format;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                int n4 = n = format.charAt(i + 1) == 48 + parameter ? 1 : 0;
                if (_Assertions.ENABLED && n == 0) {
                    boolean bl3 = false;
                    String string = format;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                n = Character.isDigit(format.charAt(i + 1)) ? 1 : 0;
                if (_Assertions.ENABLED && n == 0) {
                    boolean bl4 = false;
                    String string = format;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                int n5 = n = format.charAt(i + 2) == '$' ? 1 : 0;
                if (_Assertions.ENABLED && n == 0) {
                    boolean bl5 = false;
                    String string = format;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                int n6 = n = format.charAt(i + 3) == 's' ? 1 : 0;
                if (_Assertions.ENABLED && n == 0) {
                    boolean bl6 = false;
                    String string = format;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                n = parameter;
                parameter = n + 1;
                i += 3;
                pattern.append("(.*)");
                continue;
            }
            pattern.append(c);
        }
        try {
            Pattern compile = Pattern.compile(pattern.toString());
            Matcher matcher = compile.matcher(errorMessage);
            if (matcher.find()) {
                int groupCount = matcher.groupCount();
                ArrayList<String> parameters = new ArrayList<String>(groupCount);
                n = 1;
                int n7 = groupCount;
                if (n <= n7) {
                    while (true) {
                        void i;
                        parameters.add(matcher.group((int)i));
                        if (i == n7) break;
                        ++i;
                    }
                }
                return parameters;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public static final LocaleQualifier getLocale(@NotNull String parent) {
        FolderConfiguration config;
        if (StringsKt.indexOf$default((CharSequence)parent, (char)'-', (int)0, (boolean)false, (int)6, null) != -1 && (config = FolderConfiguration.getConfigForFolder((String)parent)) != null) {
            return config.getLocaleQualifier();
        }
        return null;
    }

    @Nullable
    public static final LocaleQualifier getLocale(@NotNull XmlContext context2) {
        CharSequence charSequence;
        String locale;
        Element root = context2.document.getDocumentElement();
        if (root != null && (locale = root.getAttributeNS("http://schemas.android.com/tools", "locale")) != null && !((charSequence = (CharSequence)locale).length() == 0)) {
            if (StringsKt.indexOf$default((CharSequence)locale, (char)'-', (int)0, (boolean)false, (int)6, null) == -1) {
                return LocaleQualifier.getQualifier((String)locale);
            }
            FolderConfiguration config = FolderConfiguration.getConfigForQualifierString((String)locale);
            if (config != null) {
                return config.getLocaleQualifier();
            }
        }
        return Lint.getLocale(context2.file.getParentFile().getName());
    }

    public static final boolean isEnglishResource(@NotNull XmlContext context2, boolean assumeForBase) {
        LocaleQualifier locale = Lint.getLocale(context2);
        return locale == null ? assumeForBase : Intrinsics.areEqual((Object)"en", (Object)locale.getLanguage());
    }

    @NotNull
    public static final Location guessGradleLocation(@NotNull Project project) {
        File dir = project.getDir();
        Location location = null;
        File topLevel = new File(dir, "build.gradle");
        location = topLevel.exists() ? Location.Companion.create(topLevel) : Location.Companion.create(dir);
        return location;
    }

    @NotNull
    public static final Location guessGradleLocation(@NotNull LintClient client, @NotNull File projectDir, @Nullable String string) {
        File gradle = new File(projectDir, "build.gradle");
        if (gradle.isFile()) {
            if (string == null) {
                return Location.Companion.create(gradle);
            }
            String contents = ((Object)client.readFile(gradle)).toString();
            int match = StringsKt.indexOf$default((CharSequence)contents, (String)string, (int)0, (boolean)false, (int)6, null);
            if (match != -1) {
                int length = string.length();
                if (StringsKt.indexOf$default((CharSequence)contents, (String)string, (int)(match + length), (boolean)false, (int)4, null) == -1) {
                    return Location.Companion.create(gradle, contents, match, match + length);
                }
                int end = contents.length();
                char first = string.charAt(0);
                int offset = 0;
                while (offset < end - 1) {
                    char c = contents.charAt(offset);
                    if (c == '/') {
                        char next = contents.charAt(offset + 1);
                        if (next == '/') {
                            if ((offset = StringsKt.indexOf$default((CharSequence)contents, (char)'\n', (int)offset, (boolean)false, (int)4, null)) == -1) break;
                            ++offset;
                            continue;
                        }
                        if (next == '*') {
                            if ((offset = StringsKt.indexOf$default((CharSequence)contents, (String)"*/", (int)offset, (boolean)false, (int)4, null)) != -1) continue;
                            break;
                        }
                    }
                    if (c == first && StringsKt.regionMatches$default((String)contents, (int)offset, (String)string, (int)0, (int)length, (boolean)false, (int)16, null)) {
                        return Location.Companion.create(gradle, contents, offset, offset + length);
                    }
                    ++offset;
                }
            }
            return Location.Companion.create(gradle);
        }
        return Location.Companion.create(projectDir);
    }

    public static final boolean isNullLiteral(@Nullable PsiElement element) {
        return element instanceof PsiLiteral && Intrinsics.areEqual((Object)"null", (Object)((PsiLiteral)element).getText());
    }

    public static final boolean isTrueLiteral(@Nullable PsiElement element) {
        return element instanceof PsiLiteral && Intrinsics.areEqual((Object)"true", (Object)((PsiLiteral)element).getText());
    }

    public static final boolean isFalseLiteral(@Nullable PsiElement element) {
        return element instanceof PsiLiteral && Intrinsics.areEqual((Object)"false", (Object)((PsiLiteral)element).getText());
    }

    @Nullable
    public static final PsiElement skipParentheses(@Nullable PsiElement element) {
        PsiElement current = element;
        while (current instanceof PsiParenthesizedExpression) {
            current = ((PsiParenthesizedExpression)current).getParent();
        }
        return current;
    }

    @Nullable
    public static final UElement skipParentheses(@Nullable UElement element) {
        UElement current = element;
        while (current instanceof UParenthesizedExpression) {
            current = current.getUastParent();
        }
        return current;
    }

    @Nullable
    public static final PsiElement nextNonWhitespace(@Nullable PsiElement element) {
        PsiElement current = element;
        if (current != null) {
            current = current.getNextSibling();
            while (current instanceof PsiWhiteSpace) {
                current = ((PsiWhiteSpace)current).getNextSibling();
            }
        }
        return current;
    }

    @Nullable
    public static final PsiElement prevNonWhitespace(@Nullable PsiElement element) {
        PsiElement current = element;
        if (current != null) {
            current = current.getPrevSibling();
            while (current instanceof PsiWhiteSpace) {
                current = ((PsiWhiteSpace)current).getPrevSibling();
            }
        }
        return current;
    }

    public static final boolean isString(@NotNull PsiType type) {
        String shortName;
        if (type instanceof PsiClassType && !Objects.equal((Object)(shortName = ((PsiClassType)type).getClassName()), (Object)"String")) {
            return false;
        }
        return Intrinsics.areEqual((Object)"java.lang.String", (Object)type.getCanonicalText());
    }

    @Nullable
    public static final String getAutoBoxedType(@NotNull String primitive) {
        return Intrinsics.areEqual((Object)"int", (Object)primitive) ? "java.lang.Integer" : (Intrinsics.areEqual((Object)"long", (Object)primitive) ? "java.lang.Long" : (Intrinsics.areEqual((Object)"char", (Object)primitive) ? "java.lang.Character" : (Intrinsics.areEqual((Object)"float", (Object)primitive) ? "java.lang.Float" : (Intrinsics.areEqual((Object)"double", (Object)primitive) ? "java.lang.Double" : (Intrinsics.areEqual((Object)"boolean", (Object)primitive) ? "java.lang.Boolean" : (Intrinsics.areEqual((Object)"short", (Object)primitive) ? "java.lang.Short" : (Intrinsics.areEqual((Object)"byte", (Object)primitive) ? "java.lang.Byte" : null)))))));
    }

    @Nullable
    public static final String getPrimitiveType(@NotNull String autoBoxedType) {
        return Intrinsics.areEqual((Object)"java.lang.Integer", (Object)autoBoxedType) ? "int" : (Intrinsics.areEqual((Object)"java.lang.Long", (Object)autoBoxedType) ? "long" : (Intrinsics.areEqual((Object)"java.lang.Character", (Object)autoBoxedType) ? "char" : (Intrinsics.areEqual((Object)"java.lang.Float", (Object)autoBoxedType) ? "float" : (Intrinsics.areEqual((Object)"java.lang.Double", (Object)autoBoxedType) ? "double" : (Intrinsics.areEqual((Object)"java.lang.Boolean", (Object)autoBoxedType) ? "boolean" : (Intrinsics.areEqual((Object)"java.lang.Short", (Object)autoBoxedType) ? "short" : (Intrinsics.areEqual((Object)"java.lang.Byte", (Object)autoBoxedType) ? "byte" : null)))))));
    }

    @NotNull
    public static final String resolveManifestName(@NotNull Element element) {
        String className = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (StringsKt.startsWith$default((String)(className = StringsKt.replace$default((String)className, (char)'$', (char)'.', (boolean)false, (int)4, null)), (String)".", (boolean)false, (int)2, null)) {
            String pkg = element.getOwnerDocument().getDocumentElement().getAttribute("package");
            return pkg + className;
        }
        if (StringsKt.indexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
            String pkg = element.getOwnerDocument().getDocumentElement().getAttribute("package");
            return pkg + "." + className;
        }
        return className;
    }

    @Nullable
    public static final String resolvePlaceHolders(@Nullable Project project, @NotNull String value, @Nullable Map<String, String> fallbacks) {
        String s = value;
        int start;
        while ((start = StringsKt.indexOf$default((CharSequence)s, (String)"${", (int)0, (boolean)false, (int)6, null)) != -1) {
            String string;
            String name;
            int end = StringsKt.indexOf$default((CharSequence)s, (String)"}", (int)(start + 1), (boolean)false, (int)4, null);
            if (end == -1) {
                return s;
            }
            String string2 = s;
            int n = start + "${".length();
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string4 = Lint.resolvePlaceHolder(project, name);
            if (string4 == null) {
                Map<String, String> map = fallbacks;
                string4 = string = map != null ? map.get(name) : null;
            }
            if (string4 == null) {
                string = "";
            }
            String replacement = string;
            String string5 = s;
            int n2 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            String string6 = string5;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n2, start);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string8 = string7;
            string5 = s;
            n2 = end + "${".length();
            stringBuilder = stringBuilder.append(string8).append(replacement);
            String string9 = string5;
            if (string9 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string10 = string9.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
            string8 = string10;
            s = stringBuilder.append(string8).toString();
        }
        return s;
    }

    @Nullable
    public static /* synthetic */ String resolvePlaceHolders$default(Project project, String string, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = null;
        }
        return Lint.resolvePlaceHolders(project, string, map);
    }

    @Nullable
    public static final String resolvePlaceHolder(@Nullable Project project, @NotNull String name) {
        Map<String, Object> placeHolders;
        Object newValue;
        Variant variant;
        Project project2 = project;
        Variant variant2 = variant = project2 != null ? project2.getCurrentVariant() : null;
        if (variant != null && (newValue = (placeHolders = variant.getMergedFlavor().getManifestPlaceholders()).get(name)) instanceof String) {
            return newValue.toString();
        }
        return null;
    }

    @NotNull
    public static final List<SourceProvider> getSourceProviders(@NotNull AndroidProject project, @NotNull Variant variant) {
        SourceProvider variantProvider;
        ArrayList<SourceProvider> providers = new ArrayList<SourceProvider>();
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        providers.add(project.getDefaultConfig().getSourceProvider());
        block0: for (String flavorName : variant.getProductFlavors()) {
            for (ProductFlavorContainer flavor : project.getProductFlavors()) {
                if (!Intrinsics.areEqual((Object)flavorName, (Object)flavor.getProductFlavor().getName())) continue;
                providers.add(flavor.getSourceProvider());
                continue block0;
            }
        }
        SourceProvider multiProvider = mainArtifact.getMultiFlavorSourceProvider();
        if (multiProvider != null) {
            providers.add(multiProvider);
        }
        String buildTypeName = variant.getBuildType();
        for (BuildTypeContainer buildType : project.getBuildTypes()) {
            if (!Intrinsics.areEqual((Object)buildTypeName, (Object)buildType.getBuildType().getName())) continue;
            providers.add(buildType.getSourceProvider());
            break;
        }
        if ((variantProvider = mainArtifact.getVariantSourceProvider()) != null) {
            providers.add(variantProvider);
        }
        return providers;
    }

    private static final boolean isTestArtifact(SourceProviderContainer extra) {
        String artifactName = extra.getArtifactName();
        return Intrinsics.areEqual((Object)"_android_test_", (Object)artifactName) || Intrinsics.areEqual((Object)"_unit_test_", (Object)artifactName);
    }

    @NotNull
    public static final List<SourceProvider> getTestSourceProviders(@NotNull AndroidProject project, @NotNull Variant variant) {
        ArrayList<SourceProvider> providers = new ArrayList<SourceProvider>();
        ProductFlavorContainer defaultConfig = project.getDefaultConfig();
        for (SourceProviderContainer extra : defaultConfig.getExtraSourceProviders()) {
            if (!Lint.isTestArtifact(extra)) continue;
            providers.add(extra.getSourceProvider());
        }
        for (String flavorName : variant.getProductFlavors()) {
            for (ProductFlavorContainer flavor : project.getProductFlavors()) {
                if (!Intrinsics.areEqual((Object)flavorName, (Object)flavor.getProductFlavor().getName())) continue;
                for (SourceProviderContainer extra : flavor.getExtraSourceProviders()) {
                    if (!Lint.isTestArtifact(extra)) continue;
                    providers.add(extra.getSourceProvider());
                }
            }
        }
        String buildTypeName = variant.getBuildType();
        for (BuildTypeContainer buildType : project.getBuildTypes()) {
            if (!Intrinsics.areEqual((Object)buildTypeName, (Object)buildType.getBuildType().getName())) continue;
            for (SourceProviderContainer extra : buildType.getExtraSourceProviders()) {
                if (!Lint.isTestArtifact(extra)) continue;
                providers.add(extra.getSourceProvider());
            }
        }
        return providers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isJavaKeyword(@NotNull String keyword) {
        String string = keyword;
        switch (string.hashCode()) {
            case -1466596076: {
                if (!string.equals("synchronized")) return false;
                return true;
            }
            case 3211: {
                if (!string.equals("do")) return false;
                return true;
            }
            case 97526364: {
                if (!string.equals("float")) return false;
                return true;
            }
            case 113101617: {
                if (!string.equals("while")) return false;
                return true;
            }
            case -608539730: {
                if (!string.equals("protected")) return false;
                return true;
            }
            case -567202649: {
                if (!string.equals("continue")) return false;
                return true;
            }
            case 3116345: {
                if (!string.equals("else")) return false;
                return true;
            }
            case 94432955: {
                if (!string.equals("catch")) return false;
                return true;
            }
            case 3357: {
                if (!string.equals("if")) return false;
                return true;
            }
            case 3046192: {
                if (!string.equals("case")) return false;
                return true;
            }
            case 108960: {
                if (!string.equals("new")) return false;
                return true;
            }
            case -807062458: {
                if (!string.equals("package")) return false;
                return true;
            }
            case -892481938: {
                if (!string.equals("static")) return false;
                return true;
            }
            case 3625364: {
                if (!string.equals("void")) return false;
                return true;
            }
            case 3039496: {
                if (!string.equals("byte")) return false;
                return true;
            }
            case -1325958191: {
                if (!string.equals("double")) return false;
                return true;
            }
            case -853259901: {
                if (!string.equals("finally")) return false;
                return true;
            }
            case 3559070: {
                if (!string.equals("this")) return false;
                return true;
            }
            case 1794694483: {
                if (!string.equals("strictfp")) return false;
                return true;
            }
            case -874432947: {
                if (!string.equals("throws")) return false;
                return true;
            }
            case 3118337: {
                if (!string.equals("enum")) return false;
                return true;
            }
            case -1305664359: {
                if (!string.equals("extends")) return false;
                return true;
            }
            case 3392903: {
                if (!string.equals("null")) return false;
                return true;
            }
            case 1052746378: {
                if (!string.equals("transient")) return false;
                return true;
            }
            case 97436022: {
                if (!string.equals("final")) return false;
                return true;
            }
            case 3569038: {
                if (!string.equals("true")) return false;
                return true;
            }
            case 115131: {
                if (!string.equals("try")) return false;
                return true;
            }
            case -915384400: {
                if (!string.equals("implements")) return false;
                return true;
            }
            case -314497661: {
                if (!string.equals("private")) return false;
                return true;
            }
            case 94844771: {
                if (!string.equals("const")) return false;
                return true;
            }
            case -1184795739: {
                if (!string.equals("import")) return false;
                return true;
            }
            case 101577: {
                if (!string.equals("for")) return false;
                return true;
            }
            case 502623545: {
                if (!string.equals("interface")) return false;
                return true;
            }
            case 3327612: {
                if (!string.equals("long")) return false;
                return true;
            }
            case -889473228: {
                if (!string.equals("switch")) return false;
                return true;
            }
            case 1544803905: {
                if (!string.equals("default")) return false;
                return true;
            }
            case 3178851: {
                if (!string.equals("goto")) return false;
                return true;
            }
            case -977423767: {
                if (!string.equals("public")) return false;
                return true;
            }
            case -1052618729: {
                if (!string.equals("native")) return false;
                return true;
            }
            case -1408208058: {
                if (!string.equals("assert")) return false;
                return true;
            }
            case 94742904: {
                if (!string.equals("class")) return false;
                return true;
            }
            case 94001407: {
                if (!string.equals("break")) return false;
                return true;
            }
            case 97196323: {
                if (!string.equals("false")) return false;
                return true;
            }
            case -1888027236: {
                if (!string.equals("volatile")) return false;
                return true;
            }
            case 1732898850: {
                if (!string.equals("abstract")) return false;
                return true;
            }
            case 104431: {
                if (!string.equals("int")) return false;
                return true;
            }
            case 902025516: {
                if (!string.equals("instanceof")) return false;
                return true;
            }
            case 109801339: {
                if (!string.equals("super")) return false;
                return true;
            }
            case 64711720: {
                if (!string.equals("boolean")) return false;
                return true;
            }
            case 110339814: {
                if (!string.equals("throw")) return false;
                return true;
            }
            case 3052374: {
                if (!string.equals("char")) return false;
                return true;
            }
            case 109413500: {
                if (!string.equals("short")) return false;
                return true;
            }
            case -934396624: {
                if (!string.equals("return")) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKotlinHardKeyword(@NotNull String keyword) {
        String string = keyword;
        switch (string.hashCode()) {
            case 101577: {
                if (!string.equals("for")) return false;
                return true;
            }
            case 3211: {
                if (!string.equals("do")) return false;
                return true;
            }
            case 502623545: {
                if (!string.equals("interface")) return false;
                return true;
            }
            case 113101617: {
                if (!string.equals("while")) return false;
                return true;
            }
            case 3648314: {
                if (!string.equals("when")) return false;
                return true;
            }
            case -567202649: {
                if (!string.equals("continue")) return false;
                return true;
            }
            case 3116345: {
                if (!string.equals("else")) return false;
                return true;
            }
            case 520977238: {
                if (!string.equals("typealias")) return false;
                return true;
            }
            case 94742904: {
                if (!string.equals("class")) return false;
                return true;
            }
            case 3357: {
                if (!string.equals("if")) return false;
                return true;
            }
            case -858802543: {
                if (!string.equals("typeof")) return false;
                return true;
            }
            case 116513: {
                if (!string.equals("val")) return false;
                return true;
            }
            case -807062458: {
                if (!string.equals("package")) return false;
                return true;
            }
            case 94001407: {
                if (!string.equals("break")) return false;
                return true;
            }
            case 3365: {
                if (!string.equals("in")) return false;
                return true;
            }
            case 116519: {
                if (!string.equals("var")) return false;
                return true;
            }
            case 97196323: {
                if (!string.equals("false")) return false;
                return true;
            }
            case 3559070: {
                if (!string.equals("this")) return false;
                return true;
            }
            case 3370: {
                if (!string.equals("is")) return false;
                return true;
            }
            case 109801339: {
                if (!string.equals("super")) return false;
                return true;
            }
            case 3122: {
                if (!string.equals("as")) return false;
                return true;
            }
            case 3392903: {
                if (!string.equals("null")) return false;
                return true;
            }
            case 110339814: {
                if (!string.equals("throw")) return false;
                return true;
            }
            case 3569038: {
                if (!string.equals("true")) return false;
                return true;
            }
            case 115131: {
                if (!string.equals("try")) return false;
                return true;
            }
            case 101759: {
                if (!string.equals("fun")) return false;
                return true;
            }
            case -934396624: {
                if (!string.equals("return")) return false;
                return true;
            }
            case -1023368385: {
                if (!string.equals("object")) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final byte[] readUrlData(@NotNull LintClient client, @NotNull String query, int timeout) {
        byte[] byArray;
        URL url = new URL(query);
        URLConnection uRLConnection = client.openConnection(url, timeout);
        if (uRLConnection == null) {
            return null;
        }
        URLConnection connection = uRLConnection;
        try {
            InputStream inputStream;
            if (connection.getInputStream() == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            InputStream is = inputStream;
            byArray = ByteStreams.toByteArray((InputStream)is);
        }
        finally {
            client.closeConnection(connection);
        }
        return byArray;
    }

    @Nullable
    public static final String readUrlDataAsString(@NotNull LintClient client, @NotNull String query, int timeout) {
        String string;
        byte[] bytes = Lint.readUrlData(client, query, timeout);
        if (bytes != null) {
            Charset charset = Charsets.UTF_8;
            string = new String(bytes, charset);
        } else {
            string = null;
        }
        return string;
    }

    @SafeVarargs
    @Nullable
    public static final <T> T coalesce(T ... ts) {
        for (T t : ts) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Nullable
    public static final String getMethodName(@NotNull UCallExpression call) {
        UIdentifier methodIdentifier = call.getMethodIdentifier();
        Object object = methodIdentifier;
        if (object == null || (object = object.getName()) == null) {
            object = call.getMethodName();
        }
        return object;
    }

    public static final boolean isKotlin(@Nullable PsiElement element) {
        return element != null && Lint.isKotlin(element.getLanguage());
    }

    public static final boolean isJava(@Nullable PsiElement element) {
        return element != null && Lint.isJava(element.getLanguage());
    }

    public static final boolean isKotlin(@Nullable Language language) {
        return Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE);
    }

    public static final boolean isJava(@Nullable Language language) {
        return Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE);
    }

    public static final boolean isNumberString(@Nullable String s) {
        CharSequence charSequence;
        if (s == null || (charSequence = (CharSequence)s).length() == 0) {
            return false;
        }
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static final Map<UExpression, PsiParameter> computeKotlinArgumentMapping(@NotNull UCallExpression call, @NotNull PsiMethod method) {
        Iterator iterator;
        Map map;
        Object object;
        Map parameter2;
        if (method.getParameterList().getParametersCount() <= 1) {
            return null;
        }
        PsiElement psiElement = call.getPsi();
        if (!(psiElement instanceof KtElement)) {
            psiElement = null;
        }
        KtElement ktElement = (KtElement)psiElement;
        if (ktElement == null) {
            return null;
        }
        KtElement receiver = ktElement;
        KotlinUastResolveProviderService kotlinUastResolveProviderService = (KotlinUastResolveProviderService)ServiceManager.getService((com.intellij.openapi.project.Project)receiver.getProject(), KotlinUastResolveProviderService.class);
        if (kotlinUastResolveProviderService == null) {
            return null;
        }
        KotlinUastResolveProviderService service = kotlinUastResolveProviderService;
        BindingContext bindingContext = service.getBindingContext(receiver);
        Object[] parameters = method.getParameterList().getParameters();
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)receiver, (BindingContext)bindingContext);
        if (resolvedCall == null) {
            return null;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        Map valueArguments = resolvedCall2.getValueArguments();
        Map elementMap = new LinkedHashMap();
        for (Map parameter2 : call.getValueArguments()) {
            object = elementMap;
            if (parameter2.getPsi() == null) {
                continue;
            }
            map = parameter2;
            object.put(iterator, map);
        }
        parameter2 = valueArguments;
        if (!parameter2.isEmpty()) {
            int firstParameterIndex = 0;
            Object object2 = (PsiParameter)ArraysKt.firstOrNull((Object[])parameters);
            if (object2 != null && (object2 = object2.getName()) != null) {
                if (StringsKt.startsWith$default((String)object2, (String)"$this", (boolean)false, (int)2, null)) {
                    ++firstParameterIndex;
                }
            }
            Map mapping = new LinkedHashMap();
            map = valueArguments;
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object3 = object = (Map.Entry)iterator.next();
                ValueParameterDescriptor parameterDescriptor = (ValueParameterDescriptor)object3.getKey();
                object3 = object;
                ResolvedValueArgument valueArgument = (ResolvedValueArgument)object3.getValue();
                for (ValueArgument argument : valueArgument.getArguments()) {
                    UExpression arg;
                    KtExpression expression;
                    if (argument.getArgumentExpression() == null) {
                        continue;
                    }
                    KtExpression ktExpression = expression;
                    if (ktExpression == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
                    }
                    if ((UExpression)elementMap.get((PsiElement)ktExpression) == null) {
                        continue;
                    }
                    int index = firstParameterIndex + parameterDescriptor.getIndex();
                    if (index >= parameters.length) continue;
                    Map map2 = mapping;
                    Object object4 = parameters[index];
                    map2.put(arg, object4);
                }
            }
            object = mapping;
            if (!object.isEmpty()) {
                return mapping;
            }
        }
        return null;
    }
}

