/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Project;
import com.google.common.annotations.Beta;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0012\b\u0087\u0001\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/detector/api/Scope;", "", "(Ljava/lang/String;I)V", "RESOURCE_FILE", "BINARY_RESOURCE_FILE", "RESOURCE_FOLDER", "ALL_RESOURCE_FILES", "JAVA_FILE", "ALL_JAVA_FILES", "CLASS_FILE", "ALL_CLASS_FILES", "MANIFEST", "PROGUARD_FILE", "JAVA_LIBRARIES", "GRADLE_FILE", "PROPERTY_FILE", "TEST_SOURCES", "OTHER", "Companion", "android.sdktools.lint-api"})
@Beta
public final class Scope
extends Enum<Scope> {
    public static final /* enum */ Scope RESOURCE_FILE;
    public static final /* enum */ Scope BINARY_RESOURCE_FILE;
    public static final /* enum */ Scope RESOURCE_FOLDER;
    public static final /* enum */ Scope ALL_RESOURCE_FILES;
    public static final /* enum */ Scope JAVA_FILE;
    public static final /* enum */ Scope ALL_JAVA_FILES;
    public static final /* enum */ Scope CLASS_FILE;
    public static final /* enum */ Scope ALL_CLASS_FILES;
    public static final /* enum */ Scope MANIFEST;
    public static final /* enum */ Scope PROGUARD_FILE;
    public static final /* enum */ Scope JAVA_LIBRARIES;
    public static final /* enum */ Scope GRADLE_FILE;
    public static final /* enum */ Scope PROPERTY_FILE;
    public static final /* enum */ Scope TEST_SOURCES;
    public static final /* enum */ Scope OTHER;
    private static final /* synthetic */ Scope[] $VALUES;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> ALL;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> RESOURCE_FILE_SCOPE;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> RESOURCE_FOLDER_SCOPE;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> ALL_RESOURCES_SCOPE;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> JAVA_FILE_SCOPE;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> CLASS_FILE_SCOPE;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> GRADLE_SCOPE;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> MANIFEST_SCOPE;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> OTHER_SCOPE;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> PROGUARD_SCOPE;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> PROPERTY_SCOPE;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> MANIFEST_AND_RESOURCE_SCOPE;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> JAVA_AND_RESOURCE_FILES;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> CLASS_AND_ALL_RESOURCE_FILES;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> ALL_CLASSES_AND_LIBRARIES;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> JAVA_LIBRARY_SCOPE;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> BINARY_RESOURCE_FILE_SCOPE;
    @JvmField
    @NotNull
    public static final EnumSet<Scope> EMPTY;
    public static final Companion Companion;

    static {
        Scope[] scopeArray = new Scope[15];
        Scope[] scopeArray2 = scopeArray;
        scopeArray[0] = RESOURCE_FILE = new Scope();
        scopeArray[1] = BINARY_RESOURCE_FILE = new Scope();
        scopeArray[2] = RESOURCE_FOLDER = new Scope();
        scopeArray[3] = ALL_RESOURCE_FILES = new Scope();
        scopeArray[4] = JAVA_FILE = new Scope();
        scopeArray[5] = ALL_JAVA_FILES = new Scope();
        scopeArray[6] = CLASS_FILE = new Scope();
        scopeArray[7] = ALL_CLASS_FILES = new Scope();
        scopeArray[8] = MANIFEST = new Scope();
        scopeArray[9] = PROGUARD_FILE = new Scope();
        scopeArray[10] = JAVA_LIBRARIES = new Scope();
        scopeArray[11] = GRADLE_FILE = new Scope();
        scopeArray[12] = PROPERTY_FILE = new Scope();
        scopeArray[13] = TEST_SOURCES = new Scope();
        scopeArray[14] = OTHER = new Scope();
        $VALUES = scopeArray;
        Companion = new Companion(null);
        ALL = EnumSet.allOf(Scope.class);
        RESOURCE_FILE_SCOPE = EnumSet.of((Enum)RESOURCE_FILE);
        RESOURCE_FOLDER_SCOPE = EnumSet.of((Enum)RESOURCE_FOLDER);
        ALL_RESOURCES_SCOPE = EnumSet.of((Enum)ALL_RESOURCE_FILES);
        JAVA_FILE_SCOPE = EnumSet.of((Enum)JAVA_FILE);
        CLASS_FILE_SCOPE = EnumSet.of((Enum)CLASS_FILE);
        GRADLE_SCOPE = EnumSet.of((Enum)GRADLE_FILE);
        MANIFEST_SCOPE = EnumSet.of((Enum)MANIFEST);
        OTHER_SCOPE = EnumSet.of((Enum)OTHER);
        PROGUARD_SCOPE = EnumSet.of((Enum)PROGUARD_FILE);
        PROPERTY_SCOPE = EnumSet.of((Enum)PROPERTY_FILE);
        MANIFEST_AND_RESOURCE_SCOPE = EnumSet.of((Enum)MANIFEST, (Enum)RESOURCE_FILE);
        JAVA_AND_RESOURCE_FILES = EnumSet.of((Enum)RESOURCE_FILE, (Enum)JAVA_FILE);
        CLASS_AND_ALL_RESOURCE_FILES = EnumSet.of((Enum)ALL_RESOURCE_FILES, (Enum)CLASS_FILE);
        ALL_CLASSES_AND_LIBRARIES = EnumSet.of((Enum)ALL_CLASS_FILES, (Enum)JAVA_LIBRARIES);
        JAVA_LIBRARY_SCOPE = EnumSet.of((Enum)JAVA_LIBRARIES);
        BINARY_RESOURCE_FILE_SCOPE = EnumSet.of((Enum)BINARY_RESOURCE_FILE);
        EMPTY = EnumSet.noneOf(Scope.class);
    }

    public static Scope[] values() {
        return (Scope[])$VALUES.clone();
    }

    public static Scope valueOf(String string) {
        return Enum.valueOf(Scope.class, string);
    }

    @JvmStatic
    public static final boolean checkSingleFile(@NotNull EnumSet<Scope> scopes) {
        return Companion.checkSingleFile(scopes);
    }

    @JvmStatic
    @NotNull
    public static final EnumSet<Scope> intersect(@NotNull EnumSet<Scope> scope1, @NotNull EnumSet<Scope> scope2) {
        return Companion.intersect(scope1, scope2);
    }

    @JvmStatic
    @NotNull
    public static final EnumSet<Scope> infer(@Nullable Collection<? extends Project> projects) {
        return Companion.infer(projects);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cH\u0007J*\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/lint/detector/api/Scope$Companion;", "", "()V", "ALL", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "ALL_CLASSES_AND_LIBRARIES", "ALL_RESOURCES_SCOPE", "BINARY_RESOURCE_FILE_SCOPE", "CLASS_AND_ALL_RESOURCE_FILES", "CLASS_FILE_SCOPE", "EMPTY", "GRADLE_SCOPE", "JAVA_AND_RESOURCE_FILES", "JAVA_FILE_SCOPE", "JAVA_LIBRARY_SCOPE", "MANIFEST_AND_RESOURCE_SCOPE", "MANIFEST_SCOPE", "OTHER_SCOPE", "PROGUARD_SCOPE", "PROPERTY_SCOPE", "RESOURCE_FILE_SCOPE", "RESOURCE_FOLDER_SCOPE", "checkSingleFile", "", "scopes", "infer", "projects", "", "Lcom/android/tools/lint/detector/api/Project;", "intersect", "scope1", "scope2", "android.sdktools.lint-api"})
    public static final class Companion {
        @JvmStatic
        public final boolean checkSingleFile(@NotNull EnumSet<Scope> scopes) {
            int size = scopes.size();
            if (size > 5) {
                return false;
            }
            int expected = 1;
            if (scopes.contains((Object)TEST_SOURCES)) {
                ++expected;
            }
            if (scopes.contains((Object)CLASS_FILE) && scopes.contains((Object)JAVA_FILE)) {
                ++expected;
            }
            return size == expected && (scopes.contains((Object)JAVA_FILE) || scopes.contains((Object)RESOURCE_FILE) || scopes.contains((Object)BINARY_RESOURCE_FILE) || scopes.contains((Object)GRADLE_FILE) || scopes.contains((Object)CLASS_FILE) || scopes.contains((Object)PROGUARD_FILE) || scopes.contains((Object)PROPERTY_FILE) || scopes.contains((Object)MANIFEST));
        }

        @JvmStatic
        @NotNull
        public final EnumSet<Scope> intersect(@NotNull EnumSet<Scope> scope1, @NotNull EnumSet<Scope> scope2) {
            EnumSet<Scope> scope = EnumSet.copyOf(scope1);
            scope.retainAll((Collection)scope2);
            return scope;
        }

        @JvmStatic
        @NotNull
        public final EnumSet<Scope> infer(@Nullable Collection<? extends Project> projects) {
            if (projects == null || projects.isEmpty()) {
                return ALL;
            }
            EnumSet<Scope> scope = EnumSet.noneOf(Scope.class);
            for (Project project : projects) {
                List<File> subset = project.getSubset();
                if (subset != null) {
                    for (File file : subset) {
                        String name = file.getName();
                        if (Intrinsics.areEqual((Object)name, (Object)"AndroidManifest.xml")) {
                            scope.add(MANIFEST);
                            continue;
                        }
                        if (StringsKt.endsWith$default((String)name, (String)".xml", (boolean)false, (int)2, null)) {
                            scope.add(RESOURCE_FILE);
                            continue;
                        }
                        if (StringsKt.endsWith$default((String)name, (String)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".kt", (boolean)false, (int)2, null)) {
                            scope.add(JAVA_FILE);
                            continue;
                        }
                        if (StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null)) {
                            scope.add(CLASS_FILE);
                            continue;
                        }
                        if (StringsKt.endsWith$default((String)name, (String)".gradle", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".kts", (boolean)false, (int)2, null)) {
                            scope.add(GRADLE_FILE);
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)name, (Object)"proguard.cfg") || Intrinsics.areEqual((Object)name, (Object)"proguard-project.txt")) {
                            scope.add(PROGUARD_FILE);
                            continue;
                        }
                        if (StringsKt.endsWith$default((String)name, (String)".properties", (boolean)false, (int)2, null)) {
                            scope.add(PROPERTY_FILE);
                            continue;
                        }
                        if (StringsKt.endsWith$default((String)name, (String)".png", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".webp", (boolean)false, (int)2, null)) {
                            scope.add(BINARY_RESOURCE_FILE);
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)name, (Object)"res") && !Intrinsics.areEqual((Object)file.getParent(), (Object)"res")) continue;
                        scope.add(ALL_RESOURCE_FILES);
                        scope.add(RESOURCE_FILE);
                        scope.add(BINARY_RESOURCE_FILE);
                        scope.add(RESOURCE_FOLDER);
                    }
                    continue;
                }
                scope = ALL;
                break;
            }
            return scope;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

