/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.memoryanalyzer;

import com.android.tools.perflib.analyzer.AnalysisResultEntry;
import com.android.tools.perflib.heap.memoryanalyzer.MemoryAnalyzerTask;
import com.android.tools.perflib.heap.memoryanalyzer.Printer;
import com.android.tools.perflib.heap.memoryanalyzer.Report;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;

public final class DefaultReport
implements Report {
    private final MemoryAnalyzerTask mTask;
    protected List<AnalysisResultEntry<?>> mResults;
    @VisibleForTesting
    protected static final String NO_ISSUES_FOUND_STRING = "No issues found.";

    public DefaultReport(MemoryAnalyzerTask task) {
        this.mTask = task;
    }

    @Override
    public void generate(List<AnalysisResultEntry<?>> data) {
        this.mResults = data;
    }

    @Override
    public void print(Printer printer) {
        printer.addHeading(2, this.mTask.getTaskName() + " Report");
        printer.addParagraph(this.mTask.getTaskDescription());
        if (this.mResults != null && this.mResults.isEmpty()) {
            printer.addParagraph(NO_ISSUES_FOUND_STRING);
            return;
        }
        printer.startTable(new String[0]);
        for (AnalysisResultEntry<?> result : this.mResults) {
            printer.addRow(result.getWarningMessage());
        }
        printer.endTable();
    }
}

