/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.android.CloudConfiguration;
import com.google.gct.testing.android.CloudConfigurationComboBox;
import com.google.gct.testing.android.CloudProjectSelector;
import com.google.gct.testing.android.CloudTestMatrixTargetProvider;
import com.google.gct.testing.launcher.CloudAuthenticator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import icons.GoogleCloudToolsIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudTestMatrixTargetConfigurable
implements DeployTargetConfigurable<CloudTestMatrixTargetProvider.State> {
    @Nullable
    private AndroidFacet myFacet;
    private final JPanel topPanel;
    private final JPanel connectToCloudPanel;
    private final JPanel cloudDeviceMatrixPanel;
    private final CloudConfigurationComboBox myCloudConfigurationComboBox;
    private final CloudProjectSelector myCloudProjectSelector;

    public CloudTestMatrixTargetConfigurable(@NotNull Project project, Disposable parentDisposable, final @NotNull DeployTargetConfigurableContext context) {
        this.myFacet = context.getModule() == null ? null : AndroidFacet.getInstance((Module)context.getModule());
        context.addModuleChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudTestMatrixTargetConfigurable.this.myFacet = context.getModule() == null ? null : AndroidFacet.getInstance((Module)context.getModule());
                if (CloudAuthenticator.isUserLoggedIn()) {
                    CloudTestMatrixTargetConfigurable.this.myCloudConfigurationComboBox.setFacet(CloudTestMatrixTargetConfigurable.this.myFacet);
                    CloudTestMatrixTargetConfigurable.this.myCloudProjectSelector.setFacet(CloudTestMatrixTargetConfigurable.this.myFacet);
                }
            }
        });
        this.topPanel = new JPanel(new FlowLayout(0));
        this.topPanel.setName("Cloud Testing");
        this.connectToCloudPanel = new JPanel();
        this.connectToCloudPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1));
        this.cloudDeviceMatrixPanel = new JPanel();
        this.cloudDeviceMatrixPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3));
        this.topPanel.add((Component)this.connectToCloudPanel, this.preparePanelGridConstraints(0));
        this.topPanel.add((Component)this.cloudDeviceMatrixPanel, this.preparePanelGridConstraints(1));
        this.connectToCloudPanel.add((Component)this.createRunTestsInCloudPane(this.topPanel.getBackground(), 6, 4), this.prepareEditorPaneGridConstraints(0));
        JButton connectToCloudButton = new JButton("Sign in with Google");
        connectToCloudButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudAuthenticator.authorize();
                CloudTestMatrixTargetConfigurable.this.updateVisibility();
            }
        });
        this.connectToCloudPanel.add((Component)connectToCloudButton, this.prepareElementGridConstraints(1, 0));
        this.connectToCloudPanel.add((Component)this.createSignupForCloudPane(this.topPanel.getBackground(), 6, 0), this.prepareEditorPaneGridConstraints(2));
        this.cloudDeviceMatrixPanel.add((Component)new JLabel("Matrix configuration:"), this.prepareElementGridConstraints(0, 0));
        this.myCloudConfigurationComboBox = new CloudConfigurationComboBox(CloudConfiguration.Kind.MATRIX);
        this.cloudDeviceMatrixPanel.add((Component)((Object)this.myCloudConfigurationComboBox), this.prepareElementGridConstraints(0, 1));
        this.cloudDeviceMatrixPanel.add((Component)new JPanel(), this.prepareHorizontalSpacerGridConstraints(0, 2));
        this.cloudDeviceMatrixPanel.add((Component)new JLabel("Cloud project:"), this.prepareElementGridConstraints(1, 0));
        JPanel cloudProjectPanel = new JPanel();
        cloudProjectPanel.setLayout(new FlowLayout(0, 0, 5));
        this.myCloudProjectSelector = new CloudProjectSelector(CloudConfiguration.Kind.MATRIX);
        cloudProjectPanel.add((Component)((Object)this.myCloudProjectSelector));
        JPanel gapPanel = new JPanel();
        gapPanel.setPreferredSize(new Dimension(5, 5));
        cloudProjectPanel.add(gapPanel);
        RefreshCloudProjectsAction cloudMatrixProjectAction = new RefreshCloudProjectsAction(this.myCloudProjectSelector);
        ActionButton cloudMatrixProjectActionButton = new ActionButton((AnAction)cloudMatrixProjectAction, new PresentationFactory().getPresentation((AnAction)cloudMatrixProjectAction), "MyPlace", (Dimension)JBUI.size((int)25, (int)25));
        cloudMatrixProjectActionButton.setFocusable(true);
        cloudProjectPanel.add((Component)cloudMatrixProjectActionButton);
        this.cloudDeviceMatrixPanel.add((Component)cloudProjectPanel, this.prepareElementGridConstraints(1, 1));
        this.cloudDeviceMatrixPanel.add((Component)this.createLinkPane(this.topPanel.getBackground(), CloudTestingUtils.prepareCreateFirebaseProjectAnchor("Create new Firebase project")), this.prepareElementGridConstraints(2, 0));
        this.cloudDeviceMatrixPanel.add((Component)this.createLinkPane(this.topPanel.getBackground(), CloudTestingUtils.preparePricingAnchor("Pricing information")), this.prepareElementGridConstraints(3, 0));
        this.topPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                CloudTestMatrixTargetConfigurable.this.myCloudProjectSelector.updateUI();
            }
        });
        this.updateVisibility();
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myCloudConfigurationComboBox);
    }

    @Nullable
    public JComponent createComponent() {
        return this.topPanel;
    }

    public void resetFrom(@NotNull CloudTestMatrixTargetProvider.State state, int configurationId) {
        this.myCloudConfigurationComboBox.setRunConfigurationId(configurationId);
        this.myCloudProjectSelector.setRunConfigurationId(configurationId);
        if (CloudAuthenticator.isUserLoggedIn()) {
            this.myCloudConfigurationComboBox.setFacet(this.myFacet);
            this.myCloudProjectSelector.setFacet(this.myFacet);
            this.myCloudConfigurationComboBox.selectCloudConfiguration(state.SELECTED_CLOUD_MATRIX_CONFIGURATION_ID);
            this.myCloudProjectSelector.updateCloudProjectId(state.SELECTED_CLOUD_MATRIX_PROJECT_ID);
        }
    }

    public void applyTo(@NotNull CloudTestMatrixTargetProvider.State state, int configurationId) {
        if (CloudAuthenticator.isUserLoggedIn() && this.myCloudConfigurationComboBox.getComboBox().getSelectedItem() instanceof CloudConfiguration) {
            CloudConfiguration selectedConfiguration = (CloudConfiguration)this.myCloudConfigurationComboBox.getComboBox().getSelectedItem();
            state.SELECTED_CLOUD_MATRIX_CONFIGURATION_ID = selectedConfiguration == null ? -1 : selectedConfiguration.getId();
            state.SELECTED_CLOUD_MATRIX_PROJECT_ID = this.myCloudProjectSelector.getProjectId();
        }
    }

    private void updateVisibility() {
        if (CloudAuthenticator.isUserLoggedIn()) {
            this.myCloudConfigurationComboBox.setFacet(this.myFacet);
            this.myCloudProjectSelector.setFacet(this.myFacet);
            this.cloudDeviceMatrixPanel.setVisible(true);
            this.connectToCloudPanel.setVisible(false);
            CloudTestMatrixTargetConfigurable.simulateChangeEvent(this.myCloudConfigurationComboBox);
        } else {
            this.cloudDeviceMatrixPanel.setVisible(false);
            this.connectToCloudPanel.setVisible(true);
        }
    }

    private GridConstraints preparePanelGridConstraints(int row) {
        return new GridConstraints(row, 0, 1, 1, 0, 3, 7, 7, new Dimension(-1, -1), new Dimension(-1, -1), new Dimension(-1, -1));
    }

    private GridConstraints prepareEditorPaneGridConstraints(int row) {
        return new GridConstraints(row, 0, 1, 1, 0, 3, 6, 6, new Dimension(-1, -1), new Dimension(490, 30), new Dimension(-1, -1));
    }

    private GridConstraints prepareElementGridConstraints(int row, int column) {
        return new GridConstraints(row, column, 1, 1, 8, 0, 0, 0, new Dimension(-1, -1), new Dimension(-1, -1), new Dimension(-1, -1));
    }

    private GridConstraints prepareHorizontalSpacerGridConstraints(int row, int column) {
        return new GridConstraints(row, column, 1, 1, 8, 1, 7, 7, new Dimension(-1, -1), new Dimension(-1, -1), new Dimension(-1, -1));
    }

    private JEditorPane createRunTestsInCloudPane(@NotNull Color backgroundColor, int topMargin, int bottomMargin) {
        JEditorPane runTestsInCloudPane = new JEditorPane("text/html", "<html><p style='margin-top: " + topMargin + "px; margin-bottom: " + bottomMargin + "px;'>Run tests against a wide variety of physical and virtual devices simultaneously in <a href='https://firebase.google.com/docs/test-lab'>Firebase Test Lab</a>.<br>" + CloudTestingUtils.preparePricingAnchor("Pricing information") + "</p></html>");
        CloudTestingUtils.linkifyEditorPane(runTestsInCloudPane, backgroundColor);
        return runTestsInCloudPane;
    }

    private JEditorPane createSignupForCloudPane(@NotNull Color backgroundColor, int topMargin, int bottomMargin) {
        JEditorPane signupForCloudPane = new JEditorPane("text/html", "<html><p style='margin-top: " + topMargin + "px; margin-bottom: " + bottomMargin + "px;'>Don&rsquo;t have a Firebase account? <a href='https://console.firebase.google.com'>Sign up</a> for one now.</p></html>");
        CloudTestingUtils.linkifyEditorPane(signupForCloudPane, backgroundColor);
        return signupForCloudPane;
    }

    private JEditorPane createLinkPane(@NotNull Color backgroundColor, String anchor) {
        JEditorPane linkPane = new JEditorPane("text/html", "<html>" + anchor + "</html>");
        linkPane.setMargin(new Insets(0, 1, 0, 0));
        CloudTestingUtils.linkifyEditorPane(linkPane, backgroundColor);
        return linkPane;
    }

    private static void simulateChangeEvent(CloudConfigurationComboBox comboBox) {
        for (ItemListener itemListener : comboBox.getComboBox().getItemListeners()) {
            itemListener.itemStateChanged(new ItemEvent(comboBox.getComboBox(), 701, comboBox.getComboBox(), 1));
        }
    }

    private static class RefreshCloudProjectsAction
    extends AnAction {
        private final CloudProjectSelector myCloudProjectSelector;

        public RefreshCloudProjectsAction(CloudProjectSelector cloudProjectSelector) {
            this.myCloudProjectSelector = cloudProjectSelector;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myCloudProjectSelector.refreshCloudProjects();
        }

        public void update(AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            presentation.setIcon(GoogleCloudToolsIcons.REFRESH);
            presentation.setText("Refresh cloud projects");
        }
    }
}

