/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.CloudMatrixExecutionCancellator;
import com.google.gct.testing.results.GoogleCloudTestEventsProcessor;
import com.google.gct.testing.results.GoogleCloudTestingConsoleView;
import com.google.gct.testing.results.GoogleCloudTestingResultsForm;
import com.google.gct.testing.results.GoogleCloudTestingToSMTRunnerEventsConvertor;
import com.google.gct.testing.results.GoogleCloudTestingUIActionsHandler;
import com.google.gct.testing.results.OutputToGoogleCloudTestEventsConverter;
import com.intellij.execution.Location;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.FileUrlProvider;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.ui.AttachToProcessListener;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestLocationProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestResultsConnectionUtil {
    private static final String TEST_RUNNER_DEBUG_MODE_PROPERTY = "idea.smrunner.debug";

    private GoogleCloudTestResultsConnectionUtil() {
    }

    public static BaseTestsOutputConsoleView createAndAttachConsole(@NotNull String testFrameworkName, @NotNull ProcessHandler processHandler, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        BaseTestsOutputConsoleView console = GoogleCloudTestResultsConnectionUtil.createConsole(testFrameworkName, consoleProperties, environment, matrixExecutionCancellator);
        console.attachToProcess(processHandler);
        return console;
    }

    public static BaseTestsOutputConsoleView createConsoleWithCustomLocator(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @Nullable TestLocationProvider locator, @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        return GoogleCloudTestResultsConnectionUtil.createConsoleWithCustomLocator(testFrameworkName, consoleProperties, environment, new CompositeTestLocationProvider(locator), false, null, matrixExecutionCancellator);
    }

    public static GoogleCloudTestingConsoleView createConsoleWithCustomLocator(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @Nullable SMTestLocator locator, boolean idBasedTreeConstruction, @Nullable TestProxyFilterProvider filterProvider, @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        String splitterPropertyName = GoogleCloudTestResultsConnectionUtil.getSplitterPropertyName(testFrameworkName);
        GoogleCloudTestingConsoleView consoleView = new GoogleCloudTestingConsoleView(consoleProperties, environment, splitterPropertyName);
        GoogleCloudTestResultsConnectionUtil.initConsoleView(consoleView, testFrameworkName, locator, idBasedTreeConstruction, filterProvider, matrixExecutionCancellator);
        return consoleView;
    }

    @NotNull
    public static String getSplitterPropertyName(@NotNull String testFrameworkName) {
        return testFrameworkName + ".Splitter.Proportion";
    }

    public static void initConsoleView(final @NotNull GoogleCloudTestingConsoleView consoleView, final @NotNull String testFrameworkName, final @Nullable SMTestLocator locator, final boolean idBasedTreeConstruction, final @Nullable TestProxyFilterProvider filterProvider, final @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        consoleView.addAttachToProcessListener(new AttachToProcessListener(){

            public void onAttachToProcess(@NotNull ProcessHandler processHandler) {
                TestProxyPrinterProvider printerProvider = null;
                if (filterProvider != null) {
                    printerProvider = new TestProxyPrinterProvider((BaseTestsOutputConsoleView)consoleView, filterProvider);
                }
                GoogleCloudTestingResultsForm resultsForm = consoleView.getResultsViewer();
                GoogleCloudTestResultsConnectionUtil.attachEventsProcessors(consoleView.getProperties(), resultsForm, processHandler, testFrameworkName, locator, idBasedTreeConstruction, printerProvider, matrixExecutionCancellator);
            }
        });
        consoleView.setHelpId("reference.runToolWindow.testResultsTab");
        consoleView.initUI();
    }

    public static BaseTestsOutputConsoleView createConsole(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        return GoogleCloudTestResultsConnectionUtil.createConsoleWithCustomLocator(testFrameworkName, consoleProperties, environment, null, matrixExecutionCancellator);
    }

    public static boolean isInDebugMode() {
        return Boolean.valueOf(System.getProperty(TEST_RUNNER_DEBUG_MODE_PROPERTY));
    }

    private static void attachEventsProcessors(@NotNull TestConsoleProperties consoleProperties, GoogleCloudTestingResultsForm resultsViewer, ProcessHandler processHandler, @NotNull String testFrameworkName, @Nullable SMTestLocator locator, boolean idBasedTreeConstruction, @Nullable TestProxyPrinterProvider printerProvider, final @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        final OutputToGoogleCloudTestEventsConverter outputConsumer = new OutputToGoogleCloudTestEventsConverter(testFrameworkName, consoleProperties);
        if (idBasedTreeConstruction) {
            throw new RuntimeException("ID-based converter is not supported!");
        }
        final GoogleCloudTestingToSMTRunnerEventsConvertor eventsProcessor = new GoogleCloudTestingToSMTRunnerEventsConvertor(resultsViewer.getTestsRootNode(), testFrameworkName);
        if (locator != null) {
            ((GoogleCloudTestEventsProcessor)eventsProcessor).setLocator(locator);
        }
        if (printerProvider != null) {
            ((GoogleCloudTestEventsProcessor)eventsProcessor).setPrinterProvider(printerProvider);
        }
        GoogleCloudTestingUIActionsHandler uiActionsHandler = new GoogleCloudTestingUIActionsHandler(consoleProperties);
        outputConsumer.setProcessor(eventsProcessor);
        ((GoogleCloudTestEventsProcessor)eventsProcessor).addEventsListener(resultsViewer);
        resultsViewer.addEventsListener(uiActionsHandler);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                matrixExecutionCancellator.cancel();
                outputConsumer.flushBufferBeforeTerminating();
                eventsProcessor.onFinishTesting();
                Disposer.dispose((Disposable)eventsProcessor);
                Disposer.dispose((Disposable)outputConsumer);
            }

            public void startNotified(ProcessEvent event) {
                eventsProcessor.onStartTesting();
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                outputConsumer.process(event.getText(), outputType);
            }
        });
    }

    public static class CompositeTestLocationProvider
    implements SMTestLocator {
        private final TestLocationProvider myPrimaryLocator;
        private final TestLocationProvider[] myLocators;

        public CompositeTestLocationProvider(@Nullable TestLocationProvider primaryLocator) {
            this.myPrimaryLocator = primaryLocator;
            this.myLocators = (TestLocationProvider[])Extensions.getExtensions((ExtensionPointName)TestLocationProvider.EP_NAME);
        }

        @NotNull
        public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
            List locations;
            boolean isDumbMode = DumbService.isDumb((Project)project);
            if (!(this.myPrimaryLocator == null || isDumbMode && !(this.myPrimaryLocator instanceof DumbAware) || (locations = this.myPrimaryLocator.getLocation(protocol, path, project)).isEmpty())) {
                return locations;
            }
            if ("file".equals(protocol) && !(locations = FileUrlProvider.INSTANCE.getLocation(protocol, path, project, scope)).isEmpty()) {
                return locations;
            }
            for (TestLocationProvider provider : this.myLocators) {
                List locations2;
                if (isDumbMode && !(provider instanceof DumbAware) || (locations2 = provider.getLocation(protocol, path, project)).isEmpty()) continue;
                return locations2;
            }
            return Collections.emptyList();
        }
    }
}

