/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestNodeDescriptor;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestingRootTestProxyFormatter;
import com.google.gct.testing.results.GoogleCloudTestsPresentationUtil;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GoogleCloudTestTreeRenderer
extends ColoredTreeCellRenderer {
    @NonNls
    private static final String SPACE_STRING = " ";
    private final TestConsoleProperties myConsoleProperties;
    private GoogleCloudTestingRootTestProxyFormatter myAdditionalRootFormatter;
    private int myDurationWidth = -1;
    private int myRow;

    public GoogleCloudTestTreeRenderer(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.myRow = row;
        this.myDurationWidth = -1;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObj = node.getUserObject();
        if (userObj instanceof GoogleCloudTestNodeDescriptor) {
            String durationString;
            GoogleCloudTestNodeDescriptor desc = (GoogleCloudTestNodeDescriptor)((Object)userObj);
            GoogleCloudTestProxy testProxy = (GoogleCloudTestProxy)desc.getElement();
            if (testProxy instanceof GoogleCloudTestProxy.GoogleCloudRootTestProxy) {
                GoogleCloudTestProxy.GoogleCloudRootTestProxy rootTestProxy = (GoogleCloudTestProxy.GoogleCloudRootTestProxy)testProxy;
                if (rootTestProxy.isLeaf()) {
                    GoogleCloudTestsPresentationUtil.formatRootNodeWithoutChildren(rootTestProxy, this);
                } else {
                    GoogleCloudTestsPresentationUtil.formatRootNodeWithChildren(rootTestProxy, this);
                }
                if (this.myAdditionalRootFormatter != null) {
                    this.myAdditionalRootFormatter.format(rootTestProxy, this);
                }
            } else {
                GoogleCloudTestsPresentationUtil.formatTestProxy(testProxy, this);
            }
            if (TestConsoleProperties.SHOW_INLINE_STATISTICS.value((AbstractProperty.AbstractPropertyContainer)this.myConsoleProperties) && (durationString = testProxy.getDurationString(this.myConsoleProperties)) != null) {
                durationString = "  " + durationString;
                this.myDurationWidth = this.getFontMetrics(this.getFont()).stringWidth(durationString);
                if (((TestTreeView)this.myTree).isExpandableHandlerVisibleForCurrentRow(this.myRow)) {
                    this.append(durationString);
                }
            }
            return;
        }
        String text = node.toString();
        this.append(text != null ? text : SPACE_STRING, SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        return this.myDurationWidth < 0 || ((TestTreeView)this.myTree).isExpandableHandlerVisibleForCurrentRow(this.myRow) ? preferredSize : JBUI.size((int)(preferredSize.width + this.myDurationWidth), (int)preferredSize.height);
    }

    public TestConsoleProperties getConsoleProperties() {
        return this.myConsoleProperties;
    }

    public void setAdditionalRootFormatter(@NotNull GoogleCloudTestingRootTestProxyFormatter formatter) {
        this.myAdditionalRootFormatter = formatter;
    }

    public void removeAdditionalRootFormatter() {
        this.myAdditionalRootFormatter = null;
    }
}

