/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.results.GoogleCloudTestEventsListener;
import com.google.gct.testing.results.GoogleCloudTestEventsProcessor;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestResultsConnectionUtil;
import com.google.gct.testing.results.events.GoogleCloudTestFailedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestFinishedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestIgnoredEvent;
import com.google.gct.testing.results.events.GoogleCloudTestOutputEvent;
import com.google.gct.testing.results.events.GoogleCloudTestStartedEvent;
import com.google.gct.testing.results.events.SetActiveCloudMatrixEvent;
import com.google.gct.testing.results.events.SetTestRunIdEvent;
import com.google.gct.testing.results.events.TestConfigurationFinishedEvent;
import com.google.gct.testing.results.events.TestConfigurationProgressEvent;
import com.google.gct.testing.results.events.TestConfigurationScheduledEvent;
import com.google.gct.testing.results.events.TestConfigurationStartedEvent;
import com.google.gct.testing.results.events.TestConfigurationStoppedEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestingToSMTRunnerEventsConvertor
extends GoogleCloudTestEventsProcessor {
    private static final Logger LOG = Logger.getInstance((String)GoogleCloudTestingToSMTRunnerEventsConvertor.class.getName());
    private final Map<String, GoogleCloudTestProxy> myRunningTestsFullNameToProxy = new HashMap<String, GoogleCloudTestProxy>();
    private final Set<AbstractTestProxy> myFailedTestsSet = new HashSet<AbstractTestProxy>();
    private final List<GoogleCloudTestEventsListener> myEventsListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final GoogleCloudTestProxy.GoogleCloudRootTestProxy myTestsRootNode;
    private final String myTestFrameworkName;
    private boolean myIsTestingFinished;
    private SMTestLocator myLocator = null;
    private GoogleCloudTestProxy lastUpdatedTest = null;

    public GoogleCloudTestingToSMTRunnerEventsConvertor(@NotNull GoogleCloudTestProxy.GoogleCloudRootTestProxy testsRootNode, @NotNull String testFrameworkName) {
        this.myTestsRootNode = testsRootNode;
        this.myTestFrameworkName = testFrameworkName;
    }

    @Override
    public void setLocator(@NotNull SMTestLocator customLocator) {
        this.myLocator = customLocator;
    }

    @Override
    public void addEventsListener(@NotNull GoogleCloudTestEventsListener listener) {
        this.myEventsListeners.add(listener);
    }

    @Override
    public void onStartTesting() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.setScheduled();
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.lastUpdatedTest = null;
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestingStarted(true);
            }
        });
    }

    @Override
    public void onTestsReporterAttached() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.setTestsReporterAttached();
            }
        });
    }

    @Override
    public void onFinishTesting() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                if (GoogleCloudTestingToSMTRunnerEventsConvertor.this.myIsTestingFinished) {
                    return;
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myIsTestingFinished = true;
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.clear();
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.lastUpdatedTest = null;
                if (GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.hasScheduledOrPendingConfigurations()) {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.setTerminated();
                } else {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.setFinished();
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.onUncapturedOutput(this.prepareFinishString(), ProcessOutputTypes.STDOUT);
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.onUncapturedOutput("\nPricing information: https://firebase.google.com/pricing \n", ProcessOutputTypes.STDOUT);
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestingFinished();
            }

            private String prepareFinishString() {
                return CloudTestingUtils.shouldShowProgressTimestamps() ? "Finish\t" + System.currentTimeMillis() + "\n" : "Finish\n";
            }
        });
    }

    @Override
    public void setPrinterProvider(@NotNull TestProxyPrinterProvider printerProvider) {
    }

    @Override
    public void onTestStarted(final @NotNull GoogleCloudTestStartedEvent testStartedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configuration = testStartedEvent.getConfiguration();
                String className = testStartedEvent.getClassName();
                String testName = testStartedEvent.getName();
                String locationUrl = testStartedEvent.getLocationUrl();
                String fullName = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getFullTestName(configuration, className, testName);
                if (GoogleCloudTestingToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.containsKey(fullName)) {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.logProblem("Test [" + fullName + "] has been already started");
                    if (GoogleCloudTestResultsConnectionUtil.isInDebugMode()) {
                        return;
                    }
                }
                GoogleCloudTestProxy parentSuite = GoogleCloudTestingToSMTRunnerEventsConvertor.this.findOrCreateChildNode(GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode, configuration, true);
                parentSuite = GoogleCloudTestingToSMTRunnerEventsConvertor.this.findOrCreateChildNode(parentSuite, className, true);
                GoogleCloudTestProxy testProxy = new GoogleCloudTestProxy(testName, false, locationUrl);
                if (GoogleCloudTestingToSMTRunnerEventsConvertor.this.myLocator != null) {
                    testProxy.setLocator(GoogleCloudTestingToSMTRunnerEventsConvertor.this.myLocator);
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.lastUpdatedTest = testProxy;
                parentSuite.addChild(testProxy);
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.put(fullName, testProxy);
                testProxy.setStarted();
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestStarted(testProxy);
            }
        });
    }

    private String getFullTestName(String configuration, String className, String testName) {
        return configuration + ":" + className + ":" + testName;
    }

    private GoogleCloudTestProxy findOrCreateChildNode(GoogleCloudTestProxy parent, String nodeName, boolean shouldStartIfNotFound) {
        GoogleCloudTestProxy testProxy = (GoogleCloudTestProxy)((Object)Iterables.find(parent.getChildren(), this.getNodeNamed(nodeName), null));
        if (testProxy == null) {
            testProxy = new GoogleCloudTestProxy(nodeName, true, null);
            parent.addChild(testProxy);
            if (shouldStartIfNotFound) {
                testProxy.setStarted();
                this.fireOnTestStarted(testProxy);
            }
        }
        return testProxy;
    }

    private Predicate<GoogleCloudTestProxy> getNodeNamed(final String nodeName) {
        return new Predicate<GoogleCloudTestProxy>(){

            public boolean apply(GoogleCloudTestProxy testProxy) {
                return testProxy.getName().equals(nodeName);
            }
        };
    }

    @Override
    public void onSuiteStarted(@NotNull TestSuiteStartedEvent suiteStartedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                throw new RuntimeException("Unsupported event 'onSuiteStarted'");
            }
        });
    }

    @Override
    public void onSetTestRunId(@NotNull SetTestRunIdEvent setTestRunIdEvent) {
        this.myTestsRootNode.setTestRunId(setTestRunIdEvent.getTestRunId());
    }

    @Override
    public void onSetActiveCloudMatrix(@NotNull SetActiveCloudMatrixEvent setActiveCloudMatrixEvent) {
        this.myTestsRootNode.setScheduledActive();
        for (GoogleCloudTestProxy googleCloudTestProxy : this.myTestsRootNode.getChildren()) {
            googleCloudTestProxy.setScheduledActive();
        }
    }

    @Override
    public void onConfigurationStopped(final @NotNull TestConfigurationStoppedEvent configurationStoppedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configurationName = configurationStoppedEvent.getName();
                for (GoogleCloudTestProxy googleCloudTestProxy : GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.getChildren()) {
                    if (!googleCloudTestProxy.getName().equals(configurationName)) continue;
                    List<GoogleCloudTestProxy> suiteTests = googleCloudTestProxy.getAllTests();
                    suiteTests.remove((Object)googleCloudTestProxy);
                    for (GoogleCloudTestProxy suiteTest : suiteTests) {
                        GoogleCloudTestingToSMTRunnerEventsConvertor.this.stopTest(suiteTest, configurationStoppedEvent.getStopReason());
                    }
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.stopTest(googleCloudTestProxy, configurationStoppedEvent.getStopReason());
                    googleCloudTestProxy.setDuration(configurationStoppedEvent.getTestDuration());
                    return;
                }
                throw new IllegalStateException("Could not find configuration: " + configurationName);
            }
        });
    }

    @Override
    public void onConfigurationStarted(final @NotNull TestConfigurationStartedEvent configurationStartedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configurationName = configurationStartedEvent.getName();
                GoogleCloudTestProxy newConfiguration = GoogleCloudTestingToSMTRunnerEventsConvertor.this.findOrCreateChildNode(GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode, configurationName, false);
                if (GoogleCloudTestingToSMTRunnerEventsConvertor.this.myLocator != null) {
                    newConfiguration.setLocator(GoogleCloudTestingToSMTRunnerEventsConvertor.this.myLocator);
                }
                newConfiguration.setStarted();
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnSuiteStarted(newConfiguration);
                if (!GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.isInProgress()) {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.setStarted();
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestingStarted(false);
                }
            }
        });
    }

    @Override
    public void onConfigurationProgress(final @NotNull TestConfigurationProgressEvent configurationProgressEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configurationName = configurationProgressEvent.getName();
                String progressText = configurationProgressEvent.getText();
                GoogleCloudTestProxy configurationProxy = (GoogleCloudTestProxy)((Object)Iterables.find(GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.getChildren(), (Predicate)GoogleCloudTestingToSMTRunnerEventsConvertor.this.getNodeNamed(configurationName), null));
                if (configurationProxy == null) {
                    throw new IllegalStateException("Could not report progress for non-existing configuration: " + configurationName);
                }
                configurationProxy.addStdOutput(progressText, ProcessOutputTypes.STDOUT, true);
            }
        });
    }

    @Override
    public void onConfigurationScheduled(final @NotNull TestConfigurationScheduledEvent configurationScheduledEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configurationName = configurationScheduledEvent.getName();
                String locationUrl = configurationScheduledEvent.getLocationUrl();
                GoogleCloudTestProxy newConfiguration = new GoogleCloudTestProxy(configurationName, true, locationUrl);
                if (GoogleCloudTestingToSMTRunnerEventsConvertor.this.myLocator != null) {
                    newConfiguration.setLocator(GoogleCloudTestingToSMTRunnerEventsConvertor.this.myLocator);
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.addChild(newConfiguration);
                newConfiguration.setScheduled();
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnSuiteStarted(newConfiguration);
            }
        });
    }

    private void stopTest(GoogleCloudTestProxy test, CloudTestingUtils.ConfigurationStopReason stopReason) {
        switch (stopReason) {
            case FINISHED: {
                test.setFinished();
                break;
            }
            case INFRASTRUCTURE_FAILURE: {
                test.setInfrastructureFailed();
                break;
            }
            case TRIGGERING_ERROR: {
                test.setTriggeringError();
                break;
            }
            case TIMED_OUT: {
                test.setTimeout();
            }
        }
        this.fireOnTestFinished(test);
    }

    @Override
    public void onTestFinished(final @NotNull GoogleCloudTestFinishedEvent testFinishedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configuration = testFinishedEvent.getConfiguration();
                String className = testFinishedEvent.getClassName();
                String testName = testFinishedEvent.getName();
                long duration = testFinishedEvent.getDuration() == null ? -1L : testFinishedEvent.getDuration();
                String fullTestName = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getFullTestName(configuration, className, testName);
                GoogleCloudTestProxy testProxy = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                if (testProxy == null) {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! TestFinished event: name = {" + testName + "}. " + GoogleCloudTestingToSMTRunnerEventsConvertor.this.cannotFindFullTestNameMsg(fullTestName));
                    return;
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.lastUpdatedTest = testProxy;
                testProxy.setDuration(duration);
                testProxy.setFinished();
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.remove(fullTestName);
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestFinished(testProxy);
            }
        });
    }

    @Override
    public void onSuiteFinished(@NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                throw new RuntimeException("Unsupported event 'onSuiteFinished'");
            }
        });
    }

    @Override
    public void onConfigurationFinished(@NotNull TestConfigurationFinishedEvent configurationFinishedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                throw new RuntimeException("Unsupported event 'onConfigurationFinished'");
            }
        });
    }

    @Override
    public void onUncapturedOutput(final @NotNull String text, final Key outputType) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestProxy currentProxy = GoogleCloudTestingToSMTRunnerEventsConvertor.this.findCurrentTestOrSuite();
                if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                    currentProxy.addStdErr(text, true);
                } else if (ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
                    currentProxy.addSystemOutput(text);
                } else {
                    currentProxy.addStdOutput(text, outputType, true);
                }
            }
        });
    }

    @Override
    public void onError(final @NotNull String localizedMessage, final @Nullable String stackTrace, final boolean isCritical) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestProxy currentProxy = GoogleCloudTestingToSMTRunnerEventsConvertor.this.findCurrentTestOrSuite();
                currentProxy.addError(localizedMessage, stackTrace, isCritical);
            }
        });
    }

    @Override
    public void onCustomProgressTestsCategory(final @Nullable String categoryName, final int testCount) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestsCategory(categoryName, testCount);
            }
        });
    }

    @Override
    public void onCustomProgressTestStarted() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestStarted();
            }
        });
    }

    @Override
    public void onCustomProgressTestFailed() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestFailed();
            }
        });
    }

    @Override
    public void onTestFailure(final @NotNull GoogleCloudTestFailedEvent testFailedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configuration = testFailedEvent.getConfiguration();
                String className = testFailedEvent.getClassName();
                String testName = (String)ObjectUtils.assertNotNull((Object)testFailedEvent.getName());
                String localizedMessage = testFailedEvent.getLocalizedFailureMessage();
                String stackTrace = testFailedEvent.getStacktrace();
                boolean isTestError = testFailedEvent.isTestError();
                String comparisionFailureActualText = testFailedEvent.getComparisonFailureActualText();
                String comparisionFailureExpectedText = testFailedEvent.getComparisonFailureExpectedText();
                boolean inDebugMode = GoogleCloudTestResultsConnectionUtil.isInDebugMode();
                String fullTestName = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getFullTestName(configuration, className, testName);
                GoogleCloudTestProxy testProxy = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                if (testProxy == null) {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! TestFailure event: name = {" + testName + "}, message = {" + localizedMessage + "}, stackTrace = {" + stackTrace + "}. " + GoogleCloudTestingToSMTRunnerEventsConvertor.this.cannotFindFullTestNameMsg(fullTestName));
                    if (inDebugMode) {
                        return;
                    }
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.onTestStarted(new GoogleCloudTestStartedEvent(testName, null, configuration, className));
                    testProxy = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                }
                if (testProxy == null) {
                    return;
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.lastUpdatedTest = testProxy;
                if (comparisionFailureActualText != null && comparisionFailureExpectedText != null) {
                    if (GoogleCloudTestingToSMTRunnerEventsConvertor.this.myFailedTestsSet.contains((Object)testProxy)) {
                        GoogleCloudTestingToSMTRunnerEventsConvertor.this.logProblem("Duplicate failure for test [" + fullTestName + "]: msg = " + localizedMessage + ", stacktrace = " + stackTrace);
                        if (inDebugMode) {
                            return;
                        }
                    }
                    testProxy.setTestComparisonFailed(localizedMessage, stackTrace, comparisionFailureActualText, comparisionFailureExpectedText);
                } else if (comparisionFailureActualText == null && comparisionFailureExpectedText == null) {
                    testProxy.setTestFailed(localizedMessage, stackTrace, isTestError);
                } else {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.logProblem("Comparison failure actual and expected texts should be both null or not null.\nExpected:\n" + comparisionFailureExpectedText + "\nActual:\n" + comparisionFailureActualText);
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myFailedTestsSet.add(testProxy);
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestFailed(testProxy);
            }
        });
    }

    @Override
    public void onTestIgnored(final @NotNull GoogleCloudTestIgnoredEvent testIgnoredEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configuration = testIgnoredEvent.getConfiguration();
                String className = testIgnoredEvent.getClassName();
                String testName = (String)ObjectUtils.assertNotNull((Object)testIgnoredEvent.getName());
                String ignoreComment = testIgnoredEvent.getIgnoreComment();
                if (StringUtil.isEmpty((String)ignoreComment)) {
                    ignoreComment = SMTestsRunnerBundle.message((String)"sm.test.runner.states.test.is.ignored", (Object[])new Object[0]);
                }
                String stackTrace = testIgnoredEvent.getStacktrace();
                String fullTestName = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getFullTestName(configuration, className, testName);
                GoogleCloudTestProxy testProxy = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                if (testProxy == null) {
                    boolean debugMode = GoogleCloudTestResultsConnectionUtil.isInDebugMode();
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! TestIgnored event: name = {" + testName + "}, message = {" + ignoreComment + "}. " + GoogleCloudTestingToSMTRunnerEventsConvertor.this.cannotFindFullTestNameMsg(fullTestName));
                    if (debugMode) {
                        return;
                    }
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.onTestStarted(new GoogleCloudTestStartedEvent(testName, null, configuration, className));
                    testProxy = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                }
                if (testProxy == null) {
                    return;
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.lastUpdatedTest = testProxy;
                testProxy.setTestIgnored(ignoreComment, stackTrace);
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestIgnored(testProxy);
            }
        });
    }

    @Override
    public void onTestOutput(final @NotNull GoogleCloudTestOutputEvent testOutputEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configuration = testOutputEvent.getConfiguration();
                String className = testOutputEvent.getClassName();
                String testName = testOutputEvent.getName();
                String text = testOutputEvent.getText();
                boolean stdOut = testOutputEvent.getOutputType() == ProcessOutputTypes.STDOUT;
                String fullTestName = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getFullTestName(configuration, className, testName);
                GoogleCloudTestProxy testProxy = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                if (testProxy == null) {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! TestOutput event: name = {" + testName + "}, isStdOut = " + stdOut + ", text = {" + text + "}. " + GoogleCloudTestingToSMTRunnerEventsConvertor.this.cannotFindFullTestNameMsg(fullTestName));
                    return;
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.lastUpdatedTest = testProxy;
                if (stdOut) {
                    testProxy.addStdOutput(text, ProcessOutputTypes.STDOUT, true);
                } else {
                    testProxy.addStdErr(text, true);
                }
            }
        });
    }

    @Override
    public void onTestsCountInSuite(final int count) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestsCountInSuite(count);
            }
        });
    }

    protected int getRunningTestsQuantity() {
        return this.myRunningTestsFullNameToProxy.size();
    }

    protected Set<AbstractTestProxy> getFailedTestsSet() {
        return Collections.unmodifiableSet(this.myFailedTestsSet);
    }

    @Nullable
    protected GoogleCloudTestProxy getProxyByFullTestName(String fullTestName) {
        return this.myRunningTestsFullNameToProxy.get(fullTestName);
    }

    private String cannotFindFullTestNameMsg(String fullTestName) {
        return "Cant find running test for [" + fullTestName + "]. Current running tests: {" + this.dumpRunningTestsNames() + "}";
    }

    private StringBuilder dumpRunningTestsNames() {
        Set<String> names = this.myRunningTestsFullNameToProxy.keySet();
        StringBuilder namesDump = new StringBuilder();
        for (String name : names) {
            namesDump.append('[').append(name).append(']').append(',');
        }
        return namesDump;
    }

    private void fireOnTestingStarted(boolean printTestingStartedTime) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestingStarted(this.myTestsRootNode, printTestingStartedTime);
        }
    }

    private void fireOnTestingFinished() {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestingFinished(this.myTestsRootNode);
        }
    }

    private void fireOnTestsCountInSuite(int count) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestsCountInSuite(count);
        }
    }

    private void fireOnTestStarted(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestStarted(test);
        }
    }

    private void fireOnTestFinished(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestFinished(test);
        }
    }

    private void fireOnTestFailed(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestFailed(test);
        }
    }

    private void fireOnTestIgnored(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestIgnored(test);
        }
    }

    private void fireOnSuiteStarted(GoogleCloudTestProxy suite) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onSuiteStarted(suite);
        }
    }

    private void fireOnSuiteFinished(GoogleCloudTestProxy suite) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onSuiteFinished(suite);
        }
    }

    private void fireOnCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestsCategory(categoryName, testCount);
        }
    }

    private void fireOnCustomProgressTestStarted() {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestStarted();
        }
    }

    private void fireOnCustomProgressTestFailed() {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestFailed();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Application application;
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myEventsListeners.clear();
                if (!(GoogleCloudTestingToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.isEmpty() || (application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.logProblem("Not all events were processed! " + GoogleCloudTestingToSMTRunnerEventsConvertor.this.dumpRunningTestsNames());
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.clear();
            }
        });
    }

    private GoogleCloudTestProxy findCurrentTestOrSuite() {
        if (this.lastUpdatedTest != null) {
            return this.lastUpdatedTest;
        }
        return this.myTestsRootNode;
    }

    public static String getTFrameworkPrefix(String testFrameworkName) {
        return "[" + testFrameworkName + "]: ";
    }

    private void logProblem(String msg) {
        GoogleCloudTestingToSMTRunnerEventsConvertor.logProblem(LOG, msg, this.myTestFrameworkName);
    }

    public static void logProblem(Logger log, String msg, String testFrameworkName) {
        GoogleCloudTestingToSMTRunnerEventsConvertor.logProblem(log, msg, GoogleCloudTestResultsConnectionUtil.isInDebugMode(), testFrameworkName);
    }

    public static void logProblem(Logger log, String msg, boolean throwError, String testFrameworkName) {
        String text = GoogleCloudTestingToSMTRunnerEventsConvertor.getTFrameworkPrefix(testFrameworkName) + msg;
        if (throwError) {
            log.error(text);
        } else {
            log.warn(text);
        }
    }
}

