/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import git4idea.DialogManager;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.AbstractGithubUrlGroupingAction;
import org.jetbrains.plugins.github.GithubCreatePullRequestWorker;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.ui.GithubCreatePullRequestDialog;

public class GithubCreatePullRequestAction
extends AbstractGithubUrlGroupingAction {
    public GithubCreatePullRequestAction() {
        super("Create Pull Request", "Create pull request from current branch", AllIcons.Vcs.Vendors.Github);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String remoteUrl, @NotNull GithubAccount account) {
        GithubCreatePullRequestAction.createPullRequest(project, repository, remote, remoteUrl, account);
    }

    static void createPullRequest(@NotNull Project project, @NotNull GitRepository gitRepository, @NotNull GitRemote remote, @NotNull String remoteUrl, @NotNull GithubAccount account) {
        GithubApiRequestExecutor.WithTokenAuth executor = GithubApiRequestExecutorManager.getInstance().getExecutor(account, project);
        if (executor == null) {
            return;
        }
        GithubCreatePullRequestWorker worker = GithubCreatePullRequestWorker.create(project, gitRepository, remote, remoteUrl, executor, account.getServer());
        if (worker == null) {
            return;
        }
        GithubCreatePullRequestDialog dialog2 = new GithubCreatePullRequestDialog(project, worker);
        DialogManager.show((DialogWrapper)dialog2);
    }
}

