/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.CompareBranchesDialog;
import com.intellij.dvcs.ui.CompareBranchesHelper;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.fetch.GitFetchSupport;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitCompareBranchesHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubBranch;
import org.jetbrains.plugins.github.api.data.GithubPullRequestDetailed;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubRepoBasic;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.exceptions.GithubConfusingException;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.ui.GithubSelectForkDialog;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubProjectSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubCreatePullRequestWorker {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String CANNOT_CREATE_PULL_REQUEST = "Can't Create Pull Request";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepository myGitRepository;
    @NotNull
    private final GithubApiRequestExecutor myExecutor;
    @NotNull
    private final GithubServerPath myServer;
    @NotNull
    private final GithubGitHelper myGitHelper;
    @NotNull
    private final ProgressManager myProgressManager;
    @NotNull
    private final GithubFullPath myPath;
    @NotNull
    private final String myRemoteName;
    @NotNull
    private final String myRemoteUrl;
    @NotNull
    private final String myCurrentBranch;
    @NotNull
    private GithubFullPath mySource;
    @NotNull
    private final List<ForkInfo> myForks;
    @Nullable
    private List<GithubFullPath> myAvailableForks;

    private GithubCreatePullRequestWorker(@NotNull Project project, @NotNull Git git, @NotNull GitRepository gitRepository, @NotNull GithubApiRequestExecutor executor, @NotNull GithubServerPath server, @NotNull GithubGitHelper helper, @NotNull ProgressManager progressManager, @NotNull GithubFullPath path, @NotNull String remoteName, @NotNull String remoteUrl, @NotNull String currentBranch) {
        this.myProject = project;
        this.myGit = git;
        this.myGitRepository = gitRepository;
        this.myExecutor = executor;
        this.myServer = server;
        this.myGitHelper = helper;
        this.myProgressManager = progressManager;
        this.myPath = path;
        this.myRemoteName = remoteName;
        this.myRemoteUrl = remoteUrl;
        this.myCurrentBranch = currentBranch;
        this.myForks = new ArrayList<ForkInfo>();
    }

    @NotNull
    public String getCurrentBranch() {
        return this.myCurrentBranch;
    }

    @NotNull
    public List<ForkInfo> getForks() {
        return this.myForks;
    }

    @Nullable
    public static GithubCreatePullRequestWorker create(@NotNull Project project, @NotNull GitRepository gitRepository, @NotNull GitRemote remote, @NotNull String remoteUrl, @NotNull GithubApiRequestExecutor executor, @NotNull GithubServerPath server) {
        ProgressManager progressManager = ProgressManager.getInstance();
        return (GithubCreatePullRequestWorker)progressManager.runProcessWithProgressSynchronously(() -> {
            Git git = (Git)ServiceManager.getService(Git.class);
            GithubFullPath path = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl);
            if (path == null) {
                GithubNotifications.showError(project, CANNOT_CREATE_PULL_REQUEST, "Can't process remote: " + remoteUrl);
                return null;
            }
            GitLocalBranch currentBranch = gitRepository.getCurrentBranch();
            if (currentBranch == null) {
                GithubNotifications.showError(project, CANNOT_CREATE_PULL_REQUEST, "No current branch");
                return null;
            }
            GithubCreatePullRequestWorker worker = new GithubCreatePullRequestWorker(project, git, gitRepository, executor, server, GithubGitHelper.getInstance(), progressManager, path, remote.getName(), remoteUrl, currentBranch.getName());
            try {
                worker.initForks(progressManager.getProgressIndicator());
            }
            catch (IOException e) {
                GithubNotifications.showError(project, CANNOT_CREATE_PULL_REQUEST, e);
                return null;
            }
            return worker;
        }, "Loading Data...", true, project);
    }

    private void initForks(@NotNull ProgressIndicator indicator) throws IOException {
        this.doLoadForksFromGithub(indicator);
        this.doLoadForksFromGit(indicator);
        this.doLoadForksFromSettings(indicator);
    }

    private void doAddFork(@NotNull GithubFullPath path, @Nullable String remoteName, @NotNull ProgressIndicator indicator) {
        for (ForkInfo fork : this.myForks) {
            if (!fork.getPath().equals(path)) continue;
            if (fork.getRemoteName() == null && remoteName != null) {
                fork.setRemoteName(remoteName);
            }
            return;
        }
        try {
            List<String> branches = this.loadBranches(path, indicator);
            String defaultBranch = this.doLoadDefaultBranch(path, indicator);
            ForkInfo fork = new ForkInfo(path, branches, defaultBranch);
            this.myForks.add(fork);
            if (remoteName != null) {
                fork.setRemoteName(remoteName);
            }
        }
        catch (IOException e) {
            GithubNotifications.showWarning(this.myProject, "Can't load branches for " + path.getFullName(), e);
        }
    }

    @Nullable
    private ForkInfo doAddFork(@NotNull GithubRepo repo, @NotNull ProgressIndicator indicator) {
        GithubFullPath path = repo.getFullPath();
        for (ForkInfo fork : this.myForks) {
            if (!fork.getPath().equals(path)) continue;
            return fork;
        }
        try {
            List<String> branches = this.loadBranches(path, indicator);
            String defaultBranch = repo.getDefaultBranch();
            ForkInfo fork = new ForkInfo(path, branches, defaultBranch);
            this.myForks.add(fork);
            return fork;
        }
        catch (IOException e) {
            GithubNotifications.showWarning(this.myProject, "Can't load branches for " + path.getFullName(), e);
            return null;
        }
    }

    private void doLoadForksFromSettings(@NotNull ProgressIndicator indicator) {
        GithubFullPath savedRepo = GithubProjectSettings.getInstance(this.myProject).getCreatePullRequestDefaultRepo();
        if (savedRepo != null) {
            this.doAddFork(savedRepo, null, indicator);
        }
    }

    private void doLoadForksFromGit(@NotNull ProgressIndicator indicator) {
        block0: for (GitRemote remote : this.myGitRepository.getRemotes()) {
            for (String url : remote.getUrls()) {
                GithubFullPath path;
                if (!this.myServer.matches(url) || (path = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(url)) == null) continue;
                this.doAddFork(path, remote.getName(), indicator);
                continue block0;
            }
        }
    }

    private void doLoadForksFromGithub(@NotNull ProgressIndicator indicator) throws IOException {
        GithubRepoDetailed repo = this.myExecutor.execute(indicator, GithubApiRequests.Repos.get(this.myServer, this.myPath.getUser(), this.myPath.getRepository()));
        if (repo == null) {
            throw new GithubConfusingException("Can't find github repo " + this.myPath.toString());
        }
        this.doAddFork(repo, indicator);
        if (repo.getParent() != null) {
            this.doAddFork(repo.getParent(), indicator);
        }
        if (repo.getSource() != null) {
            this.doAddFork(repo.getSource(), indicator);
        }
        this.mySource = repo.getSource() == null ? repo.getFullPath() : repo.getSource().getFullPath();
    }

    @NotNull
    private List<String> loadBranches(@NotNull GithubFullPath fork, @NotNull ProgressIndicator indicator) throws IOException {
        List<GithubBranch> branches = GithubApiPagesLoader.loadAll(this.myExecutor, indicator, GithubApiRequests.Repos.Branches.pages(this.myServer, fork.getUser(), fork.getRepository()));
        return ContainerUtil.map(branches, GithubBranch::getName);
    }

    @Nullable
    private String doLoadDefaultBranch(@NotNull GithubFullPath fork, @NotNull ProgressIndicator indicator) throws IOException {
        GithubRepo repo = this.myExecutor.execute(indicator, GithubApiRequests.Repos.get(this.myServer, fork.getUser(), fork.getRepository()));
        if (repo == null) {
            throw new GithubConfusingException("Can't find github repo " + fork.toString());
        }
        return repo.getDefaultBranch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchFetchRemote(@NotNull ForkInfo fork) {
        if (fork.getRemoteName() == null) {
            return;
        }
        if (fork.getFetchTask() != null) {
            return;
        }
        Object object = fork.LOCK;
        synchronized (object) {
            if (fork.getFetchTask() != null) {
                return;
            }
            MasterFutureTask<Void> task = new MasterFutureTask<Void>(() -> {
                BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myProject, () -> this.doFetchRemote(fork));
                return null;
            });
            fork.setFetchTask(task);
            ApplicationManager.getApplication().executeOnPooledThread(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchLoadDiffInfo(@NotNull BranchInfo branch) {
        if (branch.getForkInfo().getRemoteName() == null) {
            return;
        }
        if (branch.getDiffInfoTask() != null) {
            return;
        }
        Object object = branch.LOCK;
        synchronized (object) {
            if (branch.getDiffInfoTask() != null) {
                return;
            }
            this.launchFetchRemote(branch.getForkInfo());
            MasterFutureTask<Void> masterTask = branch.getForkInfo().getFetchTask();
            assert (masterTask != null);
            SlaveFutureTask<DiffInfo> task = new SlaveFutureTask<DiffInfo>(masterTask, () -> this.doLoadDiffInfo(branch));
            branch.setDiffInfoTask(task);
            ApplicationManager.getApplication().executeOnPooledThread(task);
        }
    }

    @Nullable
    public DiffInfo getDiffInfo(@NotNull BranchInfo branch) throws IOException {
        if (branch.getForkInfo().getRemoteName() == null) {
            return null;
        }
        this.launchLoadDiffInfo(branch);
        assert (branch.getDiffInfoTask() != null);
        try {
            return (DiffInfo)branch.getDiffInfoTask().get();
        }
        catch (InterruptedException e) {
            throw new GithubOperationCanceledException(e);
        }
        catch (ExecutionException e) {
            Throwable ex = e.getCause();
            if (ex instanceof VcsException) {
                throw new IOException(ex);
            }
            LOG.error(ex);
            return null;
        }
    }

    private void doFetchRemote(@NotNull ForkInfo fork) {
        String remoteName = fork.getRemoteName();
        if (remoteName == null) {
            return;
        }
        GitRemote remote = GitUtil.findRemoteByName((GitRepository)this.myGitRepository, (String)remoteName);
        if (remote == null) {
            LOG.warn("Couldn't find remote " + remoteName + " in " + this.myGitRepository);
        }
        GitFetchSupport.fetchSupport((Project)this.myProject).fetch(this.myGitRepository, remote).showNotificationIfFailed();
    }

    @NotNull
    private DiffInfo doLoadDiffInfo(@NotNull BranchInfo branch) throws VcsException {
        String targetBranch = branch.getForkInfo().getRemoteName() + "/" + branch.getRemoteName();
        List commits1 = GitHistoryUtils.history((Project)this.myProject, (VirtualFile)this.myGitRepository.getRoot(), (String[])new String[]{".." + targetBranch});
        List commits2 = GitHistoryUtils.history((Project)this.myProject, (VirtualFile)this.myGitRepository.getRoot(), (String[])new String[]{targetBranch + ".."});
        Collection diff = GitChangeUtils.getDiff((Project)this.myProject, (VirtualFile)this.myGitRepository.getRoot(), (String)targetBranch, (String)this.myCurrentBranch, null);
        CommitCompareInfo info = new CommitCompareInfo(CommitCompareInfo.InfoType.BRANCH_TO_HEAD);
        info.putTotalDiff((Repository)this.myGitRepository, diff);
        info.put((Repository)this.myGitRepository, commits1, commits2);
        return new DiffInfo(info, this.myCurrentBranch, targetBranch);
    }

    private void doConfigureRemote(@NotNull ForkInfo fork) {
        if (fork.getRemoteName() != null) {
            return;
        }
        GithubFullPath path = fork.getPath();
        String url = this.myGitHelper.getRemoteUrl(this.myServer, path);
        try {
            this.myGit.addRemote(this.myGitRepository, path.getUser(), url).throwOnError(new int[0]);
            this.myGitRepository.update();
            fork.setRemoteName(path.getUser());
        }
        catch (VcsException e) {
            GithubNotifications.showError(this.myProject, "Can't add remote", "Failed to add GitHub remote: '" + url + "'. " + e.getMessage());
        }
    }

    public void configureRemote(@NotNull ForkInfo fork) {
        this.myProgressManager.runProcessWithProgressSynchronously(() -> this.doConfigureRemote(fork), "Creating Remote..", false, this.myProject);
    }

    @NotNull
    public Couple<String> getDefaultDescriptionMessage(@NotNull BranchInfo branch) {
        Couple<String> message = branch.getDefaultMessage();
        if (message != null) {
            return message;
        }
        if (branch.getForkInfo().getRemoteName() == null) {
            return this.getSimpleDefaultDescriptionMessage(branch);
        }
        return (Couple)this.myProgressManager.runProcessWithProgressSynchronously(() -> {
            String targetBranch = branch.getForkInfo().getRemoteName() + "/" + branch.getRemoteName();
            try {
                List commits = GitHistoryUtils.collectCommitsMetadata((Project)this.myProject, (VirtualFile)this.myGitRepository.getRoot(), (String[])new String[]{this.myCurrentBranch, targetBranch});
                if (commits == null) {
                    return this.getSimpleDefaultDescriptionMessage(branch);
                }
                VcsCommitMetadata localCommit = (VcsCommitMetadata)commits.get(0);
                VcsCommitMetadata targetCommit = (VcsCommitMetadata)commits.get(1);
                if (localCommit.getParents().contains(targetCommit.getId())) {
                    return GithubUtil.getGithubLikeFormattedDescriptionMessage(localCommit.getFullMessage());
                }
                return this.getSimpleDefaultDescriptionMessage(branch);
            }
            catch (ProcessCanceledException e) {
                return this.getSimpleDefaultDescriptionMessage(branch);
            }
            catch (VcsException e) {
                GithubNotifications.showWarning(this.myProject, "Can't collect additional data", (Exception)((Object)e));
                return this.getSimpleDefaultDescriptionMessage(branch);
            }
        }, "Collecting Last Commits...", true, this.myProject);
    }

    @NotNull
    public Couple<String> getSimpleDefaultDescriptionMessage(@NotNull BranchInfo branch) {
        Couple message = Couple.of((Object)this.myCurrentBranch, (Object)"");
        branch.setDefaultMessage((Couple<String>)message);
        return message;
    }

    public boolean checkAction(@Nullable BranchInfo branch) {
        DiffInfo info;
        if (branch == null) {
            GithubNotifications.showWarningDialog(this.myProject, CANNOT_CREATE_PULL_REQUEST, "Target branch is not selected");
            return false;
        }
        try {
            info = (DiffInfo)this.myProgressManager.runProcessWithProgressSynchronously(() -> (DiffInfo)GithubUtil.runInterruptable(this.myProgressManager.getProgressIndicator(), () -> this.getDiffInfo(branch)), "Collecting Diff Data...", false, this.myProject);
        }
        catch (IOException e) {
            GithubNotifications.showError(this.myProject, "Can't collect diff data", e);
            return true;
        }
        if (info == null) {
            return true;
        }
        ForkInfo fork = branch.getForkInfo();
        String localBranchName = "'" + this.myCurrentBranch + "'";
        String targetBranchName = "'" + fork.getRemoteName() + "/" + branch.getRemoteName() + "'";
        if (info.getInfo().getBranchToHeadCommits((Repository)this.myGitRepository).isEmpty()) {
            return GithubNotifications.showYesNoDialog(this.myProject, "Empty Pull Request", "The branch " + localBranchName + " is fully merged to the branch " + targetBranchName + '\n' + "Do you want to proceed anyway?");
        }
        if (!info.getInfo().getHeadToBranchCommits((Repository)this.myGitRepository).isEmpty()) {
            return GithubNotifications.showYesNoDialog(this.myProject, "Target Branch Is Not Fully Merged", "The branch " + targetBranchName + " is not fully merged to the branch " + localBranchName + '\n' + "Do you want to proceed anyway?");
        }
        return true;
    }

    public void createPullRequest(final @NotNull BranchInfo branch, final @NotNull String title, final @NotNull String description) {
        new Task.Backgroundable(this.myProject, "Creating Pull Request..."){

            public void run(@NotNull ProgressIndicator indicator) {
                LOG.info("Pushing current branch");
                indicator.setText("Pushing current branch...");
                GitCommandResult result = GithubCreatePullRequestWorker.this.myGit.push(GithubCreatePullRequestWorker.this.myGitRepository, GithubCreatePullRequestWorker.this.myRemoteName, GithubCreatePullRequestWorker.this.myRemoteUrl, GithubCreatePullRequestWorker.this.myCurrentBranch, true, new GitLineHandlerListener[0]);
                if (!result.success()) {
                    GithubNotifications.showError(GithubCreatePullRequestWorker.this.myProject, GithubCreatePullRequestWorker.CANNOT_CREATE_PULL_REQUEST, "Push failed:<br/>" + result.getErrorOutputAsHtmlString());
                    return;
                }
                LOG.info("Creating pull request");
                indicator.setText("Creating pull request...");
                GithubPullRequestDetailed request = GithubCreatePullRequestWorker.this.doCreatePullRequest(indicator, branch, title, description);
                if (request == null) {
                    return;
                }
                GithubNotifications.showInfoURL(GithubCreatePullRequestWorker.this.myProject, "Successfully created pull request", "Pull request #" + request.getNumber(), request.getHtmlUrl());
            }
        }.queue();
    }

    @Nullable
    private GithubPullRequestDetailed doCreatePullRequest(@NotNull ProgressIndicator indicator, @NotNull BranchInfo branch, @NotNull String title, @NotNull String description) {
        GithubFullPath forkPath = branch.getForkInfo().getPath();
        String head = this.myPath.getUser() + ":" + this.myCurrentBranch;
        String base = branch.getRemoteName();
        try {
            return this.myExecutor.execute(indicator, GithubApiRequests.Repos.PullRequests.create(this.myServer, forkPath.getUser(), forkPath.getRepository(), title, description, head, base));
        }
        catch (IOException e) {
            GithubNotifications.showError(this.myProject, CANNOT_CREATE_PULL_REQUEST, e);
            return null;
        }
    }

    public void showDiffDialog(@Nullable BranchInfo branch) {
        DiffInfo info;
        if (branch == null) {
            GithubNotifications.showWarningDialog(this.myProject, "Can't Show Diff", "Target branch is not selected");
            return;
        }
        try {
            info = (DiffInfo)this.myProgressManager.runProcessWithProgressSynchronously(() -> (DiffInfo)GithubUtil.runInterruptable(this.myProgressManager.getProgressIndicator(), () -> this.getDiffInfo(branch)), "Collecting Diff Data...", true, this.myProject);
        }
        catch (IOException e) {
            GithubNotifications.showError(this.myProject, "Can't collect diff data", e);
            return;
        }
        if (info == null) {
            GithubNotifications.showErrorDialog(this.myProject, "Can't Show Diff", "Can't collect diff data");
            return;
        }
        CompareBranchesDialog dialog2 = new CompareBranchesDialog((CompareBranchesHelper)new GitCompareBranchesHelper(this.myProject), info.getTo(), info.getFrom(), info.getInfo(), (Repository)this.myGitRepository, true);
        dialog2.show();
    }

    @Nullable
    public ForkInfo showTargetDialog() {
        if (this.myAvailableForks == null) {
            try {
                this.myAvailableForks = (List)this.myProgressManager.runProcessWithProgressSynchronously(() -> this.getAvailableForks(this.myProgressManager.getProgressIndicator()), this.myCurrentBranch, false, this.myProject);
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
        Convertor getForkPath = user -> (ForkInfo)this.myProgressManager.runProcessWithProgressSynchronously(() -> this.findRepositoryByUser(this.myProgressManager.getProgressIndicator(), (String)user), "Access to GitHub", false, this.myProject);
        GithubSelectForkDialog dialog2 = new GithubSelectForkDialog(this.myProject, this.myAvailableForks, (Convertor<? super String, ? extends ForkInfo>)getForkPath);
        DialogManager.show((DialogWrapper)dialog2);
        if (!dialog2.isOK()) {
            return null;
        }
        return dialog2.getPath();
    }

    @Nullable
    private List<GithubFullPath> getAvailableForks(@NotNull ProgressIndicator indicator) {
        try {
            List<GithubRepo> forks = GithubApiPagesLoader.loadAll(this.myExecutor, indicator, GithubApiRequests.Repos.Forks.pages(this.myServer, this.mySource.getUser(), this.mySource.getRepository()));
            List forkPaths = ContainerUtil.map(forks, GithubRepoBasic::getFullPath);
            if (!forkPaths.contains(this.mySource)) {
                return ContainerUtil.append((List)forkPaths, (Object[])new GithubFullPath[]{this.mySource});
            }
            return forkPaths;
        }
        catch (IOException e) {
            GithubNotifications.showWarning(this.myProject, "Can't load available forks", e);
            return null;
        }
    }

    @Nullable
    private ForkInfo findRepositoryByUser(@NotNull ProgressIndicator indicator, @NotNull String user) {
        for (ForkInfo fork2 : this.myForks) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)user, (CharSequence)fork2.getPath().getUser())) continue;
            return fork2;
        }
        try {
            GithubRepoDetailed target = this.myExecutor.execute(indicator, GithubApiRequests.Repos.get(this.myServer, user, this.mySource.getRepository()));
            GithubRepo repo = target != null && target.getSource() != null && StringUtil.equals((CharSequence)target.getSource().getUserName(), (CharSequence)this.mySource.getUser()) ? target : GithubApiPagesLoader.find(this.myExecutor, indicator, GithubApiRequests.Repos.Forks.pages(this.myServer, this.mySource.getUser(), this.mySource.getRepository()), fork -> StringUtil.equalsIgnoreCase((CharSequence)fork.getUserName(), (CharSequence)user));
            if (repo == null) {
                return null;
            }
            return this.doAddFork(repo, indicator);
        }
        catch (IOException e) {
            GithubNotifications.showError(this.myProject, "Can't find repository", e);
            return null;
        }
    }

    public static class MasterFutureTask<T>
    extends FutureTask<T> {
        @NotNull
        private final Object LOCK = new Object();
        private boolean myDone = false;
        @Nullable
        private List<SlaveFutureTask> mySlaves;

        public MasterFutureTask(@NotNull Callable<T> callable) {
            super(callable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addSlave(@NotNull SlaveFutureTask slave) {
            if (this.isDone()) {
                return false;
            }
            Object object = this.LOCK;
            synchronized (object) {
                if (this.myDone) {
                    return false;
                }
                if (this.mySlaves == null) {
                    this.mySlaves = new ArrayList<SlaveFutureTask>();
                }
                this.mySlaves.add(slave);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            Object object = this.LOCK;
            synchronized (object) {
                this.myDone = true;
                if (this.mySlaves != null) {
                    for (SlaveFutureTask slave : this.mySlaves) {
                        this.runSlave(slave);
                    }
                    this.mySlaves = null;
                }
            }
        }

        protected void runSlave(@NotNull SlaveFutureTask slave) {
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)slave);
        }
    }

    public static class SlaveFutureTask<T>
    extends FutureTask<T> {
        @NotNull
        private final MasterFutureTask myMaster;

        public SlaveFutureTask(@NotNull MasterFutureTask master, @NotNull Callable<T> callable) {
            super(callable);
            this.myMaster = master;
        }

        @Override
        public void run() {
            if (this.myMaster.isDone()) {
                super.run();
            } else if (!this.myMaster.addSlave(this)) {
                super.run();
            }
        }

        public T safeGet() {
            try {
                return (T)super.get();
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                return null;
            }
        }
    }

    public static class DiffInfo {
        @NotNull
        private final CommitCompareInfo myInfo;
        @NotNull
        private final String myFrom;
        @NotNull
        private final String myTo;

        private DiffInfo(@NotNull CommitCompareInfo info, @NotNull String from, @NotNull String to) {
            this.myInfo = info;
            this.myFrom = from;
            this.myTo = to;
        }

        @NotNull
        public CommitCompareInfo getInfo() {
            return this.myInfo;
        }

        @NotNull
        public String getFrom() {
            return this.myFrom;
        }

        @NotNull
        public String getTo() {
            return this.myTo;
        }
    }

    public static class BranchInfo {
        @NotNull
        public final Object LOCK = new Object();
        @NotNull
        private final ForkInfo myForkInfo;
        @NotNull
        private final String myRemoteName;
        @Nullable
        private SlaveFutureTask<DiffInfo> myDiffInfoTask;
        @Nullable
        private Couple<String> myDefaultMessage;

        public BranchInfo(@NotNull String remoteName, @NotNull ForkInfo fork) {
            this.myRemoteName = remoteName;
            this.myForkInfo = fork;
        }

        @NotNull
        public ForkInfo getForkInfo() {
            return this.myForkInfo;
        }

        @NotNull
        public String getRemoteName() {
            return this.myRemoteName;
        }

        @Nullable
        public SlaveFutureTask<DiffInfo> getDiffInfoTask() {
            return this.myDiffInfoTask;
        }

        public void setDiffInfoTask(@NotNull SlaveFutureTask<DiffInfo> diffInfoTask) {
            this.myDiffInfoTask = diffInfoTask;
        }

        @Nullable
        public Couple<String> getDefaultMessage() {
            return this.myDefaultMessage;
        }

        public void setDefaultMessage(@NotNull Couple<String> message) {
            this.myDefaultMessage = message;
        }

        public String toString() {
            return this.myRemoteName;
        }
    }

    public static class ForkInfo {
        @NotNull
        public final Object LOCK = new Object();
        @NotNull
        private final GithubFullPath myPath;
        @NotNull
        private final String myDefaultBranch;
        @NotNull
        private final List<BranchInfo> myBranches;
        @Nullable
        private String myRemoteName;
        private boolean myProposedToCreateRemote;
        @Nullable
        private MasterFutureTask<Void> myFetchTask;

        public ForkInfo(@NotNull GithubFullPath path, @NotNull List<String> branches, @Nullable String defaultBranch) {
            this.myPath = path;
            this.myDefaultBranch = defaultBranch == null ? "master" : defaultBranch;
            this.myBranches = new ArrayList<BranchInfo>();
            for (String branchName : branches) {
                this.myBranches.add(new BranchInfo(branchName, this));
            }
        }

        @NotNull
        public GithubFullPath getPath() {
            return this.myPath;
        }

        @Nullable
        public String getRemoteName() {
            return this.myRemoteName;
        }

        @NotNull
        public String getDefaultBranch() {
            return this.myDefaultBranch;
        }

        @NotNull
        public List<BranchInfo> getBranches() {
            return this.myBranches;
        }

        public void setRemoteName(@NotNull String remoteName) {
            this.myRemoteName = remoteName;
        }

        public boolean isProposedToCreateRemote() {
            return this.myProposedToCreateRemote;
        }

        public void setProposedToCreateRemote(boolean proposedToCreateRemote) {
            this.myProposedToCreateRemote = proposedToCreateRemote;
        }

        @Nullable
        public MasterFutureTask<Void> getFetchTask() {
            return this.myFetchTask;
        }

        public void setFetchTask(@NotNull MasterFutureTask<Void> fetchTask) {
            this.myFetchTask = fetchTask;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ForkInfo info = (ForkInfo)o;
            return this.myPath.equals(info.myPath);
        }

        public int hashCode() {
            return this.myPath.hashCode();
        }

        public String toString() {
            return this.myPath.getUser() + ":" + this.myPath.getRepository();
        }
    }
}

