/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.UpToDateLineNumberListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.annotate.GitFileAnnotation;
import git4idea.repo.GitRepository;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubOpenInBrowserActionGroup;
import org.jetbrains.plugins.github.api.GithubRepositoryPath;
import org.jetbrains.plugins.github.util.GithubGitHelper;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J$\u0010\r\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/GithubOpenInBrowserFromAnnotationActionGroup;", "Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup;", "Lcom/intellij/openapi/vcs/annotate/UpToDateLineNumberListener;", "annotation", "Lcom/intellij/openapi/vcs/annotate/FileAnnotation;", "(Lcom/intellij/openapi/vcs/annotate/FileAnnotation;)V", "getAnnotation", "()Lcom/intellij/openapi/vcs/annotate/FileAnnotation;", "myLineNumber", "", "consume", "", "integer", "getData", "Lkotlin/Pair;", "", "Lorg/jetbrains/plugins/github/api/GithubRepositoryPath;", "Lorg/jetbrains/plugins/github/GithubOpenInBrowserActionGroup$Data;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.vcs.github"})
public final class GithubOpenInBrowserFromAnnotationActionGroup
extends GithubOpenInBrowserActionGroup
implements UpToDateLineNumberListener {
    private int myLineNumber;
    @NotNull
    private final FileAnnotation annotation;

    @Override
    @Nullable
    protected Pair<Set<GithubRepositoryPath>, GithubOpenInBrowserActionGroup.Data> getData(@NotNull DataContext dataContext) {
        String revisionHash;
        if (this.myLineNumber < 0) {
            return null;
        }
        if (!(this.annotation instanceof GitFileAnnotation)) {
            return null;
        }
        Project project = ((GitFileAnnotation)this.annotation).getProject();
        VirtualFile virtualFile = ((GitFileAnnotation)this.annotation).getFile();
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)virtualFile);
        GitRepository gitRepository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForFile(filePath);
        if (gitRepository == null) {
            return null;
        }
        GitRepository repository = gitRepository;
        boolean $i$f$service = false;
        Set<GithubRepositoryPath> accessibleRepositories = ((GithubGitHelper)ServiceManager.getService(GithubGitHelper.class)).getPossibleRepositories(repository);
        if (accessibleRepositories.isEmpty()) {
            return null;
        }
        VcsRevisionNumber vcsRevisionNumber = this.annotation.getLineRevisionNumber(this.myLineNumber);
        String string = revisionHash = vcsRevisionNumber != null ? vcsRevisionNumber.asString() : null;
        if (revisionHash == null) {
            return null;
        }
        return TuplesKt.to(accessibleRepositories, (Object)new GithubOpenInBrowserActionGroup.Data.Revision(project, revisionHash));
    }

    public void consume(int integer) {
        this.myLineNumber = integer;
    }

    @NotNull
    public final FileAnnotation getAnnotation() {
        return this.annotation;
    }

    public GithubOpenInBrowserFromAnnotationActionGroup(@NotNull FileAnnotation annotation) {
        this.annotation = annotation;
        this.myLineNumber = -1;
    }
}

