/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.actions.BasicAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitVcsSettings;
import git4idea.fetch.GitFetchSupport;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaser;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitUpdateResult;
import git4idea.util.GitPreservingProcess;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.AbstractGithubUrlGroupingAction;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubRebaseAction
extends AbstractGithubUrlGroupingAction {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String CANNOT_PERFORM_GITHUB_REBASE = "Can't perform GitHub rebase";

    public GithubRebaseAction() {
        super("Rebase my GitHub fork", "Rebase your GitHub forked repository relative to the origin", AllIcons.Vcs.Vendors.Github);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String remoteUrl, @NotNull GithubAccount account) {
        BasicAction.saveAll();
        GithubApiRequestExecutor.WithTokenAuth executor = GithubApiRequestExecutorManager.getInstance().getExecutor(account, project);
        if (executor == null) {
            return;
        }
        GithubFullPath repoPath = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl);
        if (repoPath == null) {
            GithubNotifications.showError(project, CANNOT_PERFORM_GITHUB_REBASE, "Invalid Github remote: " + remoteUrl);
            return;
        }
        new RebaseTask(project, executor, Git.getInstance(), account.getServer(), repository, repoPath, "upstream/master").queue();
    }

    private static class RebaseTask
    extends Task.Backgroundable {
        @NotNull
        private final GithubApiRequestExecutor myRequestExecutor;
        @NotNull
        private final Git myGit;
        @NotNull
        private final GithubServerPath myServer;
        @NotNull
        private final GitRepository myRepository;
        @NotNull
        private final GithubFullPath myRepoPath;
        @NotNull
        private final String myOnto;

        RebaseTask(@NotNull Project project, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull Git git, @NotNull GithubServerPath server, @NotNull GitRepository repository, @NotNull GithubFullPath repoPath, @NotNull String rebaseOnto) {
            super(project, "Rebasing GitHub Fork...");
            this.myRequestExecutor = requestExecutor;
            this.myGit = git;
            this.myServer = server;
            this.myRepository = repository;
            this.myRepoPath = repoPath;
            this.myOnto = rebaseOnto;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            this.myRepository.update();
            String upstreamRemoteUrl = this.findUpstreamRemoteUrl();
            if (upstreamRemoteUrl == null) {
                indicator.setText("Configuring upstream remote...");
                LOG.info("Configuring upstream remote");
                upstreamRemoteUrl = this.configureUpstreamRemote(indicator);
                if (upstreamRemoteUrl == null) {
                    return;
                }
            }
            if (this.isUpstreamWithSameUsername(indicator, upstreamRemoteUrl)) {
                GithubNotifications.showError(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Configured upstream seems to be your own repository: " + upstreamRemoteUrl);
                return;
            }
            LOG.info("Fetching upstream");
            indicator.setText("Fetching upstream...");
            if (!this.fetchParent(indicator)) {
                return;
            }
            LOG.info("Rebasing current branch");
            indicator.setText("Rebasing current branch...");
            this.rebaseCurrentBranch(indicator);
        }

        @Nullable
        private String findUpstreamRemoteUrl() {
            return this.myRepository.getRemotes().stream().filter(remote -> remote.getName().equals("upstream") && remote.getFirstUrl() != null && this.myServer.matches(remote.getFirstUrl())).findFirst().map(GitRemote::getFirstUrl).orElse(null);
        }

        private boolean isUpstreamWithSameUsername(@NotNull ProgressIndicator indicator, @NotNull String upstreamRemoteUrl) {
            try {
                GithubFullPath userAndRepo = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(upstreamRemoteUrl);
                if (userAndRepo == null) {
                    GithubNotifications.showError(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Can't validate upstream remote: " + upstreamRemoteUrl);
                    return true;
                }
                String username = this.myRequestExecutor.execute(indicator, GithubApiRequests.CurrentUser.get(this.myServer)).getLogin();
                return userAndRepo.getUser().equals(username);
            }
            catch (IOException e) {
                GithubNotifications.showError(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Can't get user information");
                return true;
            }
        }

        @Nullable
        private String configureUpstreamRemote(@NotNull ProgressIndicator indicator) {
            GithubRepoDetailed repositoryInfo = this.loadRepositoryInfo(indicator, this.myRepoPath);
            if (repositoryInfo == null) {
                return null;
            }
            if (!repositoryInfo.isFork() || repositoryInfo.getParent() == null) {
                GithubNotifications.showWarningURL(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "GitHub repository ", "'" + repositoryInfo.getName() + "'", " is not a fork", repositoryInfo.getHtmlUrl());
                return null;
            }
            String parentRepoUrl = GithubGitHelper.getInstance().getRemoteUrl(this.myServer, repositoryInfo.getParent().getFullPath());
            LOG.info("Adding GitHub parent as a remote host");
            indicator.setText("Adding GitHub parent as a remote host...");
            try {
                this.myGit.addRemote(this.myRepository, "upstream", parentRepoUrl).throwOnError(new int[0]);
            }
            catch (VcsException e) {
                GithubNotifications.showError(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Could not configure \"upstream\" remote:\n" + e.getMessage());
                return null;
            }
            this.myRepository.update();
            return parentRepoUrl;
        }

        @Nullable
        private GithubRepoDetailed loadRepositoryInfo(@NotNull ProgressIndicator indicator, @NotNull GithubFullPath fullPath) {
            try {
                GithubRepoDetailed repo = this.myRequestExecutor.execute(indicator, GithubApiRequests.Repos.get(this.myServer, fullPath.getUser(), fullPath.getRepository()));
                if (repo == null) {
                    GithubNotifications.showError(this.myProject, "Repository " + fullPath.toString() + " was not found", "");
                }
                return repo;
            }
            catch (IOException e) {
                GithubNotifications.showError(this.myProject, "Can't load repository info", e);
                return null;
            }
        }

        private boolean fetchParent(@NotNull ProgressIndicator indicator) {
            GitRemote remote = GitUtil.findRemoteByName((GitRepository)this.myRepository, (String)"upstream");
            if (remote == null) {
                LOG.warn("Couldn't find remote  remoteName  in " + this.myRepository);
                return false;
            }
            return GitFetchSupport.fetchSupport((Project)this.myProject).fetch(this.myRepository, remote).showNotificationIfFailed();
        }

        private void rebaseCurrentBranch(@NotNull ProgressIndicator indicator) {
            try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)"Rebase");){
                List<VirtualFile> rootsToSave = Collections.singletonList(this.myRepository.getRoot());
                GitPreservingProcess process = new GitPreservingProcess(this.myProject, this.myGit, rootsToSave, "Rebasing", this.myOnto, GitVcsSettings.UpdateChangesPolicy.STASH, indicator, () -> this.doRebaseCurrentBranch(indicator));
                process.execute();
            }
        }

        private void doRebaseCurrentBranch(@NotNull ProgressIndicator indicator) {
            GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager((Project)this.myProject);
            GitRebaser rebaser = new GitRebaser(this.myProject, this.myGit, indicator);
            VirtualFile root = this.myRepository.getRoot();
            GitLineHandler handler = new GitLineHandler(this.myProject, root, GitCommand.REBASE);
            handler.setStdoutSuppressed(false);
            handler.addParameters(new String[]{this.myOnto});
            GitRebaseProblemDetector rebaseConflictDetector = new GitRebaseProblemDetector();
            handler.addLineListener((GitLineHandlerListener)rebaseConflictDetector);
            GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
            GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.CHECKOUT);
            handler.addLineListener((GitLineHandlerListener)untrackedFilesDetector);
            handler.addLineListener((GitLineHandlerListener)localChangesDetector);
            handler.addLineListener(GitStandardProgressAnalyzer.createListener((ProgressIndicator)indicator));
            String oldText = indicator.getText();
            indicator.setText("Rebasing onto " + this.myOnto + "...");
            GitCommandResult rebaseResult = this.myGit.runCommand(handler);
            indicator.setText(oldText);
            repositoryManager.updateRepository(root);
            if (rebaseResult.success()) {
                root.refresh(false, true);
                GithubNotifications.showInfo(this.myProject, "Success", "Successfully rebased GitHub fork");
            } else {
                GitUpdateResult result = rebaser.handleRebaseFailure(handler, root, rebaseResult, rebaseConflictDetector, (GitMessageWithFilesDetector)untrackedFilesDetector, localChangesDetector);
                if (result == GitUpdateResult.NOTHING_TO_UPDATE || result == GitUpdateResult.SUCCESS || result == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) {
                    GithubNotifications.showInfo(this.myProject, "Success", "Successfully rebased GitHub fork");
                }
            }
        }
    }
}

