/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.NullCheckingFactory;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.data.GithubGist;
import org.jetbrains.plugins.github.api.data.GithubIssue;
import org.jetbrains.plugins.github.exceptions.GithubConfusingException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;

@Deprecated
public class GithubApiUtil {
    private static final Header ACCEPT_V3_JSON = new BasicHeader("Accept", "application/vnd.github.v3+json");
    @NotNull
    private static final Gson gson = GithubApiUtil.initGson();

    private static Gson initGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        builder.registerTypeAdapterFactory((TypeAdapterFactory)NullCheckingFactory.INSTANCE);
        return builder.create();
    }

    @Deprecated
    @NotNull
    public static <T> T fromJson(@Nullable JsonElement json, @NotNull Class<T> classT) throws IOException {
        if (json == null) {
            throw new GithubJsonException("Unexpected empty response");
        }
        try {
            Object res = gson.fromJson(json, classT);
            if (res == null) {
                throw new GithubJsonException("Empty Json response");
            }
            return (T)res;
        }
        catch (JsonParseException | ClassCastException e) {
            throw new GithubJsonException("Parse exception while converting JSON to object " + classT.toString(), e);
        }
    }

    @Deprecated
    @NotNull
    private static <T> T load(@NotNull GithubConnection connection, @NotNull String path, @NotNull Class<? extends T> type, Header ... headers) throws IOException {
        JsonElement result = connection.getRequest(path, headers);
        return GithubApiUtil.fromJson(result, type);
    }

    @Deprecated
    @NotNull
    public static GithubGist getGist(@NotNull GithubConnection connection, @NotNull String id) throws IOException {
        try {
            String path = "/gists/" + id;
            return GithubApiUtil.load(connection, path, GithubGist.class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get gist info: id " + id);
            throw e;
        }
    }

    @Deprecated
    @NotNull
    public static GithubIssue getIssue(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @NotNull String id) throws IOException {
        try {
            String path = "/repos/" + user + "/" + repo + "/issues/" + id;
            return GithubApiUtil.load(connection, path, GithubIssue.class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get issue info: " + user + "/" + repo + " - " + id);
            throw e;
        }
    }
}

