/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubConnectionBuilder;
import org.jetbrains.plugins.github.api.data.GithubErrorMessage;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubConfusingException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.exceptions.GithubRateLimitExceededException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.exceptions.GithubTwoFactorAuthenticationException;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

@Deprecated
public class GithubConnection {
    private static final Logger LOG = GithubUtil.LOG;
    @Nullable
    private GithubAccount myAccount;
    @NotNull
    private final String myApiURL;
    @NotNull
    private final CloseableHttpClient myClient;
    private final boolean myReusable;
    private volatile HttpUriRequest myRequest;
    private volatile boolean myAborted;

    public GithubConnection(@NotNull GithubAuthData auth, boolean reusable) {
        this.myApiURL = GithubUrlUtil.getApiUrl(auth.getHost());
        this.myClient = new GithubConnectionBuilder(auth, this.myApiURL).createClient();
        this.myReusable = reusable;
    }

    @Nullable
    public JsonElement getRequest(@NotNull String path, Header ... headers) throws IOException {
        return this.request(path, null, Arrays.asList(headers), HttpVerb.GET).getJsonElement();
    }

    @Nullable
    public JsonElement postRequest(@NotNull String path, @Nullable String requestBody, Header ... headers) throws IOException {
        return this.request(path, requestBody, Arrays.asList(headers), HttpVerb.POST).getJsonElement();
    }

    @Nullable
    public JsonElement patchRequest(@NotNull String path, @Nullable String requestBody, Header ... headers) throws IOException {
        return this.request(path, requestBody, Arrays.asList(headers), HttpVerb.PATCH).getJsonElement();
    }

    @Nullable
    public JsonElement deleteRequest(@NotNull String path, Header ... headers) throws IOException {
        return this.request(path, null, Arrays.asList(headers), HttpVerb.DELETE).getJsonElement();
    }

    @NotNull
    public Header[] headRequest(@NotNull String path, Header ... headers) throws IOException {
        return this.request(path, null, Arrays.asList(headers), HttpVerb.HEAD).getHeaders();
    }

    @Nullable
    public GithubAccount getAccount() {
        return this.myAccount;
    }

    public void setAccount(@NotNull GithubAccount account) {
        this.myAccount = account;
    }

    @NotNull
    String getApiURL() {
        return this.myApiURL;
    }

    public void abort() {
        if (this.myAborted) {
            return;
        }
        this.myAborted = true;
        HttpUriRequest request = this.myRequest;
        if (request != null) {
            request.abort();
        }
    }

    public void close() throws IOException {
        this.myClient.close();
    }

    @NotNull
    private ResponsePage request(@NotNull String path, @Nullable String requestBody, @NotNull Collection<Header> headers, @NotNull HttpVerb verb) throws IOException {
        return this.doRequest(this.myApiURL + path, requestBody, headers, verb);
    }

    @NotNull
    private ResponsePage doRequest(@NotNull String uri, @Nullable String requestBody, @NotNull Collection<Header> headers, @NotNull HttpVerb verb) throws IOException {
        if (this.myAborted) {
            throw new GithubOperationCanceledException();
        }
        if (EventQueue.isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.warn("Network operation in EDT");
        }
        CloseableHttpResponse response = null;
        try {
            response = this.doREST(uri, requestBody, headers, verb);
            if (this.myAborted) {
                throw new GithubOperationCanceledException();
            }
            GithubConnection.checkStatusCode(response, requestBody);
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                ResponsePage responsePage = this.createResponse(response);
                return responsePage;
            }
            JsonElement ret = GithubConnection.parseResponse(entity.getContent());
            if (ret.isJsonNull()) {
                ResponsePage responsePage = this.createResponse(response);
                return responsePage;
            }
            String nextPage = null;
            Header pageHeader = response.getFirstHeader("Link");
            if (pageHeader != null) {
                for (HeaderElement element : pageHeader.getElements()) {
                    NameValuePair rel = element.getParameterByName("rel");
                    if (rel == null || !"next".equals(rel.getValue())) continue;
                    String urlString = element.toString();
                    int begin = urlString.indexOf(60);
                    int end = urlString.lastIndexOf(62);
                    if (begin == -1 || end == -1) {
                        LOG.error("Invalid 'Link' header", new String[]{"{" + pageHeader.toString() + "}"});
                        break;
                    }
                    nextPage = urlString.substring(begin + 1, end);
                    break;
                }
            }
            ResponsePage responsePage = this.createResponse(ret, nextPage, response);
            return responsePage;
        }
        catch (SSLHandshakeException e) {
            if (e.getCause() instanceof CertificateException) {
                LOG.info("Host SSL certificate is not trusted", (Throwable)e);
                throw new GithubOperationCanceledException("Host SSL certificate is not trusted", e);
            }
            throw e;
        }
        catch (IOException e) {
            if (this.myAborted) {
                throw new GithubOperationCanceledException("Operation canceled", e);
            }
            throw e;
        }
        finally {
            this.myRequest = null;
            if (response != null) {
                response.close();
            }
            if (!this.myReusable) {
                this.myClient.close();
            }
        }
    }

    @NotNull
    private CloseableHttpResponse doREST(@NotNull String uri, @Nullable String requestBody, @NotNull Collection<Header> headers, @NotNull HttpVerb verb) throws IOException {
        HttpPost request;
        switch (verb) {
            case POST: {
                request = new HttpPost(uri);
                if (requestBody == null) break;
                request.setEntity((HttpEntity)new StringEntity(requestBody, ContentType.APPLICATION_JSON));
                break;
            }
            case PATCH: {
                request = new HttpPatch(uri);
                if (requestBody == null) break;
                ((HttpPatch)request).setEntity((HttpEntity)new StringEntity(requestBody, ContentType.APPLICATION_JSON));
                break;
            }
            case GET: {
                request = new HttpGet(uri);
                break;
            }
            case DELETE: {
                request = new HttpDelete(uri);
                break;
            }
            case HEAD: {
                request = new HttpHead(uri);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown HttpVerb: " + verb.toString());
            }
        }
        for (Header header : headers) {
            request.addHeader(header);
        }
        this.myRequest = request;
        return this.myClient.execute((HttpUriRequest)request);
    }

    private static void checkStatusCode(@NotNull CloseableHttpResponse response, @Nullable String body2) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        switch (code) {
            case 200: 
            case 201: 
            case 202: 
            case 204: {
                return;
            }
            case 401: 
            case 402: 
            case 403: {
                GithubStatusCodeException error = GithubConnection.getStatusCodeException(response);
                Header headerOTP = response.getFirstHeader("X-GitHub-OTP");
                if (headerOTP != null) {
                    for (HeaderElement element : headerOTP.getElements()) {
                        if (!"required".equals(element.getName())) continue;
                        throw new GithubTwoFactorAuthenticationException(error.getMessage());
                    }
                }
                if (error.getError() != null && error.getError().containsReasonMessage("API rate limit exceeded")) {
                    throw new GithubRateLimitExceededException(error.getMessage());
                }
                throw new GithubAuthenticationException("Request response: " + error.getMessage());
            }
            case 400: 
            case 422: {
                LOG.info("body message:" + body2);
                throw GithubConnection.getStatusCodeException(response);
            }
        }
        throw GithubConnection.getStatusCodeException(response);
    }

    @NotNull
    private static GithubStatusCodeException getStatusCodeException(@NotNull CloseableHttpResponse response) {
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        String reason = statusCode + " " + statusLine.getReasonPhrase();
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                GithubErrorMessage error = GithubApiUtil.fromJson(GithubConnection.parseResponse(entity.getContent()), GithubErrorMessage.class);
                String message = reason + " - " + error.getMessage();
                return new GithubStatusCodeException(message, error, statusCode);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return new GithubStatusCodeException(reason, statusCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static JsonElement parseResponse(@NotNull InputStream githubResponse) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(githubResponse, CharsetToolkit.UTF8_CHARSET);){
            JsonElement jsonElement = new JsonParser().parse((Reader)reader);
            return jsonElement;
        }
        catch (JsonParseException jse) {
            throw new GithubJsonException("Couldn't parse GitHub response", jse);
        }
    }

    private ResponsePage createResponse(@NotNull CloseableHttpResponse response) throws GithubOperationCanceledException {
        if (this.myAborted) {
            throw new GithubOperationCanceledException();
        }
        return new ResponsePage(null, null, response.getAllHeaders());
    }

    private ResponsePage createResponse(@NotNull JsonElement ret, @Nullable String path, @NotNull CloseableHttpResponse response) throws GithubOperationCanceledException {
        if (this.myAborted) {
            throw new GithubOperationCanceledException();
        }
        return new ResponsePage(ret, path, response.getAllHeaders());
    }

    public static interface PagedRequest<T> {
        @NotNull
        public List<T> next(@NotNull GithubConnection var1) throws IOException;

        public boolean hasNext();

        @NotNull
        default public List<T> getAll(@NotNull GithubConnection connection) throws IOException {
            ArrayList<T> result = new ArrayList<T>();
            while (this.hasNext()) {
                result.addAll(this.next(connection));
            }
            return result;
        }
    }

    private static class ResponsePage {
        @Nullable
        private final JsonElement myResponse;
        @Nullable
        private final String myNextPage;
        @NotNull
        private final Header[] myHeaders;

        ResponsePage(@Nullable JsonElement response, @Nullable String next, @NotNull Header[] headers) {
            this.myResponse = response;
            this.myNextPage = next;
            this.myHeaders = headers;
        }

        @Nullable
        public JsonElement getJsonElement() {
            return this.myResponse;
        }

        @Nullable
        public String getNextPage() {
            return this.myNextPage;
        }

        @NotNull
        public Header[] getHeaders() {
            return this.myHeaders;
        }
    }

    public static class SingleValuePagedRequest<T>
    extends PagedRequestBase<T> {
        @NotNull
        private final Class<? extends T> myType;

        public SingleValuePagedRequest(@NotNull String path, @NotNull Class<? extends T> type, Header ... headers) {
            super(path, headers);
            this.myType = type;
        }

        @Override
        protected List<T> parse(@NotNull JsonElement response) throws IOException {
            T result = GithubApiUtil.fromJson(response, this.myType);
            return Collections.singletonList(result);
        }
    }

    public static class ArrayPagedRequest<T>
    extends PagedRequestBase<T> {
        @NotNull
        private final Class<? extends T[]> myTypeArray;

        public ArrayPagedRequest(@NotNull String path, @NotNull Class<? extends T[]> typeArray, Header ... headers) {
            super(path, headers);
            this.myTypeArray = typeArray;
        }

        @Override
        protected List<T> parse(@NotNull JsonElement response) throws IOException {
            if (!response.isJsonArray()) {
                throw new GithubJsonException("Wrong json type: expected JsonArray", new Exception(response.toString()));
            }
            T[] result = GithubApiUtil.fromJson((JsonElement)response.getAsJsonArray(), this.myTypeArray);
            return Arrays.asList(result);
        }
    }

    public static abstract class PagedRequestBase<T>
    implements PagedRequest<T> {
        @NotNull
        private final String myPath;
        @NotNull
        private final Collection<Header> myHeaders;
        private boolean myFirstRequest = true;
        @Nullable
        private String myNextPage;

        public PagedRequestBase(@NotNull String path, Header ... headers) {
            this.myPath = path;
            this.myHeaders = Arrays.asList(headers);
        }

        @Override
        @NotNull
        public List<T> next(@NotNull GithubConnection connection) throws IOException {
            String url;
            if (this.myFirstRequest) {
                url = connection.getApiURL() + this.myPath;
                this.myFirstRequest = false;
            } else {
                if (this.myNextPage == null) {
                    throw new NoSuchElementException();
                }
                url = this.myNextPage;
                this.myNextPage = null;
            }
            ResponsePage response = connection.doRequest(url, null, this.myHeaders, HttpVerb.GET);
            this.myNextPage = response.getNextPage();
            if (response.getJsonElement() == null) {
                throw new GithubConfusingException("Empty response");
            }
            return this.parse(response.getJsonElement());
        }

        @Override
        public boolean hasNext() {
            return this.myFirstRequest || this.myNextPage != null;
        }

        protected abstract List<T> parse(@NotNull JsonElement var1) throws IOException;
    }

    private static enum HttpVerb {
        GET,
        POST,
        DELETE,
        HEAD,
        PATCH;

    }
}

