/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubFullPath {
    @NotNull
    private final String myUserName;
    @NotNull
    private final String myRepositoryName;

    public GithubFullPath(@NotNull String userName, @NotNull String repositoryName) {
        this.myUserName = userName;
        this.myRepositoryName = repositoryName;
    }

    @NotNull
    public String getUser() {
        return this.myUserName;
    }

    @NotNull
    public String getRepository() {
        return this.myRepositoryName;
    }

    @NotNull
    public String getFullName() {
        return this.myUserName + '/' + this.myRepositoryName;
    }

    public String toString() {
        return "'" + this.getFullName() + "'";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GithubFullPath that = (GithubFullPath)o;
        if (!StringUtil.equalsIgnoreCase((CharSequence)this.myRepositoryName, (CharSequence)that.myRepositoryName)) {
            return false;
        }
        return StringUtil.equalsIgnoreCase((CharSequence)this.myUserName, (CharSequence)that.myUserName);
    }

    public int hashCode() {
        int result = this.myUserName.hashCode();
        result = 31 * result + this.myRepositoryName.hashCode();
        return result;
    }
}

