/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.exceptions.GithubParseException;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

@Tag(value="server")
public class GithubServerPath {
    public static final String DEFAULT_HOST = "github.com";
    public static final GithubServerPath DEFAULT_SERVER = new GithubServerPath("github.com");
    private static final String API_PREFIX = "api.";
    private static final String ENTERPRISE_API_SUFFIX = "/api/v3";
    @Attribute(value="useHttp")
    @Nullable
    private final Boolean myUseHttp;
    @Attribute(value="host")
    @NotNull
    private final String myHost;
    @Attribute(value="port")
    @Nullable
    private final Integer myPort;
    @Attribute(value="suffix")
    @Nullable
    private final String mySuffix;
    private static final Pattern URL_REGEX = Pattern.compile("^(https?://)?([^/?:]+)(:(\\d+))?((/[^/?#]+)*)?/?", 2);

    public GithubServerPath() {
        this(null, "", null, null);
    }

    public GithubServerPath(@NonNls @NotNull String host) {
        this(null, host, null, null);
    }

    public GithubServerPath(@Nullable Boolean useHttp, @NonNls @NotNull String host, @Nullable Integer port, @NonNls @Nullable String suffix) {
        this.myUseHttp = useHttp;
        this.myHost = host.toLowerCase(Locale.ENGLISH);
        this.myPort = port;
        this.mySuffix = suffix;
    }

    @NotNull
    public String getSchema() {
        return this.myUseHttp == null || this.myUseHttp == false ? "https" : "http";
    }

    @NotNull
    public String getHost() {
        return this.myHost;
    }

    @Nullable
    public Integer getPort() {
        return this.myPort;
    }

    @Nullable
    public String getSuffix() {
        return this.mySuffix;
    }

    public boolean matches(@NotNull String gitRemoteUrl) {
        String url = GithubUrlUtil.removePort(GithubUrlUtil.removeProtocolPrefix(gitRemoteUrl));
        return StringUtil.startsWithIgnoreCase((String)url, (String)(this.myHost + StringUtil.notNullize((String)this.mySuffix)));
    }

    @NotNull
    public static GithubServerPath from(@NotNull String uri) throws GithubParseException {
        Integer port;
        Matcher matcher = URL_REGEX.matcher(uri);
        if (!matcher.matches()) {
            throw new GithubParseException("Not a valid URL");
        }
        String schema = matcher.group(1);
        Boolean httpSchema = schema == null || schema.isEmpty() ? null : Boolean.valueOf(schema.equalsIgnoreCase("http://"));
        String host = matcher.group(2);
        if (host == null) {
            throw new GithubParseException("Empty host");
        }
        String portGroup = matcher.group(4);
        if (portGroup == null) {
            port = null;
        } else {
            try {
                port = Integer.parseInt(portGroup);
            }
            catch (NumberFormatException e) {
                throw new GithubParseException("Invalid port format");
            }
        }
        String path = StringUtil.nullize((String)matcher.group(5));
        return new GithubServerPath(httpSchema, host, port, path);
    }

    @NotNull
    public String toUrl() {
        return this.getSchemaUrlPart() + this.myHost + this.getPortUrlPart() + StringUtil.notNullize((String)this.mySuffix);
    }

    @NotNull
    public String toApiUrl() {
        StringBuilder builder = new StringBuilder(this.getSchemaUrlPart());
        if (this.myHost.equalsIgnoreCase(DEFAULT_HOST)) {
            builder.append(API_PREFIX).append(this.myHost).append(this.getPortUrlPart()).append(StringUtil.notNullize((String)this.mySuffix));
        } else {
            builder.append(this.myHost).append(this.getPortUrlPart()).append(StringUtil.notNullize((String)this.mySuffix)).append(ENTERPRISE_API_SUFFIX);
        }
        return builder.toString();
    }

    public String toString() {
        String schema = this.myUseHttp != null ? this.getSchemaUrlPart() : "";
        return schema + this.myHost + this.getPortUrlPart() + StringUtil.notNullize((String)this.mySuffix);
    }

    @NotNull
    private String getPortUrlPart() {
        return this.myPort != null ? ":" + this.myPort.toString() : "";
    }

    @NotNull
    private String getSchemaUrlPart() {
        return this.getSchema() + "://";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GithubServerPath)) {
            return false;
        }
        GithubServerPath path = (GithubServerPath)o;
        return Objects.equals(this.myUseHttp, path.myUseHttp) && Objects.equals(this.myHost, path.myHost) && Objects.equals(this.myPort, path.myPort) && Objects.equals(this.mySuffix, path.mySuffix);
    }

    public int hashCode() {
        return Objects.hash(this.myUseHttp, this.myHost, this.myPort, this.mySuffix);
    }
}

