/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.Mandatory;
import org.jetbrains.io.mandatory.RestModel;

@RestModel
public class GithubErrorMessage {
    @Mandatory
    private String message;
    private List<Error> errors;

    @NotNull
    public String getMessage() {
        return this.message;
    }

    @NotNull
    public List<Error> getErrors() {
        if (this.errors == null) {
            return Collections.emptyList();
        }
        return this.errors;
    }

    @NotNull
    public String getPresentableError() {
        if (this.errors == null) {
            return this.message;
        }
        StringBuilder s = new StringBuilder();
        s.append(this.message);
        for (Error e : this.errors) {
            s.append(String.format("<br/>[%s; %s]%s: %s", e.resource, e.field, e.code, e.message));
        }
        return s.toString();
    }

    public boolean containsReasonMessage(@NotNull String reason) {
        if (this.message == null) {
            return false;
        }
        return this.message.contains(reason);
    }

    public boolean containsErrorCode(@NotNull String code) {
        if (this.errors == null) {
            return false;
        }
        for (Error error : this.errors) {
            if (error.code == null || !error.code.contains(code)) continue;
            return true;
        }
        return false;
    }

    public boolean containsErrorMessage(@NotNull String message) {
        if (this.errors == null) {
            return false;
        }
        for (Error error : this.errors) {
            if (error.code == null || !error.code.contains(message)) continue;
            return true;
        }
        return false;
    }

    @RestModel
    public static class Error {
        @Mandatory
        private String resource;
        private String field;
        @Mandatory
        private String code;
        private String message;

        @NotNull
        public String getResource() {
            return this.resource;
        }

        @Nullable
        public String getField() {
            return this.field;
        }

        @NotNull
        public String getCode() {
            return this.code;
        }

        @Nullable
        public String getMessage() {
            return this.message;
        }
    }
}

