/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.Mandatory;
import org.jetbrains.io.mandatory.RestModel;
import org.jetbrains.plugins.github.api.data.GithubUser;

@RestModel
public class GithubGist {
    @Mandatory
    private String id;
    private String description;
    @SerializedName(value="public")
    @Mandatory
    private Boolean isPublic;
    private String url;
    @Mandatory
    private String htmlUrl;
    private String gitPullUrl;
    private String gitPushUrl;
    @Mandatory
    private Map<String, GistFile> files;
    private GithubUser owner;
    private Date createdAt;

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getDescription() {
        return StringUtil.notNullize((String)this.description);
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    @NotNull
    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    @NotNull
    public List<GistFile> getFiles() {
        return new ArrayList<GistFile>(this.files.values());
    }

    @Nullable
    public GithubUser getUser() {
        return this.owner;
    }

    @RestModel
    public static class GistFile {
        private Long size;
        @Mandatory
        private String filename;
        @Mandatory
        private String content;
        @Mandatory
        private String raw_url;
        private String type;
        private String language;

        @NotNull
        public String getFilename() {
            return this.filename;
        }

        @NotNull
        public String getContent() {
            return this.content;
        }

        @NotNull
        public String getRawUrl() {
            return this.raw_url;
        }
    }
}

