/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import com.intellij.util.ObjectUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.Mandatory;
import org.jetbrains.io.mandatory.RestModel;
import org.jetbrains.plugins.github.api.data.GithubIssueLabel;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.api.data.util.GithubLink;

@RestModel
public class GithubPullRequest {
    @Mandatory
    private String url;
    @Mandatory
    private Long id;
    @Mandatory
    private String htmlUrl;
    @Mandatory
    private String diffUrl;
    @Mandatory
    private String patchUrl;
    @Mandatory
    private Long number;
    @Mandatory
    private GithubIssueState state;
    @Mandatory
    private Boolean locked;
    private String activeLockReason;
    @Mandatory
    private String title;
    private GithubUser user;
    @Mandatory
    private String body;
    @Mandatory
    private Date updatedAt;
    private Date closedAt;
    private Date mergedAt;
    @Mandatory
    private Date createdAt;
    private String mergeCommitSha;
    @Mandatory
    private List<GithubUser> assignees;
    @Mandatory
    private List<GithubUser> requestedReviewers;
    private List<GithubIssueLabel> labels;
    private Tag head;
    private Tag base;
    @Mandatory
    private Links _links;
    private String authorAssociation;

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @NotNull
    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    @NotNull
    public String getDiffUrl() {
        return this.diffUrl;
    }

    @NotNull
    public String getPatchUrl() {
        return this.patchUrl;
    }

    public long getNumber() {
        return this.number;
    }

    @NotNull
    public GithubIssueState getState() {
        return this.state;
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    @NotNull
    public String getBody() {
        return this.body;
    }

    @NotNull
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @NotNull
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Nullable
    public Date getClosedAt() {
        return this.closedAt;
    }

    @Nullable
    public Date getMergedAt() {
        return this.mergedAt;
    }

    @NotNull
    public GithubUser getUser() {
        return (GithubUser)ObjectUtils.notNull((Object)this.user, (Object)GithubUser.UNKNOWN);
    }

    @NotNull
    public List<GithubUser> getAssignees() {
        return this.assignees;
    }

    @NotNull
    public List<GithubUser> getRequestedReviewers() {
        return this.requestedReviewers;
    }

    @Nullable
    public List<GithubIssueLabel> getLabels() {
        return this.labels;
    }

    @NotNull
    public Links getLinks() {
        return this._links;
    }

    @NotNull
    public Tag getHead() {
        return this.head;
    }

    @NotNull
    public Tag getBase() {
        return this.base;
    }

    @RestModel
    public static class Links {
        @Mandatory
        private GithubLink self;
        @Mandatory
        private GithubLink html;
        @Mandatory
        private GithubLink issue;
        @Mandatory
        private GithubLink comments;
        @Mandatory
        private GithubLink reviewComments;
        @Mandatory
        private GithubLink reviewComment;
        @Mandatory
        private GithubLink commits;
        @Mandatory
        private GithubLink statuses;
    }

    @RestModel
    public static class Tag {
        @Mandatory
        private String label;
        @Mandatory
        private String ref;
        @Mandatory
        private String sha;
        private GithubRepo repo;
        private GithubUser user;

        @NotNull
        public String getLabel() {
            return this.label;
        }

        @NotNull
        public String getRef() {
            return this.ref;
        }

        @NotNull
        public String getSha() {
            return this.sha;
        }

        @Nullable
        public GithubRepo getRepo() {
            return this.repo;
        }

        @Nullable
        public GithubUser getUser() {
            return this.user;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Tag)) {
                return false;
            }
            Tag tag = (Tag)o;
            return Objects.equals(this.label, tag.label) && Objects.equals(this.ref, tag.ref) && Objects.equals(this.sha, tag.sha) && Objects.equals(this.repo, tag.repo) && Objects.equals(this.user, tag.user);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.ref, this.sha, this.repo, this.user);
        }
    }
}

