/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.mandatory.Mandatory;
import org.jetbrains.io.mandatory.RestModel;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.data.GithubUser;

@RestModel
public class GithubRepoBasic {
    @Mandatory
    private Long id;
    @Mandatory
    private String name;
    private String fullName;
    @Mandatory
    private GithubUser owner;
    @SerializedName(value="private")
    @Mandatory
    private Boolean isPrivate;
    @Mandatory
    private String htmlUrl;
    private String description;
    @SerializedName(value="fork")
    @Mandatory
    private Boolean isFork;
    @Mandatory
    private String url;

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getDescription() {
        return StringUtil.notNullize((String)this.description);
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isFork() {
        return this.isFork;
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @NotNull
    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    @NotNull
    public GithubUser getOwner() {
        return this.owner;
    }

    @NotNull
    public String getUserName() {
        return this.getOwner().getLogin();
    }

    @NotNull
    public String getFullName() {
        return this.getUserName() + "/" + this.getName();
    }

    @NotNull
    public GithubFullPath getFullPath() {
        return new GithubFullPath(this.getUserName(), this.getName());
    }

    public String toString() {
        return "GithubRepo{id=" + this.id + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GithubRepoBasic)) {
            return false;
        }
        GithubRepoBasic basic = (GithubRepoBasic)o;
        return this.id.equals(basic.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

