/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.Mandatory;
import org.jetbrains.io.mandatory.RestModel;

@RestModel
public class GithubUser {
    @NotNull
    public static final GithubUser UNKNOWN = GithubUser.createUnknownUser();
    @Mandatory
    private String login;
    @Mandatory
    private Long id;
    private String avatarUrl;
    private String gravatarId;
    private String url;
    private String htmlUrl;
    private String type;
    private Boolean siteAdmin;

    @NotNull
    public String getLogin() {
        return this.login;
    }

    @Nullable
    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    @Nullable
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    @NotNull
    private static GithubUser createUnknownUser() {
        GithubUser user = new GithubUser();
        user.login = "ghost";
        return user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GithubUser)) {
            return false;
        }
        GithubUser user = (GithubUser)o;
        return this.id.equals(user.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

