/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.dvcs.hosting.RepositoryListLoader;
import com.intellij.dvcs.hosting.RepositoryListLoadingException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import git4idea.remote.GitRepositoryHostingService;
import git4idea.remote.InteractiveGitHttpAuthDataProvider;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubRepoBasic;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubMissingTokenException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.extensions.GithubHttpAuthDataProvider;
import org.jetbrains.plugins.github.extensions.InteractiveGithubHttpAuthDataProvider;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper;
import org.jetbrains.plugins.github.util.GithubGitHelper;

public class GithubRepositoryHostingService
extends GitRepositoryHostingService {
    @NotNull
    private final GithubAuthenticationManager myAuthenticationManager;
    @NotNull
    private final GithubApiRequestExecutorManager myExecutorManager;
    @NotNull
    private final GithubGitHelper myGitHelper;
    @NotNull
    private final GithubHttpAuthDataProvider myAuthDataProvider;

    public GithubRepositoryHostingService(@NotNull GithubAuthenticationManager manager, @NotNull GithubApiRequestExecutorManager executorManager, @NotNull GithubGitHelper gitHelper, @NotNull GithubHttpAuthDataProvider authDataProvider) {
        this.myAuthenticationManager = manager;
        this.myExecutorManager = executorManager;
        this.myGitHelper = gitHelper;
        this.myAuthDataProvider = authDataProvider;
    }

    @NotNull
    public String getServiceDisplayName() {
        return "GitHub";
    }

    @NotNull
    public RepositoryListLoader getRepositoryListLoader(final @NotNull Project project) {
        return new RepositoryListLoader(){
            @NotNull
            private final Map<GithubAccount, GithubApiRequestExecutor> myExecutors = new HashMap<GithubAccount, GithubApiRequestExecutor>();

            public boolean isEnabled() {
                for (GithubAccount account : GithubRepositoryHostingService.this.myAuthenticationManager.getAccounts()) {
                    try {
                        this.myExecutors.put(account, GithubRepositoryHostingService.this.myExecutorManager.getExecutor(account));
                    }
                    catch (GithubMissingTokenException githubMissingTokenException) {}
                }
                return !this.myExecutors.isEmpty();
            }

            public boolean enable(@Nullable Component parentComponent) {
                if (!GithubAccountsMigrationHelper.getInstance().migrate(project, parentComponent)) {
                    return false;
                }
                if (!GithubRepositoryHostingService.this.myAuthenticationManager.ensureHasAccounts(project, parentComponent)) {
                    return false;
                }
                boolean atLeastOneHasToken = false;
                for (GithubAccount account : GithubRepositoryHostingService.this.myAuthenticationManager.getAccounts()) {
                    GithubApiRequestExecutor.WithTokenAuth executor = GithubRepositoryHostingService.this.myExecutorManager.getExecutor(account, project);
                    if (executor == null) continue;
                    this.myExecutors.put(account, executor);
                    atLeastOneHasToken = true;
                }
                return atLeastOneHasToken;
            }

            @NotNull
            public RepositoryListLoader.Result getAvailableRepositoriesFromMultipleSources(@NotNull ProgressIndicator progressIndicator) {
                ArrayList urls = new ArrayList();
                ArrayList<RepositoryListLoadingException> exceptions = new ArrayList<RepositoryListLoadingException>();
                for (Map.Entry<GithubAccount, GithubApiRequestExecutor> entry : this.myExecutors.entrySet()) {
                    GithubServerPath server = entry.getKey().getServer();
                    GithubApiRequestExecutor executor = entry.getValue();
                    try {
                        Stream streamAssociated = GithubApiPagesLoader.loadAll(executor, progressIndicator, GithubApiRequests.CurrentUser.Repos.pages(server)).stream();
                        Object streamWatched = StreamEx.empty();
                        try {
                            streamWatched = GithubApiPagesLoader.loadAll(executor, progressIndicator, GithubApiRequests.CurrentUser.RepoSubs.pages(server)).stream();
                        }
                        catch (GithubAuthenticationException | GithubStatusCodeException iOException) {
                            // empty catch block
                        }
                        urls.addAll(Stream.concat(streamAssociated, streamWatched).sorted(Comparator.comparing(GithubRepoBasic::getUserName).thenComparing(GithubRepoBasic::getName)).map(repo -> GithubRepositoryHostingService.this.myGitHelper.getRemoteUrl(server, repo.getUserName(), repo.getName())).collect(Collectors.toList()));
                    }
                    catch (Exception e) {
                        exceptions.add(new RepositoryListLoadingException("Cannot load repositories from GitHub", (Throwable)e));
                    }
                }
                return new RepositoryListLoader.Result(urls, exceptions);
            }
        };
    }

    @Nullable
    public InteractiveGitHttpAuthDataProvider getInteractiveAuthDataProvider(@NotNull Project project, @NotNull String url) {
        return this.getProvider(project, url, null);
    }

    @Nullable
    public InteractiveGitHttpAuthDataProvider getInteractiveAuthDataProvider(@NotNull Project project, @NotNull String url, @NotNull String login2) {
        return this.getProvider(project, url, login2);
    }

    @Nullable
    private InteractiveGitHttpAuthDataProvider getProvider(@NotNull Project project, @NotNull String url, @Nullable String login2) {
        Set<GithubAccount> potentialAccounts = this.myAuthDataProvider.getSuitableAccounts(project, url, login2);
        if (potentialAccounts.isEmpty()) {
            return null;
        }
        return new InteractiveGithubHttpAuthDataProvider(project, potentialAccounts, this.myAuthenticationManager);
    }
}

