/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.OnePixelSplitter;
import git4idea.commands.Git;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.api.data.GithubSearchedIssue;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.pullrequest.action.GithubPullRequestKeys;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.config.GithubPullRequestsProjectUISettings;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsBusyStateTrackerImpl;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsDataLoader;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsLoader;
import org.jetbrains.plugins.github.pullrequest.data.service.GithubPullRequestsMetadataServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GithubPullRequestsSecurityServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GithubPullRequestsStateServiceImpl;
import org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestChangesComponent;
import org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestDetailsComponent;
import org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestPreviewComponent;
import org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestsListComponent;
import org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestsListSelectionModel;
import org.jetbrains.plugins.github.util.CachingGithubUserAvatarLoader;
import org.jetbrains.plugins.github.util.GithubImageResizer;
import org.jetbrains.plugins.github.util.GithubSharedProjectSettings;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001%BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J8\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GithubPullRequestsComponentFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "copyPasteManager", "Lcom/intellij/openapi/ide/CopyPasteManager;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "git", "Lgit4idea/commands/Git;", "avatarLoader", "Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;", "imageResizer", "Lorg/jetbrains/plugins/github/util/GithubImageResizer;", "actionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "autoPopupController", "Lcom/intellij/codeInsight/AutoPopupController;", "sharedProjectSettings", "Lorg/jetbrains/plugins/github/util/GithubSharedProjectSettings;", "pullRequestUiSettings", "Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/ide/CopyPasteManager;Lcom/intellij/openapi/progress/ProgressManager;Lgit4idea/commands/Git;Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;Lorg/jetbrains/plugins/github/util/GithubImageResizer;Lcom/intellij/openapi/actionSystem/ActionManager;Lcom/intellij/codeInsight/AutoPopupController;Lorg/jetbrains/plugins/github/util/GithubSharedProjectSettings;Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;)V", "createComponent", "Ljavax/swing/JComponent;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "accountDetails", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "repoDetails", "Lorg/jetbrains/plugins/github/api/data/GithubRepoDetailed;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "GithubPullRequestsComponent", "intellij.vcs.github"})
public final class GithubPullRequestsComponentFactory {
    private final Project project;
    private final CopyPasteManager copyPasteManager;
    private final ProgressManager progressManager;
    private final Git git;
    private final CachingGithubUserAvatarLoader avatarLoader;
    private final GithubImageResizer imageResizer;
    private final ActionManager actionManager;
    private final AutoPopupController autoPopupController;
    private final GithubSharedProjectSettings sharedProjectSettings;
    private final GithubPullRequestsProjectUISettings pullRequestUiSettings;

    @Nullable
    public final JComponent createComponent(@NotNull GithubApiRequestExecutor requestExecutor, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull GithubAuthenticatedUser accountDetails, @NotNull GithubRepoDetailed repoDetails, @NotNull GithubAccount account) {
        CachingGithubAvatarIconsProvider.Factory avatarIconsProviderFactory = new CachingGithubAvatarIconsProvider.Factory(this.avatarLoader, this.imageResizer, requestExecutor);
        return (JComponent)((Object)new GithubPullRequestsComponent(requestExecutor, avatarIconsProviderFactory, this.pullRequestUiSettings, repository, remote, accountDetails, repoDetails, account));
    }

    public GithubPullRequestsComponentFactory(@NotNull Project project, @NotNull CopyPasteManager copyPasteManager, @NotNull ProgressManager progressManager, @NotNull Git git, @NotNull CachingGithubUserAvatarLoader avatarLoader, @NotNull GithubImageResizer imageResizer, @NotNull ActionManager actionManager, @NotNull AutoPopupController autoPopupController, @NotNull GithubSharedProjectSettings sharedProjectSettings, @NotNull GithubPullRequestsProjectUISettings pullRequestUiSettings) {
        this.project = project;
        this.copyPasteManager = copyPasteManager;
        this.progressManager = progressManager;
        this.git = git;
        this.avatarLoader = avatarLoader;
        this.imageResizer = imageResizer;
        this.actionManager = actionManager;
        this.autoPopupController = autoPopupController;
        this.sharedProjectSettings = sharedProjectSettings;
        this.pullRequestUiSettings = pullRequestUiSettings;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BE\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010)\u001a\u00020*H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.H\u0016J\u0006\u0010/\u001a\u00020*J\u000e\u00100\u001a\u00020*2\u0006\u00101\u001a\u000202R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GithubPullRequestsComponentFactory$GithubPullRequestsComponent;", "Lcom/intellij/ui/OnePixelSplitter;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "avatarIconsProviderFactory", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;", "pullRequestUiSettings", "Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "accountDetails", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "repoDetails", "Lorg/jetbrains/plugins/github/api/data/GithubRepoDetailed;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "(Lorg/jetbrains/plugins/github/pullrequest/GithubPullRequestsComponentFactory;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;Lorg/jetbrains/plugins/github/api/data/GithubRepoDetailed;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;)V", "busyStateTracker", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsBusyStateTrackerImpl;", "changes", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestChangesComponent;", "dataLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsDataLoader;", "details", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestDetailsComponent;", "list", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsListComponent;", "listLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsLoader;", "metadataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsMetadataServiceImpl;", "preview", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestPreviewComponent;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsSecurityServiceImpl;", "stateService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsStateServiceImpl;", "dispose", "", "getData", "", "dataId", "", "refreshAllPullRequests", "refreshPullRequest", "number", "", "intellij.vcs.github"})
    public final class GithubPullRequestsComponent
    extends OnePixelSplitter
    implements Disposable,
    DataProvider {
        private final GithubPullRequestsDataLoader dataLoader;
        private final GithubPullRequestsSecurityServiceImpl securityService;
        private final GithubPullRequestsBusyStateTrackerImpl busyStateTracker;
        private final GithubPullRequestsMetadataServiceImpl metadataService;
        private final GithubPullRequestsStateServiceImpl stateService;
        private final GithubPullRequestChangesComponent changes;
        private final GithubPullRequestDetailsComponent details;
        private final GithubPullRequestPreviewComponent preview;
        private final GithubPullRequestsLoader listLoader;
        private final GithubPullRequestsListComponent list;
        private final GithubApiRequestExecutor requestExecutor;
        private final GitRepository repository;
        private final GitRemote remote;
        private final GithubRepoDetailed repoDetails;
        private final GithubAccount account;

        public final void refreshAllPullRequests() {
            this.list.refresh();
            this.dataLoader.invalidateAllData();
        }

        public final void refreshPullRequest(long number) {
            this.dataLoader.invalidateData(number);
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            Object object;
            if (Disposer.isDisposed((Disposable)this)) {
                return null;
            }
            if (GithubPullRequestKeys.getREPOSITORY().is(dataId)) {
                object = this.repository;
            } else if (GithubPullRequestKeys.getREMOTE().is(dataId)) {
                object = this.remote;
            } else if (GithubPullRequestKeys.getREPO_DETAILS().is(dataId)) {
                object = this.repoDetails;
            } else if (GithubPullRequestKeys.getSERVER_PATH().is(dataId)) {
                object = this.account.getServer();
            } else if (GithubPullRequestKeys.getAPI_REQUEST_EXECUTOR().is(dataId)) {
                object = this.requestExecutor;
            } else if (GithubPullRequestKeys.getPULL_REQUESTS_COMPONENT$intellij_vcs_github().is(dataId)) {
                object = this;
            } else if (GithubPullRequestKeys.getSELECTED_PULL_REQUEST().is(dataId)) {
                object = this.list.getSelectionModel().getCurrent();
            } else if (GithubPullRequestKeys.getSELECTED_PULL_REQUEST_DATA_PROVIDER().is(dataId)) {
                GithubSearchedIssue githubSearchedIssue = this.list.getSelectionModel().getCurrent();
                if (githubSearchedIssue != null) {
                    long l = githubSearchedIssue.getNumber();
                    GithubPullRequestsDataLoader githubPullRequestsDataLoader = this.dataLoader;
                    long p1 = l;
                    boolean bl = false;
                    object = githubPullRequestsDataLoader.getDataProvider(p1);
                } else {
                    object = null;
                }
            } else {
                object = null;
            }
            return object;
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.list);
            Disposer.dispose((Disposable)this.preview);
            Disposer.dispose((Disposable)this.changes);
            Disposer.dispose((Disposable)this.details);
            Disposer.dispose((Disposable)this.listLoader);
            Disposer.dispose((Disposable)this.dataLoader);
        }

        public GithubPullRequestsComponent(@NotNull GithubApiRequestExecutor requestExecutor, @NotNull CachingGithubAvatarIconsProvider.Factory avatarIconsProviderFactory, @NotNull GithubPullRequestsProjectUISettings pullRequestUiSettings, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull GithubAuthenticatedUser accountDetails, @NotNull GithubRepoDetailed repoDetails, GithubAccount account) {
            GithubPullRequestChangesComponent githubPullRequestChangesComponent;
            super("Github.PullRequests.Component", 0.33f);
            this.requestExecutor = requestExecutor;
            this.repository = repository;
            this.remote = remote;
            this.repoDetails = repoDetails;
            this.account = account;
            this.dataLoader = new GithubPullRequestsDataLoader(GithubPullRequestsComponentFactory.this.project, GithubPullRequestsComponentFactory.this.progressManager, GithubPullRequestsComponentFactory.this.git, this.requestExecutor, this.repository, this.remote, this.account.getServer(), this.repoDetails.getFullPath());
            this.securityService = new GithubPullRequestsSecurityServiceImpl(GithubPullRequestsComponentFactory.this.sharedProjectSettings, accountDetails, this.repoDetails);
            this.busyStateTracker = new GithubPullRequestsBusyStateTrackerImpl();
            this.metadataService = new GithubPullRequestsMetadataServiceImpl(GithubPullRequestsComponentFactory.this.project, GithubPullRequestsComponentFactory.this.progressManager, this.dataLoader, this.busyStateTracker, this.requestExecutor, avatarIconsProviderFactory, this.account.getServer(), this.repoDetails.getFullPath());
            this.stateService = new GithubPullRequestsStateServiceImpl(GithubPullRequestsComponentFactory.this.project, GithubPullRequestsComponentFactory.this.progressManager, this.dataLoader, this.busyStateTracker, this.requestExecutor, this.account.getServer(), this.repoDetails.getFullPath());
            Disposable disposable = new GithubPullRequestChangesComponent(GithubPullRequestsComponentFactory.this.project, pullRequestUiSettings);
            GithubPullRequestsComponent githubPullRequestsComponent = this;
            GithubPullRequestChangesComponent $receiver = disposable;
            boolean bl = false;
            $receiver.getDiffAction().registerCustomShortcutSet((JComponent)((Object)this), (Disposable)this);
            githubPullRequestsComponent.changes = githubPullRequestChangesComponent = disposable;
            this.details = new GithubPullRequestDetailsComponent(this.dataLoader, this.securityService, this.busyStateTracker, this.metadataService, this.stateService, avatarIconsProviderFactory);
            this.preview = new GithubPullRequestPreviewComponent(this.changes, this.details);
            this.listLoader = new GithubPullRequestsLoader(GithubPullRequestsComponentFactory.this.progressManager, this.requestExecutor, this.account.getServer(), this.repoDetails.getFullPath());
            disposable = new GithubPullRequestsListComponent(GithubPullRequestsComponentFactory.this.project, GithubPullRequestsComponentFactory.this.copyPasteManager, GithubPullRequestsComponentFactory.this.actionManager, GithubPullRequestsComponentFactory.this.autoPopupController, this.listLoader, avatarIconsProviderFactory);
            githubPullRequestsComponent = this;
            $receiver = disposable;
            boolean bl2 = false;
            this.requestExecutor.addListener($receiver, (Function0<Unit>)((Function0)new Function0<Unit>((GithubPullRequestsListComponent)((Object)$receiver)){
                final /* synthetic */ GithubPullRequestsListComponent $this_apply;

                public final void invoke() {
                    this.$this_apply.refresh();
                }
                {
                    this.$this_apply = githubPullRequestsListComponent;
                    super(0);
                }
            }));
            githubPullRequestChangesComponent = disposable;
            githubPullRequestsComponent.list = githubPullRequestChangesComponent;
            this.setFirstComponent((JComponent)((Object)this.list));
            this.setSecondComponent((JComponent)((Object)this.preview));
            this.setFocusCycleRoot(true);
            this.list.getSelectionModel().addChangesListener(new GithubPullRequestsListSelectionModel.SelectionChangedListener(){

                @Override
                public void selectionChanged() {
                    GithubPullRequestDataProvider githubPullRequestDataProvider;
                    GithubSearchedIssue githubSearchedIssue = list.getSelectionModel().getCurrent();
                    if (githubSearchedIssue != null) {
                        long l = githubSearchedIssue.getNumber();
                        GithubPullRequestsDataLoader githubPullRequestsDataLoader = dataLoader;
                        long p1 = l;
                        boolean bl = false;
                        githubPullRequestDataProvider = githubPullRequestsDataLoader.getDataProvider(p1);
                    } else {
                        githubPullRequestDataProvider = null;
                    }
                    GithubPullRequestDataProvider dataProvider = githubPullRequestDataProvider;
                    preview.setPreviewDataProvider(dataProvider);
                }
            }, this.preview);
            this.dataLoader.addProviderChangesListener(new GithubPullRequestsDataLoader.ProviderChangedListener(){

                @Override
                public void providerChanged(long pullRequestNumber) {
                    ModalityState modalityState$iv = null;
                    boolean $i$f$runInEdt = false;
                    Application app$iv = ApplicationManager.getApplication();
                    if (app$iv.isDispatchThread()) {
                        GithubSearchedIssue selection;
                        boolean bl = false;
                        if (!Disposer.isDisposed((Disposable)preview) && (selection = list.getSelectionModel().getCurrent()) != null && selection.getNumber() == pullRequestNumber) {
                            preview.setPreviewDataProvider(dataLoader.getDataProvider(pullRequestNumber));
                        }
                    } else {
                        app$iv.invokeLater(new Runnable(this, pullRequestNumber){
                            final /* synthetic */ 2 this$0;
                            final /* synthetic */ long $pullRequestNumber$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$pullRequestNumber$inlined = l;
                            }

                            public final void run() {
                                GithubSearchedIssue selection;
                                boolean bl = false;
                                if (!Disposer.isDisposed((Disposable)GithubPullRequestsComponent.access$getPreview$p(this.this$0.this)) && (selection = GithubPullRequestsComponent.access$getList$p(this.this$0.this).getSelectionModel().getCurrent()) != null && selection.getNumber() == this.$pullRequestNumber$inlined) {
                                    GithubPullRequestsComponent.access$getPreview$p(this.this$0.this).setPreviewDataProvider(GithubPullRequestsComponent.access$getDataLoader$p(this.this$0.this).getDataProvider(this.$pullRequestNumber$inlined));
                                }
                            }
                        }, ModalityState.defaultModalityState());
                    }
                }
            }, this.preview);
        }
    }
}

