/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import icons.GithubIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.authentication.accounts.AccountTokenChangedListener;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.pullrequest.GithubPullRequestsComponentFactory;
import org.jetbrains.plugins.github.pullrequest.GithubPullRequestsToolWindowManager;
import org.jetbrains.plugins.github.pullrequest.GithubPullRequestsToolWindowManagerKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J>\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aJ$\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020(0'H\u0002J\u0018\u0010)\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010*\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010+\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00140-H\u0002J\u0018\u0010.\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010/\u001a\u00020\u001aH\u0002J&\u00100\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u00101\u001a\u00020\u001cH\u0002J.\u00102\u001a\u0004\u0018\u00010\u000e*\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GithubPullRequestsToolWindowManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "gitRepositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;", "componentFactory", "Lorg/jetbrains/plugins/github/pullrequest/GithubPullRequestsComponentFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindowManager;Lgit4idea/repo/GitRepositoryManager;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;Lorg/jetbrains/plugins/github/pullrequest/GithubPullRequestsComponentFactory;)V", "createContent", "Lcom/intellij/ui/content/Content;", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "component", "Ljavax/swing/JComponent;", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "remoteUrl", "", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "createPullRequestsTab", "", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "accountDetails", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "repoDetails", "Lorg/jetbrains/plugins/github/api/data/GithubRepoDetailed;", "findAndRemoveContents", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "predicate", "Lkotlin/Function1;", "", "removeContentsForRemovedRemoteUrls", "removeContentsForRemovedRemotes", "removeContentsForRemovedRepositories", "repositories", "", "removeContentsUsingRemovedAccount", "removedAccount", "showPullRequestsTabIfExists", "unregisterToolWindow", "findContent", "intellij.vcs.github"})
public final class GithubPullRequestsToolWindowManager {
    private final Project project;
    private final ToolWindowManager toolWindowManager;
    private final GitRepositoryManager gitRepositoryManager;
    private final GithubAccountManager accountManager;
    private final GithubPullRequestsComponentFactory componentFactory;

    public final void createPullRequestsTab(@NotNull GithubApiRequestExecutor requestExecutor, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String remoteUrl, @NotNull GithubAuthenticatedUser accountDetails, @NotNull GithubRepoDetailed repoDetails, @NotNull GithubAccount account) {
        ToolWindow toolWindow = this.toolWindowManager.getToolWindow("GitHub Pull Requests");
        ContentManager contentManager = null;
        if (toolWindow == null) {
            ToolWindow toolWindow2;
            JComponent jComponent = this.componentFactory.createComponent(requestExecutor, repository, remote, accountDetails, repoDetails, account);
            if (jComponent == null) {
                return;
            }
            JComponent component = jComponent;
            ToolWindow $receiver = toolWindow2 = this.toolWindowManager.registerToolWindow("GitHub Pull Requests", true, ToolWindowAnchor.BOTTOM, (Disposable)this.project, true);
            boolean bl = false;
            $receiver.setIcon(GithubIcons.PullRequestsToolWindow);
            $receiver.setHelpId("reference.GitHub.PullRequests");
            toolWindow = toolWindow2;
            contentManager = toolWindow.getContentManager();
            contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(this, contentManager){
                final /* synthetic */ GithubPullRequestsToolWindowManager this$0;
                final /* synthetic */ ContentManager $contentManager;

                public void contentRemoved(@NotNull ContentManagerEvent event) {
                    if (this.$contentManager.getContentCount() == 0) {
                        GithubPullRequestsToolWindowManager.access$unregisterToolWindow(this.this$0);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$contentManager = $captured_local_variable$1;
                }
            });
            Content content = this.createContent(contentManager, component, repository, remote, remoteUrl, account);
            contentManager.addContent(content);
        } else {
            contentManager = toolWindow.getContentManager();
            Content existingContent = this.findContent(contentManager, repository, remote, remoteUrl, account);
            if (existingContent == null) {
                JComponent jComponent = this.componentFactory.createComponent(requestExecutor, repository, remote, accountDetails, repoDetails, account);
                if (jComponent == null) {
                    return;
                }
                JComponent component = jComponent;
                Content content = this.createContent(contentManager, component, repository, remote, remoteUrl, account);
                contentManager.addContent(content);
            }
        }
    }

    public final boolean showPullRequestsTabIfExists(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String remoteUrl, @NotNull GithubAccount account) {
        ToolWindow toolWindow = this.toolWindowManager.getToolWindow("GitHub Pull Requests");
        if (toolWindow == null) {
            return false;
        }
        ToolWindow toolWindow2 = toolWindow;
        Content content = this.findContent(toolWindow2.getContentManager(), repository, remote, remoteUrl, account);
        if (content == null) {
            return false;
        }
        Content content2 = content;
        toolWindow2.getContentManager().setSelectedContent(content2, true);
        toolWindow2.show((Runnable)showPullRequestsTabIfExists.1.INSTANCE);
        return true;
    }

    private final Content createContent(ContentManager contentManager, JComponent component, GitRepository repository, GitRemote remote, String remoteUrl, GithubAccount account) {
        Content content;
        Content $receiver = content = contentManager.getFactory().createContent(component, null, false);
        boolean bl = false;
        $receiver.setPreferredFocusedComponent((Computable)new Computable<JComponent>(component, remote, repository, remoteUrl, account){
            final /* synthetic */ JComponent $component$inlined;
            final /* synthetic */ GitRemote $remote$inlined;
            final /* synthetic */ GitRepository $repository$inlined;
            final /* synthetic */ String $remoteUrl$inlined;
            final /* synthetic */ GithubAccount $account$inlined;
            {
                this.$component$inlined = jComponent;
                this.$remote$inlined = gitRemote;
                this.$repository$inlined = gitRepository;
                this.$remoteUrl$inlined = string;
                this.$account$inlined = githubAccount;
            }

            @NotNull
            public final JComponent compute() {
                return this.$component$inlined;
            }
        });
        $receiver.setCloseable(true);
        $receiver.setDisplayName(remote.getName());
        $receiver.putUserData(GithubPullRequestsToolWindowManagerKt.access$getREPOSITORY_KEY$p(), (Object)repository);
        $receiver.putUserData(GithubPullRequestsToolWindowManagerKt.access$getREMOTE_KEY$p(), (Object)remote);
        $receiver.putUserData(GithubPullRequestsToolWindowManagerKt.access$getREMOTE_URL_KEY$p(), (Object)remoteUrl);
        $receiver.putUserData(GithubPullRequestsToolWindowManagerKt.access$getACCOUNT_KEY$p(), (Object)account);
        return content;
    }

    private final void unregisterToolWindow() {
        this.toolWindowManager.unregisterToolWindow("GitHub Pull Requests");
    }

    private final void removeContentsForRemovedRepositories(ToolWindow toolWindow, List<? extends GitRepository> repositories) {
        this.findAndRemoveContents(toolWindow, (Function1<? super Content, Boolean>)((Function1)new Function1<Content, Boolean>(repositories){
            final /* synthetic */ List $repositories;

            public final boolean invoke(@NotNull Content it) {
                return !CollectionsKt.contains((Iterable)this.$repositories, (Object)it.getUserData(GithubPullRequestsToolWindowManagerKt.access$getREPOSITORY_KEY$p()));
            }
            {
                this.$repositories = list2;
                super(1);
            }
        }));
    }

    private final void removeContentsForRemovedRemotes(ToolWindow toolWindow, GitRepository repository) {
        this.findAndRemoveContents(toolWindow, (Function1<? super Content, Boolean>)((Function1)new Function1<Content, Boolean>(repository){
            final /* synthetic */ GitRepository $repository;

            public final boolean invoke(@NotNull Content it) {
                return Intrinsics.areEqual((Object)((GitRepository)it.getUserData(GithubPullRequestsToolWindowManagerKt.access$getREPOSITORY_KEY$p())), (Object)this.$repository) && !this.$repository.getRemotes().contains(it.getUserData(GithubPullRequestsToolWindowManagerKt.access$getREMOTE_KEY$p()));
            }
            {
                this.$repository = gitRepository;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void removeContentsForRemovedRemoteUrls(ToolWindow toolWindow, GitRepository repository) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)repository.getRemotes();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            GitRemote gitRemote = (GitRemote)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List list2 = it.getUrls();
            collection.add(list2);
        }
        Set urls = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
        this.findAndRemoveContents(toolWindow, (Function1<? super Content, Boolean>)((Function1)new Function1<Content, Boolean>(repository, urls){
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ Set $urls;

            public final boolean invoke(@NotNull Content it) {
                return Intrinsics.areEqual((Object)((GitRepository)it.getUserData(GithubPullRequestsToolWindowManagerKt.access$getREPOSITORY_KEY$p())), (Object)this.$repository) && !this.$urls.contains(it.getUserData(GithubPullRequestsToolWindowManagerKt.access$getREMOTE_URL_KEY$p()));
            }
            {
                this.$repository = gitRepository;
                this.$urls = set;
                super(1);
            }
        }));
    }

    private final void findAndRemoveContents(ToolWindow toolWindow, Function1<? super Content, Boolean> predicate) {
        ContentManager contentManager = toolWindow.getContentManager();
        for (Content content : contentManager.getContents()) {
            if (!((Boolean)predicate.invoke((Object)content)).booleanValue()) continue;
            contentManager.removeContent(content, true);
        }
    }

    private final void removeContentsUsingRemovedAccount(ToolWindow toolWindow, GithubAccount removedAccount) {
        ContentManager contentManager = toolWindow.getContentManager();
        for (Content content : contentManager.getContents()) {
            GithubAccount account = (GithubAccount)content.getUserData(GithubPullRequestsToolWindowManagerKt.access$getACCOUNT_KEY$p());
            if (!Intrinsics.areEqual((Object)account, (Object)removedAccount)) continue;
            contentManager.removeContent(content, true);
        }
    }

    private final Content findContent(@NotNull ContentManager $receiver, GitRepository repository, GitRemote remote, String remoteUrl, GithubAccount account) {
        Content content;
        block1: {
            Content[] contentArray;
            Content[] contentArray2;
            Content[] contentArray3 = contentArray2 = (contentArray = $receiver.getContents());
            int n = contentArray3.length;
            for (int i = 0; i < n; ++i) {
                Content content2;
                Content it = content2 = contentArray3[i];
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)((String)it.getUserData(GithubPullRequestsToolWindowManagerKt.access$getREMOTE_URL_KEY$p())), (Object)remoteUrl) && Intrinsics.areEqual((Object)((GitRemote)it.getUserData(GithubPullRequestsToolWindowManagerKt.access$getREMOTE_KEY$p())), (Object)remote) && Intrinsics.areEqual((Object)((GitRepository)it.getUserData(GithubPullRequestsToolWindowManagerKt.access$getREPOSITORY_KEY$p())), (Object)repository) && Intrinsics.areEqual((Object)((GithubAccount)it.getUserData(GithubPullRequestsToolWindowManagerKt.access$getACCOUNT_KEY$p())), (Object)account))) continue;
                content = content2;
                break block1;
            }
            content = null;
        }
        return content;
    }

    public GithubPullRequestsToolWindowManager(@NotNull Project project, @NotNull ToolWindowManager toolWindowManager, @NotNull GitRepositoryManager gitRepositoryManager, @NotNull GithubAccountManager accountManager, @NotNull GithubPullRequestsComponentFactory componentFactory) {
        this.project = project;
        this.toolWindowManager = toolWindowManager;
        this.gitRepositoryManager = gitRepositoryManager;
        this.accountManager = accountManager;
        this.componentFactory = componentFactory;
        MessageBusConnection busConnection = this.project.getMessageBus().connect();
        busConnection.subscribe(VcsRepositoryManager.VCS_REPOSITORY_MAPPING_UPDATED, (Object)new VcsRepositoryMappingListener(){

            public final void mappingChanged() {
                ModalityState modalityState$iv = null;
                boolean $i$f$runInEdt = false;
                Application app$iv = ApplicationManager.getApplication();
                if (app$iv.isDispatchThread()) {
                    boolean bl = false;
                    ToolWindow toolWindow = toolWindowManager.getToolWindow("GitHub Pull Requests");
                    if (toolWindow == null) {
                    } else {
                        ToolWindow toolWindow2 = toolWindow;
                        List repositories = gitRepositoryManager.getRepositories();
                        if (repositories.isEmpty()) {
                            this.unregisterToolWindow();
                        } else {
                            this.removeContentsForRemovedRepositories(toolWindow2, repositories);
                        }
                    }
                } else {
                    app$iv.invokeLater(new Runnable(this){
                        final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            boolean bl = false;
                            ToolWindow toolWindow = GithubPullRequestsToolWindowManager.access$getToolWindowManager$p(this.this$0.this).getToolWindow("GitHub Pull Requests");
                            if (toolWindow == null) {
                            } else {
                                ToolWindow toolWindow2 = toolWindow;
                                List repositories = GithubPullRequestsToolWindowManager.access$getGitRepositoryManager$p(this.this$0.this).getRepositories();
                                if (repositories.isEmpty()) {
                                    GithubPullRequestsToolWindowManager.access$unregisterToolWindow(this.this$0.this);
                                } else {
                                    GithubPullRequestsToolWindowManager.access$removeContentsForRemovedRepositories(this.this$0.this, toolWindow2, repositories);
                                }
                            }
                        }
                    }, ModalityState.defaultModalityState());
                }
            }
        });
        busConnection.subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(){

            public final void repositoryChanged(@NotNull GitRepository repository) {
                ModalityState modalityState$iv = null;
                boolean $i$f$runInEdt = false;
                Application app$iv = ApplicationManager.getApplication();
                if (app$iv.isDispatchThread()) {
                    boolean bl = false;
                    ToolWindow toolWindow = toolWindowManager.getToolWindow("GitHub Pull Requests");
                    if (toolWindow == null) {
                    } else {
                        ToolWindow toolWindow2 = toolWindow;
                        this.removeContentsForRemovedRemotes(toolWindow2, repository);
                        this.removeContentsForRemovedRemoteUrls(toolWindow2, repository);
                    }
                } else {
                    app$iv.invokeLater(new Runnable(this, repository){
                        final /* synthetic */ 2 this$0;
                        final /* synthetic */ GitRepository $repository$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$repository$inlined = gitRepository;
                        }

                        public final void run() {
                            boolean bl = false;
                            ToolWindow toolWindow = GithubPullRequestsToolWindowManager.access$getToolWindowManager$p(this.this$0.this).getToolWindow("GitHub Pull Requests");
                            if (toolWindow == null) {
                            } else {
                                ToolWindow toolWindow2 = toolWindow;
                                GithubPullRequestsToolWindowManager.access$removeContentsForRemovedRemotes(this.this$0.this, toolWindow2, this.$repository$inlined);
                                GithubPullRequestsToolWindowManager.access$removeContentsForRemovedRemoteUrls(this.this$0.this, toolWindow2, this.$repository$inlined);
                            }
                        }
                    }, ModalityState.defaultModalityState());
                }
            }
        });
        busConnection.subscribe(GithubAccountManager.Companion.getACCOUNT_TOKEN_CHANGED_TOPIC(), (Object)new AccountTokenChangedListener(){

            @Override
            public void tokenChanged(@NotNull GithubAccount account) {
                ModalityState modalityState$iv = null;
                boolean $i$f$runInEdt = false;
                Application app$iv = ApplicationManager.getApplication();
                if (app$iv.isDispatchThread()) {
                    boolean bl = false;
                    ToolWindow toolWindow = toolWindowManager.getToolWindow("GitHub Pull Requests");
                    if (toolWindow == null) {
                    } else {
                        ToolWindow toolWindow2 = toolWindow;
                        if (accountManager.getTokenForAccount(account) == null) {
                            this.removeContentsUsingRemovedAccount(toolWindow2, account);
                        }
                    }
                } else {
                    app$iv.invokeLater(new Runnable(this, account){
                        final /* synthetic */ 3 this$0;
                        final /* synthetic */ GithubAccount $account$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$account$inlined = githubAccount;
                        }

                        public final void run() {
                            boolean bl = false;
                            ToolWindow toolWindow = GithubPullRequestsToolWindowManager.access$getToolWindowManager$p(this.this$0.this).getToolWindow("GitHub Pull Requests");
                            if (toolWindow == null) {
                            } else {
                                ToolWindow toolWindow2 = toolWindow;
                                if (GithubPullRequestsToolWindowManager.access$getAccountManager$p(this.this$0.this).getTokenForAccount(this.$account$inlined) == null) {
                                    GithubPullRequestsToolWindowManager.access$removeContentsUsingRemovedAccount(this.this$0.this, toolWindow2, this.$account$inlined);
                                }
                            }
                        }
                    }, ModalityState.defaultModalityState());
                }
            }
        });
    }
}

