/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.action.edit;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.GithubPermissions;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.api.data.GithubRepoWithPermissions;
import org.jetbrains.plugins.github.api.data.GithubSearchedIssue;
import org.jetbrains.plugins.github.pullrequest.action.GithubPullRequestKeys;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestDataProvider;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fR\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/action/edit/GithubPullRequestStateChangeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "text", "", "(Ljava/lang/String;)V", "requiredState", "Lorg/jetbrains/plugins/github/api/data/GithubIssueState;", "getRequiredState", "()Lorg/jetbrains/plugins/github/api/data/GithubIssueState;", "isEnabledAndVisible", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "", "intellij.vcs.github"})
public abstract class GithubPullRequestStateChangeAction
extends DumbAwareAction {
    public final void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(this.isEnabledAndVisible(e));
    }

    private final boolean isEnabledAndVisible(AnActionEvent e) {
        if (e.getProject() == null) {
            return false;
        }
        if ((GithubApiRequestExecutor)e.getData(GithubPullRequestKeys.getAPI_REQUEST_EXECUTOR()) == null) {
            return false;
        }
        if ((GithubPullRequestDataProvider)e.getData(GithubPullRequestKeys.getSELECTED_PULL_REQUEST_DATA_PROVIDER()) == null) {
            return false;
        }
        GithubSearchedIssue githubSearchedIssue = (GithubSearchedIssue)e.getData(GithubPullRequestKeys.getSELECTED_PULL_REQUEST());
        if (githubSearchedIssue == null) {
            return false;
        }
        GithubSearchedIssue pullRequest = githubSearchedIssue;
        if (this.getRequiredState() != pullRequest.getState()) {
            return false;
        }
        Object object = (GithubRepoDetailed)e.getData(GithubPullRequestKeys.getREPO_DETAILS());
        if (object == null || (object = ((GithubRepoWithPermissions)object).getPermissions()) == null) {
            return false;
        }
        Object permissions = object;
        if (((GithubPermissions)permissions).isPush() || ((GithubPermissions)permissions).isAdmin()) {
            return true;
        }
        GithubAuthenticatedUser githubAuthenticatedUser = (GithubAuthenticatedUser)e.getData(GithubPullRequestKeys.getACCOUNT_DETAILS());
        if (githubAuthenticatedUser == null) {
            return false;
        }
        GithubAuthenticatedUser currentUser = githubAuthenticatedUser;
        return Intrinsics.areEqual((Object)pullRequest.getUser(), (Object)currentUser);
    }

    @NotNull
    public abstract GithubIssueState getRequiredState();

    public GithubPullRequestStateChangeAction(@NotNull String text) {
        super(text);
    }
}

