/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui;

import com.intellij.ui.components.panels.Wrapper;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.util.GithubAsyncUtil;
import org.jetbrains.plugins.github.util.GithubAsyncUtilKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH$J\u0015\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\u00062\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005J\u0014\u0010\u0010\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005J\b\u0010\u0011\u001a\u00020\u0006H$J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H$R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubDataLoadingComponent;", "T", "Lcom/intellij/ui/components/panels/Wrapper;", "()V", "updateFuture", "Ljava/util/concurrent/CompletableFuture;", "", "doLoadAndShow", "dataRequest", "handleError", "error", "", "handleResult", "result", "(Ljava/lang/Object;)V", "loadAndShow", "loadAndUpdate", "reset", "setBusy", "busy", "", "intellij.vcs.github"})
public abstract class GithubDataLoadingComponent<T>
extends Wrapper {
    private CompletableFuture<Unit> updateFuture;

    public final void loadAndShow(@Nullable CompletableFuture<T> dataRequest) {
        CompletableFuture<Unit> completableFuture = this.updateFuture;
        if (completableFuture != null) {
            completableFuture.cancel(true);
        }
        this.reset();
        this.setBusy(false);
        if (dataRequest == null) {
            this.updateFuture = null;
            return;
        }
        this.doLoadAndShow(dataRequest);
    }

    public final void loadAndUpdate(@NotNull CompletableFuture<T> dataRequest) {
        CompletableFuture<Unit> completableFuture = this.updateFuture;
        if (completableFuture != null) {
            completableFuture.cancel(true);
        }
        this.doLoadAndShow(dataRequest);
    }

    private final void doLoadAndShow(CompletableFuture<T> dataRequest) {
        this.setBusy(true);
        this.updateFuture = GithubAsyncUtilKt.handleOnEdt(dataRequest, (Function2)new Function2<T, Throwable, Unit>(this){
            final /* synthetic */ GithubDataLoadingComponent this$0;

            public final void invoke(@Nullable T result, @Nullable Throwable error) {
                if (error != null && !GithubAsyncUtil.INSTANCE.isCancellation(error)) {
                    this.this$0.handleError(error);
                } else if (result != null) {
                    this.this$0.handleResult(result);
                }
                this.this$0.setBusy(false);
            }
            {
                this.this$0 = githubDataLoadingComponent;
                super(2);
            }
        });
    }

    protected abstract void reset();

    protected abstract void handleResult(T var1);

    protected abstract void handleError(@NotNull Throwable var1);

    protected abstract void setBusy(boolean var1);
}

