/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountCombobox;

public class GithubCreateGistDialog
extends DialogWrapper {
    @Nullable
    private final JBTextField myFileNameField;
    @NotNull
    private final JTextArea myDescriptionField;
    @NotNull
    private final JBCheckBox mySecretCheckBox;
    @NotNull
    private final JBCheckBox myOpenInBrowserCheckBox;
    @NotNull
    private final JBCheckBox myCopyLinkCheckBox;
    @NotNull
    private final GithubAccountCombobox myAccountSelector;

    public GithubCreateGistDialog(@NotNull Project project, @NotNull Set<GithubAccount> accounts, @Nullable GithubAccount defaultAccount, @Nullable String fileName, boolean secret, boolean openInBrowser, boolean copyLink) {
        super(project, true);
        this.myFileNameField = fileName != null ? new JBTextField(fileName) : null;
        this.myDescriptionField = new JTextArea();
        this.mySecretCheckBox = new JBCheckBox("Secret", secret);
        this.myOpenInBrowserCheckBox = new JBCheckBox("Open in browser", openInBrowser);
        this.myCopyLinkCheckBox = new JBCheckBox("Copy URL", copyLink);
        this.myAccountSelector = new GithubAccountCombobox(accounts, defaultAccount, null);
        this.setTitle("Create Gist");
        this.init();
    }

    protected JComponent createCenterPanel() {
        JBBox checkBoxes = JBBox.createHorizontalBox();
        checkBoxes.add((Component)this.mySecretCheckBox);
        checkBoxes.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        checkBoxes.add((Component)this.myOpenInBrowserCheckBox);
        checkBoxes.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        checkBoxes.add((Component)this.myCopyLinkCheckBox);
        JBScrollPane descriptionPane = new JBScrollPane((Component)this.myDescriptionField);
        descriptionPane.setPreferredSize((Dimension)new JBDimension(270, 55));
        descriptionPane.setMinimumSize((Dimension)new JBDimension(270, 55));
        PanelGridBuilder grid = UI.PanelFactory.grid().resize();
        if (this.myFileNameField != null) {
            grid.add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myFileNameField).withLabel("Filename:"));
        }
        grid.add((PanelBuilder)UI.PanelFactory.panel((JComponent)descriptionPane).withLabel("Description:").anchorLabelOn(UI.Anchor.Top).resizeY(true)).add((PanelBuilder)UI.PanelFactory.panel((JComponent)checkBoxes));
        if (this.myAccountSelector.isEnabled()) {
            grid.add((PanelBuilder)UI.PanelFactory.panel((JComponent)((Object)this.myAccountSelector)).withLabel("Create for:").resizeX(false));
        }
        return grid.createPanel();
    }

    protected String getHelpId() {
        return "github.create.gist.dialog";
    }

    protected String getDimensionServiceKey() {
        return "Github.CreateGistDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDescriptionField;
    }

    @Nullable
    public String getFileName() {
        return this.myFileNameField != null ? this.myFileNameField.getText() : null;
    }

    @NotNull
    public String getDescription() {
        return this.myDescriptionField.getText();
    }

    public boolean isSecret() {
        return this.mySecretCheckBox.isSelected();
    }

    public boolean isOpenInBrowser() {
        return this.myOpenInBrowserCheckBox.isSelected();
    }

    public boolean isCopyURL() {
        return this.myCopyLinkCheckBox.isSelected();
    }

    @NotNull
    public GithubAccount getAccount() {
        return (GithubAccount)this.myAccountSelector.getSelectedItem();
    }
}

