/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.NumberFormatter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountsPanel;
import org.jetbrains.plugins.github.ui.GithubSettingsConfigurable;
import org.jetbrains.plugins.github.ui.GithubSettingsPanel$sam$java_util_function_BiConsumer$0;
import org.jetbrains.plugins.github.util.CachingGithubUserAvatarLoader;
import org.jetbrains.plugins.github.util.GithubImageResizer;
import org.jetbrains.plugins.github.util.GithubSettings;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u00012\u00020\u0004B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0002R\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0014\u0010\u001a\u001a\u00020\u001b2\n\u0010\u0016\u001a\u00060\u0002R\u00020\u0003H\u0016J\u0014\u0010\u001c\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0002R\u00020\u0003H\u0016J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0002J\u0014\u0010 \u001a\u00020\u0015*\u00020\u001f2\u0006\u0010!\u001a\u00020\u001eH\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/github/ui/GithubSettingsPanel;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lorg/jetbrains/plugins/github/ui/GithubSettingsConfigurable$GithubSettingsHolder;", "Lorg/jetbrains/plugins/github/ui/GithubSettingsConfigurable;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "executorFactory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "avatarLoader", "Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;", "imageResizer", "Lorg/jetbrains/plugins/github/util/GithubImageResizer;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;Lorg/jetbrains/plugins/github/util/GithubImageResizer;)V", "accountsPanel", "Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel;", "cloneUsingSshCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "timeoutField", "Ljavax/swing/JFormattedTextField;", "apply", "", "settings", "dispose", "getComponent", "Ljavax/swing/JComponent;", "isModified", "", "reset", "getConnectionTimeoutSeconds", "", "Lorg/jetbrains/plugins/github/util/GithubSettings;", "setConnectionTimeoutSeconds", "timeout", "intellij.vcs.github"})
public final class GithubSettingsPanel
implements ConfigurableUi<GithubSettingsConfigurable.GithubSettingsHolder>,
Disposable {
    private final GithubAccountsPanel accountsPanel;
    private final JFormattedTextField timeoutField;
    private final JBCheckBox cloneUsingSshCheckBox;

    /*
     * WARNING - void declaration
     */
    public void reset(@NotNull GithubSettingsConfigurable.GithubSettingsHolder settings) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)settings.getApplicationAccounts().getAccounts();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            GithubAccount githubAccount = (GithubAccount)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, (Object)settings.getApplicationAccounts().getTokenForAccount((GithubAccount)it));
            collection.add(pair);
        }
        Map accountsMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        this.accountsPanel.setAccounts(accountsMap, settings.getProjectAccount().getAccount());
        this.accountsPanel.clearNewTokens();
        this.accountsPanel.loadExistingAccountsDetails();
        this.timeoutField.setValue(this.getConnectionTimeoutSeconds(settings.getApplication()));
        this.cloneUsingSshCheckBox.setSelected(settings.getApplication().isCloneGitUsingSsh());
    }

    public boolean isModified(@NotNull GithubSettingsConfigurable.GithubSettingsHolder settings) {
        return Intrinsics.areEqual((Object)this.timeoutField.getValue(), (Object)this.getConnectionTimeoutSeconds(settings.getApplication())) ^ true || this.cloneUsingSshCheckBox.isSelected() != settings.getApplication().isCloneGitUsingSsh() || this.accountsPanel.isModified(settings.getApplicationAccounts().getAccounts(), settings.getProjectAccount().getAccount());
    }

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull GithubSettingsConfigurable.GithubSettingsHolder settings) {
        void accountsTokenMap;
        Function2 function2 = this.accountsPanel.getAccounts();
        Map map2 = (Map)function2.component1();
        GithubAccount defaultAccount = (GithubAccount)function2.component2();
        settings.getApplicationAccounts().setAccounts(accountsTokenMap.keySet());
        void $receiver$iv = accountsTokenMap;
        LinkedHashMap result$iv = new LinkedHashMap();
        void var6_6 = $receiver$iv;
        for (Map.Entry entry$iv : var6_6.entrySet()) {
            String it = (String)entry$iv.getValue();
            boolean bl = false;
            if (!(it != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        function2 = (Function2)new Function2<GithubAccount, String, Unit>(settings.getApplicationAccounts()){

            public final void invoke(@NotNull GithubAccount p1, @Nullable String p2) {
                ((GithubAccountManager)this.receiver).updateAccountToken(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(GithubAccountManager.class);
            }

            public final String getName() {
                return "updateAccountToken";
            }

            public final String getSignature() {
                return "updateAccountToken(Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Ljava/lang/String;)V";
            }
        };
        ((Map)result$iv).forEach(new GithubSettingsPanel$sam$java_util_function_BiConsumer$0(function2));
        settings.getProjectAccount().setAccount(defaultAccount);
        this.accountsPanel.clearNewTokens();
        Object object = this.timeoutField.getValue();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.setConnectionTimeoutSeconds(settings.getApplication(), (Integer)object);
        settings.getApplication().setCloneGitUsingSsh(this.cloneUsingSshCheckBox.isSelected());
    }

    private final int getConnectionTimeoutSeconds(@NotNull GithubSettings $receiver) {
        return $receiver.getConnectionTimeout() / 1000;
    }

    private final void setConnectionTimeoutSeconds(@NotNull GithubSettings $receiver, int timeout) {
        $receiver.setConnectionTimeout(timeout * 1000);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel;
        JPanel $receiver = jPanel = new JPanel();
        boolean bl = false;
        $receiver.setLayout(new BoxLayout($receiver, 0));
        $receiver.add(new JLabel("Connection timeout:"));
        $receiver.add(Box.createRigidArea((Dimension)new JBDimension(10, 0)));
        $receiver.add(this.timeoutField);
        $receiver.add(Box.createRigidArea((Dimension)new JBDimension(10, 0)));
        $receiver.add(new JLabel("seconds"));
        $receiver.setAlignmentX(0.0f);
        JPanel timeoutPanel = jPanel;
        Object object = this.cloneUsingSshCheckBox;
        PanelGridBuilder panelGridBuilder = UI.PanelFactory.grid();
        JBCheckBox $receiver2 = object;
        boolean bl2 = false;
        $receiver2.setAlignmentX(0.0f);
        JBCheckBox jBCheckBox = object;
        $receiver2 = object = panelGridBuilder.add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)jBCheckBox))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)timeoutPanel).resizeX(false)).createPanel();
        boolean bl3 = false;
        $receiver2.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        Object settingsPanel = object;
        $receiver2 = object = new JPanel();
        boolean bl4 = false;
        $receiver2.setLayout(new GridLayout(2, 1));
        $receiver2.add((Component)((Object)this.accountsPanel));
        $receiver2.add((Component)settingsPanel);
        return (JComponent)object;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.accountsPanel);
    }

    public GithubSettingsPanel(@NotNull Project project, @NotNull GithubApiRequestExecutor.Factory executorFactory, @NotNull CachingGithubUserAvatarLoader avatarLoader, @NotNull GithubImageResizer imageResizer) {
        this.accountsPanel = new GithubAccountsPanel(project, executorFactory, avatarLoader, imageResizer);
        Serializable serializable = new NumberFormatter(NumberFormat.getIntegerInstance());
        GithubSettingsPanel githubSettingsPanel = this;
        NumberFormatter $receiver = serializable;
        boolean bl = false;
        $receiver.setMinimum(Integer.valueOf(0));
        $receiver.setMaximum(Integer.valueOf(60));
        NumberFormatter numberFormatter = serializable;
        JFormattedTextField.AbstractFormatter abstractFormatter = numberFormatter;
        $receiver = serializable = new JFormattedTextField(abstractFormatter);
        boolean bl2 = false;
        ((JTextField)((Object)$receiver)).setColumns(2);
        UIUtil.fixFormattedField((JFormattedTextField)((Object)$receiver));
        Serializable serializable2 = serializable;
        githubSettingsPanel.timeoutField = serializable2;
        this.cloneUsingSshCheckBox = new JBCheckBox("Clone git repositories using ssh");
    }
}

