/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.util.GithubSettings;

@Deprecated
public class GithubAuthData {
    @NotNull
    private final AuthType myAuthType;
    @NotNull
    private final String myHost;
    @Nullable
    private final BasicAuth myBasicAuth;
    @Nullable
    private final TokenAuth myTokenAuth;
    private final boolean myUseProxy;

    private GithubAuthData(@NotNull AuthType authType, @NotNull String host, @Nullable BasicAuth basicAuth, @Nullable TokenAuth tokenAuth, boolean useProxy) {
        this.myAuthType = authType;
        this.myHost = host;
        this.myBasicAuth = basicAuth;
        this.myTokenAuth = tokenAuth;
        this.myUseProxy = useProxy;
    }

    @Deprecated
    public static GithubAuthData createAnonymous() {
        return GithubAuthData.createAnonymous(StringUtil.notNullize((String)GithubSettings.getInstance().getHost()));
    }

    public static GithubAuthData createAnonymous(@NotNull String host) {
        return new GithubAuthData(AuthType.ANONYMOUS, host, null, null, true);
    }

    public static GithubAuthData createBasicAuth(@NotNull String host, @NotNull String login2, @NotNull String password) {
        return new GithubAuthData(AuthType.BASIC, host, new BasicAuth(login2, password), null, true);
    }

    public static GithubAuthData createBasicAuthTF(@NotNull String host, @NotNull String login2, @NotNull String password, @NotNull String code) {
        return new GithubAuthData(AuthType.BASIC, host, new BasicAuth(login2, password, code), null, true);
    }

    public static GithubAuthData createTokenAuth(@NotNull String host, @NotNull String token2) {
        return new GithubAuthData(AuthType.TOKEN, host, null, new TokenAuth(token2), true);
    }

    public static GithubAuthData createTokenAuth(@NotNull String host, @NotNull String token2, boolean useProxy) {
        return new GithubAuthData(AuthType.TOKEN, host, null, new TokenAuth(token2), useProxy);
    }

    @NotNull
    public AuthType getAuthType() {
        return this.myAuthType;
    }

    @NotNull
    public String getHost() {
        return this.myHost;
    }

    @Nullable
    public BasicAuth getBasicAuth() {
        return this.myBasicAuth;
    }

    @Nullable
    public TokenAuth getTokenAuth() {
        return this.myTokenAuth;
    }

    public boolean isUseProxy() {
        return this.myUseProxy;
    }

    @NotNull
    public GithubAuthData copyWithTwoFactorCode(@NotNull String code) {
        if (this.myBasicAuth == null) {
            throw new IllegalStateException("Two factor authentication can be used only with Login/Password");
        }
        return GithubAuthData.createBasicAuthTF(this.getHost(), this.myBasicAuth.getLogin(), this.myBasicAuth.getPassword(), code);
    }

    public static class TokenAuth {
        @NotNull
        private final String myToken;

        private TokenAuth(@NotNull String token2) {
            this.myToken = StringUtil.trim((String)token2);
        }

        @NotNull
        public String getToken() {
            return this.myToken;
        }
    }

    public static class BasicAuth {
        @NotNull
        private final String myLogin;
        @NotNull
        private final String myPassword;
        @Nullable
        private final String myCode;

        private BasicAuth(@NotNull String login2, @NotNull String password) {
            this(login2, password, (String)null);
        }

        private BasicAuth(@NotNull String login2, @NotNull String password, @Nullable String code) {
            this.myLogin = login2;
            this.myPassword = password;
            this.myCode = code;
        }

        @NotNull
        public String getLogin() {
            return this.myLogin;
        }

        @NotNull
        public String getPassword() {
            return this.myPassword;
        }

        @Nullable
        public String getCode() {
            return this.myCode;
        }
    }

    public static enum AuthType {
        BASIC,
        TOKEN,
        ANONYMOUS;

    }
}

