/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubServerPath;

public class GithubUrlUtil {
    @NotNull
    public static String removeProtocolPrefix(String url) {
        int index = url.indexOf(64);
        if (index != -1) {
            return url.substring(index + 1).replace(':', '/');
        }
        index = url.indexOf("://");
        if (index != -1) {
            return url.substring(index + 3);
        }
        return url;
    }

    @NotNull
    public static String removePort(@NotNull String url) {
        int index = url.indexOf(58);
        if (index == -1) {
            return url;
        }
        int slashIndex = url.indexOf(47);
        if (slashIndex != -1 && slashIndex < index) {
            return url;
        }
        String beforePort = url.substring(0, index);
        if (slashIndex == -1) {
            return beforePort;
        }
        return beforePort + url.substring(slashIndex);
    }

    @NotNull
    public static String removeTrailingSlash(@NotNull String s) {
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    @Deprecated
    @NotNull
    public static String getApiUrl(@NotNull String urlFromSettings) {
        return GithubServerPath.from(urlFromSettings).toApiUrl();
    }

    @Nullable
    public static GithubFullPath getUserAndRepositoryFromRemoteUrl(@NotNull String remoteUrl) {
        int index1 = (remoteUrl = GithubUrlUtil.removeProtocolPrefix(GithubUrlUtil.removeEndingDotGit(remoteUrl))).lastIndexOf(47);
        if (index1 == -1) {
            return null;
        }
        String url = remoteUrl.substring(0, index1);
        int index2 = Math.max(url.lastIndexOf(47), url.lastIndexOf(58));
        if (index2 == -1) {
            return null;
        }
        String username = remoteUrl.substring(index2 + 1, index1);
        String reponame = remoteUrl.substring(index1 + 1);
        if (username.isEmpty() || reponame.isEmpty()) {
            return null;
        }
        return new GithubFullPath(username, reponame);
    }

    @NotNull
    private static String removeEndingDotGit(@NotNull String url) {
        url = GithubUrlUtil.removeTrailingSlash(url);
        String DOT_GIT = ".git";
        if (url.endsWith(".git")) {
            return url.substring(0, url.length() - ".git".length());
        }
        return url;
    }

    @Deprecated
    @NotNull
    public static String getHostFromUrl(@NotNull String url) {
        String path = GithubUrlUtil.removeProtocolPrefix(url).replace(':', '/');
        int index = path.indexOf(47);
        if (index == -1) {
            return path;
        }
        return path.substring(0, index);
    }

    @Deprecated
    @Nullable
    public static String makeGithubRepoUrlFromRemoteUrl(@NotNull String remoteUrl, @NotNull String host) {
        GithubFullPath repo = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl);
        if (repo == null) {
            return null;
        }
        return host + '/' + repo.getUser() + '/' + repo.getRepository();
    }
}

