/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AndroidOSProcessHandler
extends BaseOSProcessHandler {
    @NonNls
    private static final String IGNORING = "ignoring";
    @NonNls
    private static final String SKIPPING = "skipping";
    @NonNls
    private static final String DEBUGGABLE_ERROR = "androidmanifest.xml already defines debuggable";
    private final List<String> myInfoMessages = new ArrayList<String>();
    private final List<String> myErrorMessages = new ArrayList<String>();

    public AndroidOSProcessHandler(@NotNull Process process, @NotNull String commandLine) {
        super(process, commandLine, null);
    }

    public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
        String[] lines;
        super.notifyTextAvailable(text, outputType);
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return;
        }
        for (String line : lines = text.split("[\\n\\r]+")) {
            String l = line.toLowerCase();
            if (outputType == ProcessOutputTypes.STDOUT) {
                this.myInfoMessages.add(line);
                continue;
            }
            if (outputType != ProcessOutputTypes.STDERR) continue;
            if (l.contains(IGNORING) || l.contains(SKIPPING) || l.contains(DEBUGGABLE_ERROR)) {
                this.myInfoMessages.add(line);
                continue;
            }
            this.myErrorMessages.add(line);
        }
    }

    @NotNull
    public List<String> getInfoMessages() {
        return this.myInfoMessages;
    }

    @NotNull
    public List<String> getErrorMessages() {
        return this.myErrorMessages;
    }
}

