/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.IDEACoverageRunner;
import com.intellij.coverage.JavaCoverageEngine;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCoverageEnabledConfiguration
extends CoverageEnabledConfiguration {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration");
    private ClassFilter[] myCoveragePatterns;
    private boolean myIsMergeWithPreviousResults = false;
    private String mySuiteToMergeWith;
    @NonNls
    private static final String COVERAGE_PATTERN_ELEMENT_NAME = "pattern";
    @NonNls
    private static final String COVERAGE_MERGE_ATTRIBUTE_NAME = "merge";
    @NonNls
    private static final String COVERAGE_MERGE_SUITE_ATT_NAME = "merge_suite";
    private final JavaCoverageEngine myCoverageProvider;

    public JavaCoverageEnabledConfiguration(RunConfigurationBase configuration, JavaCoverageEngine coverageProvider) {
        super(configuration);
        this.myCoverageProvider = coverageProvider;
        this.setCoverageRunner(CoverageRunner.getInstance(IDEACoverageRunner.class));
    }

    @Nullable
    public static JavaCoverageEnabledConfiguration getFrom(@NotNull RunConfigurationBase configuration) {
        CoverageEnabledConfiguration coverageEnabledConfiguration = JavaCoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)configuration);
        if (coverageEnabledConfiguration instanceof JavaCoverageEnabledConfiguration) {
            return (JavaCoverageEnabledConfiguration)coverageEnabledConfiguration;
        }
        return null;
    }

    public void appendCoverageArgument(RunConfigurationBase configuration, SimpleJavaParameters javaParameters) {
        CoverageRunner runner = this.getCoverageRunner();
        try {
            if (runner instanceof JavaCoverageRunner) {
                String path = this.getCoverageFilePath();
                assert (path != null);
                String sourceMapPath = null;
                if (this.myCoverageProvider.isSourceMapNeeded(configuration)) {
                    sourceMapPath = JavaCoverageEnabledConfiguration.getSourceMapPath(path);
                }
                ((JavaCoverageRunner)runner).appendCoverageArgument(new File(path).getCanonicalPath(), this.getPatterns(), this.getExcludePatterns(), javaParameters, this.isTrackPerTestCoverage() && !this.isSampling(), this.isSampling(), sourceMapPath);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public static String getSourceMapPath(String coverageDataFilePath) {
        return coverageDataFilePath + ".sourceMap";
    }

    @NotNull
    public JavaCoverageEngine getCoverageProvider() {
        return this.myCoverageProvider;
    }

    @Nullable
    public ClassFilter[] getCoveragePatterns() {
        return this.myCoveragePatterns;
    }

    @Nullable
    public String[] getPatterns() {
        if (this.myCoveragePatterns != null) {
            ArrayList<String> patterns = new ArrayList<String>();
            for (ClassFilter coveragePattern : this.myCoveragePatterns) {
                if (!coveragePattern.isEnabled() || !coveragePattern.isInclude()) continue;
                patterns.add(coveragePattern.getPattern());
            }
            return ArrayUtil.toStringArray(patterns);
        }
        return null;
    }

    @Nullable
    public String[] getExcludePatterns() {
        if (this.myCoveragePatterns != null) {
            ArrayList<String> patterns = new ArrayList<String>();
            for (ClassFilter coveragePattern : this.myCoveragePatterns) {
                if (!coveragePattern.isEnabled() || coveragePattern.isInclude()) continue;
                patterns.add(coveragePattern.getPattern());
            }
            return ArrayUtil.toStringArray(patterns);
        }
        return null;
    }

    public void setCoveragePatterns(ClassFilter[] coveragePatterns) {
        this.myCoveragePatterns = coveragePatterns;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myIsMergeWithPreviousResults = Boolean.parseBoolean(element.getAttributeValue(COVERAGE_MERGE_ATTRIBUTE_NAME));
        this.mySuiteToMergeWith = element.getAttributeValue(COVERAGE_MERGE_SUITE_ATT_NAME);
        List children = element.getChildren(COVERAGE_PATTERN_ELEMENT_NAME);
        if (children.size() > 0) {
            this.myCoveragePatterns = new ClassFilter[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                Element e = (Element)children.get(i);
                this.myCoveragePatterns[i] = JavaCoverageEnabledConfiguration.createClassFilter(e);
                String val = e.getAttributeValue("value");
                if (val == null) continue;
                this.myCoveragePatterns[i].setPattern(val);
            }
        }
    }

    public static ClassFilter createClassFilter(Element element) throws InvalidDataException {
        ClassFilter filter = new ClassFilter();
        DefaultJDOMExternalizer.readExternal((Object)filter, (Element)element);
        return filter;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        IDEACoverageRunner ideaRunner;
        CoverageRunner coverageRunner;
        super.writeExternal(element);
        if (this.myIsMergeWithPreviousResults) {
            element.setAttribute(COVERAGE_MERGE_ATTRIBUTE_NAME, String.valueOf(true));
        }
        if (this.myIsMergeWithPreviousResults && this.mySuiteToMergeWith != null) {
            element.setAttribute(COVERAGE_MERGE_SUITE_ATT_NAME, this.mySuiteToMergeWith);
        }
        if ((coverageRunner = this.getCoverageRunner()) != null && (ideaRunner = (IDEACoverageRunner)((Object)CoverageRunner.EP_NAME.findExtension(IDEACoverageRunner.class))) != null && coverageRunner.getId().equals(ideaRunner.getId())) {
            element.removeAttribute("runner");
        }
        if (this.myCoveragePatterns != null) {
            for (ClassFilter pattern : this.myCoveragePatterns) {
                Element patternElement = new Element(COVERAGE_PATTERN_ELEMENT_NAME);
                pattern.writeExternal(patternElement);
                element.addContent(patternElement);
            }
        }
    }

    @Nullable
    public String getCoverageFilePath() {
        if (this.myCoverageFilePath != null) {
            return this.myCoverageFilePath;
        }
        this.myCoverageFilePath = this.createCoverageFile();
        return this.myCoverageFilePath;
    }

    public void setUpCoverageFilters(@Nullable String className, @Nullable String packageName) {
        if (this.getCoveragePatterns() == null) {
            String pattern = null;
            if (!StringUtil.isEmpty((String)className)) {
                int index = className.lastIndexOf(46);
                if (index >= 0) {
                    pattern = className.substring(0, index);
                }
            } else if (packageName != null) {
                pattern = packageName;
            }
            if (!StringUtil.isEmpty((String)pattern)) {
                this.setCoveragePatterns(new ClassFilter[]{new ClassFilter(pattern + ".*")});
            }
        }
    }
}

