/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.KnownNamespacesMap;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.google.common.base.Supplier;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\t*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u0002\u00a8\u0006\u0011"}, d2={"getConfiguredResources", "Lcom/android/ide/common/resources/ResourceValueMap;", "Lcom/android/ide/common/resources/ResourceRepository;", "namespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "type", "Lcom/android/resources/ResourceType;", "referenceConfig", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "Lcom/google/common/collect/Table;", "getConfiguredValue", "Lcom/android/ide/common/rendering/api/ResourceValue;", "name", "", "getLocales", "Ljava/util/SortedSet;", "Lcom/android/ide/common/resources/configuration/LocaleQualifier;", "android.sdktools.sdk-common"})
@JvmName(name="ResourceRepositoryUtil")
public final class ResourceRepositoryUtil {
    @NotNull
    public static final Table<ResourceNamespace, ResourceType, ResourceValueMap> getConfiguredResources(@NotNull ResourceRepository $receiver, @NotNull FolderConfiguration referenceConfig) {
        Map backingMap = KnownNamespacesMap.Companion.canContainAll((Collection<? extends ResourceNamespace>)$receiver.getNamespaces()) ? (Map)new KnownNamespacesMap() : (Map)new HashMap();
        Table result2 = Tables.newCustomTable((Map)backingMap, (Supplier)getConfiguredResources.result.1.INSTANCE);
        for (ResourceNamespace namespace : $receiver.getNamespaces()) {
            boolean bl;
            boolean bl2 = bl = $receiver.getNamespaces().size() == 1 || namespace != ResourceNamespace.ANDROID;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            for (ResourceType type : ResourceType.values()) {
                result2.put((Object)namespace, (Object)type, (Object)ResourceRepositoryUtil.getConfiguredResources($receiver, namespace, type, referenceConfig));
            }
        }
        return result2;
    }

    @NotNull
    public static final ResourceValueMap getConfiguredResources(@NotNull ResourceRepository $receiver, @NotNull ResourceNamespace namespace, @NotNull ResourceType type, @NotNull FolderConfiguration referenceConfig) {
        Map itemsByName = $receiver.getResources(namespace, type).asMap();
        ResourceValueMap result2 = ResourceValueMap.createWithExpectedSize(itemsByName.size());
        for (Collection itemGroup : itemsByName.values()) {
            ResourceValue value;
            ResourceItem match = (ResourceItem)referenceConfig.findMatchingConfigurable(itemGroup);
            if (match == null || (value = match.getResourceValue()) == null) continue;
            Map map = (Map)((Object)result2);
            String string = match.getName();
            ResourceValue resourceValue = value;
            map.put(string, resourceValue);
        }
        return result2;
    }

    @Nullable
    public static final ResourceValue getConfiguredValue(@NotNull ResourceRepository $receiver, @NotNull ResourceType type, @NotNull String name, @NotNull FolderConfiguration referenceConfig) {
        ResourceItem match;
        List<ResourceItem> items = $receiver.getResources(ResourceNamespace.TODO(), type, name);
        ResourceItem resourceItem = match = (ResourceItem)referenceConfig.findMatchingConfigurable((Collection)items);
        return resourceItem != null ? resourceItem.getResourceValue() : null;
    }

    @NotNull
    public static final SortedSet<LocaleQualifier> getLocales(@NotNull ResourceRepository $receiver) {
        TreeSet locales = new TreeSet();
        $receiver.accept(new ResourceVisitor(locales){
            final /* synthetic */ TreeSet $locales;

            @NotNull
            public final ResourceVisitor.VisitResult visit(@NotNull ResourceItem it) {
                LocaleQualifier locale = it.getConfiguration().getLocaleQualifier();
                if (locale != null) {
                    this.$locales.add(locale);
                }
                return ResourceVisitor.VisitResult.CONTINUE;
            }
            {
                this.$locales = treeSet;
            }
        });
        return locales;
    }
}

