/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.SdkConstants;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000~\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001\u001a(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007\u001a$\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001c\u001a\u001e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001cH\u0002\u001a\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u001a\u000e\u0010!\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0015\u001a\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150'\u001a,\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u00012\u0006\u0010*\u001a\u00020%2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020%0,2\u0006\u0010-\u001a\u00020%\u001a\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020\f0/2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001\u001a\u000e\u00100\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0015\u001a\u000e\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0004*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"ANDROID_UNDERSCORE_PREFIX", "", "NORMALIZED_VALUE_NAME_CHARS", "Lcom/google/common/base/CharMatcher;", "kotlin.jvm.PlatformType", "VALUE_ID_SPLITTER", "Lcom/google/common/base/Splitter;", "canonicalizeValueResourceName", "name", "failParseArrayLiteral", "", "size", "", "valuesString", "generateKeepRules", "", "manifest", "Lcom/android/ide/common/xml/ManifestData;", "isMainDex", "", "mergedResources", "Ljava/io/File;", "generateKeepRulesFromLayoutXmlFile", "", "layout", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "rules", "", "generateKeepRulesFromXmlNode", "node", "Lorg/w3c/dom/Element;", "generateMinifyKeepRules", "getPackageNameFromManifest", "manifestFile", "loadDependenciesSymbolTables", "Lcom/google/common/collect/ImmutableSet;", "Lcom/android/ide/common/symbols/SymbolTable;", "libraries", "", "mergeAndRenumberSymbols", "mainPackageName", "librarySymbols", "dependencySymbols", "", "platformSymbols", "parseArrayLiteral", "Lcom/google/common/collect/ImmutableList;", "parseManifest", "valueStringToInt", "valueString", "android.sdktools.sdk-common"})
@JvmName(name="SymbolUtils")
public final class SymbolUtils {
    private static final CharMatcher NORMALIZED_VALUE_NAME_CHARS = CharMatcher.anyOf((CharSequence)".:").precomputed();
    private static final String ANDROID_UNDERSCORE_PREFIX = "android_";
    private static final Splitter VALUE_ID_SPLITTER = Splitter.on((char)',').trimResults();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SymbolTable mergeAndRenumberSymbols(@NotNull String mainPackageName, @NotNull SymbolTable librarySymbols, @NotNull Collection<? extends SymbolTable> dependencySymbols, @NotNull SymbolTable platformSymbols) {
        Object object;
        Symbol symbol;
        ArrayList<? extends SymbolTable> tables = new ArrayList<SymbolTable>(dependencySymbols.size() + 1);
        tables.add(librarySymbols);
        tables.addAll(dependencySymbols);
        IdProvider idProvider = IdProvider.Companion.sequential();
        HashMultimap newSymbolMap = HashMultimap.create();
        HashMap arrayToAttrs = new HashMap();
        Iterable $receiver$iv = tables;
        for (Object element$iv : $receiver$iv) {
            SymbolTable table = (SymbolTable)element$iv;
            boolean bl = false;
            Iterable $receiver$iv2 = (Iterable)table.getSymbols().values();
            for (Object element$iv2 : $receiver$iv2) {
                Symbol symbol2 = (Symbol)element$iv2;
                boolean bl2 = false;
                symbol = symbol2;
                if (symbol instanceof Symbol.AttributeSymbol) {
                    newSymbolMap.put((Object)ResourceType.ATTR, (Object)symbol2.getCanonicalName());
                    continue;
                }
                if (symbol instanceof Symbol.NormalSymbol) {
                    newSymbolMap.put((Object)symbol2.getResourceType(), (Object)symbol2.getCanonicalName());
                    continue;
                }
                if (symbol instanceof Symbol.StyleableSymbol) {
                    Object object2;
                    void $receiver$iv3;
                    object = arrayToAttrs;
                    String key$iv = symbol2.getCanonicalName();
                    Object value$iv = $receiver$iv3.get(key$iv);
                    if (value$iv == null) {
                        boolean bl3 = false;
                        HashSet answer$iv = new HashSet();
                        $receiver$iv3.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    ((Set)object2).addAll((Collection)symbol2.getChildren());
                    continue;
                }
                throw (Throwable)new IOException("Unexpected symbol " + symbol2);
            }
        }
        SymbolTable.Builder tableBuilder = SymbolTable.Companion.builder().tablePackage(mainPackageName);
        HashMap attrToValue = new HashMap();
        for (ResourceType resourceType : newSymbolMap.keySet()) {
            ArrayList symbolNames = Lists.newArrayList((Iterable)newSymbolMap.get((Object)resourceType));
            CollectionsKt.sort((List)symbolNames);
            for (String symbolName : symbolNames) {
                int value = idProvider.next(resourceType);
                Symbol newSymbol = null;
                if (resourceType == ResourceType.ATTR) {
                    newSymbol = new Symbol.AttributeSymbol(symbolName, value, false, null, null, 24, null);
                    Map map = attrToValue;
                    symbol = newSymbol;
                    map.put(symbolName, symbol);
                } else {
                    int n = value;
                    symbol = null;
                    object = symbolName;
                    newSymbol = new Symbol.NormalSymbol(resourceType, symbolName, n, (ResourceVisibility)symbol, (String)object, 8, null);
                }
                tableBuilder.add(newSymbol);
            }
        }
        arrayToAttrs.forEach((BiConsumer)new BiConsumer<String, Set<String>>(platformSymbols, attrToValue, tableBuilder){
            final /* synthetic */ SymbolTable $platformSymbols;
            final /* synthetic */ HashMap $attrToValue;
            final /* synthetic */ SymbolTable.Builder $tableBuilder;

            public final void accept(@NotNull String arrayName, @NotNull Set<String> children) {
                List attributes = CollectionsKt.sorted((Iterable)children);
                ImmutableList.Builder attributeValues = ImmutableList.builder();
                for (String attribute : attributes) {
                    Symbol.AttributeSymbol symbol;
                    if (StringsKt.startsWith$default((String)attribute, (String)"android:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)attribute, (String)"android_", (boolean)false, (int)2, null)) {
                        String name;
                        String string = attribute;
                        int n = SdkConstants.ANDROID_NS_NAME_PREFIX_LEN;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                        Symbol platformSymbol = (Symbol)this.$platformSymbols.getSymbols().get((Object)ResourceType.ATTR, (Object)name);
                        if (platformSymbol != null) {
                            attributeValues.add((Object)platformSymbol.getIntValue());
                            continue;
                        }
                    }
                    if ((symbol = (Symbol.AttributeSymbol)this.$attrToValue.get(attribute)) != null) {
                        attributeValues.add((Object)symbol.getIntValue());
                        continue;
                    }
                    attributeValues.add((Object)0);
                }
                this.$tableBuilder.add(new Symbol.StyleableSymbol(arrayName, attributeValues.build(), ImmutableList.copyOf((Collection)attributes), null, arrayName, 8, null));
            }
            {
                this.$platformSymbols = symbolTable;
                this.$attrToValue = hashMap;
                this.$tableBuilder = builder;
            }
        });
        return tableBuilder.build();
    }

    @NotNull
    public static final ImmutableSet<SymbolTable> loadDependenciesSymbolTables(@NotNull Iterable<? extends File> libraries) throws IOException {
        ImmutableSet.Builder builder;
        ImmutableSet.Builder $receiver = builder = ImmutableSet.builder();
        boolean bl = false;
        for (File file : libraries) {
            $receiver.add((Object)SymbolIo.readSymbolListWithPackageName(file.toPath()));
        }
        return builder.build();
    }

    @NotNull
    public static final String getPackageNameFromManifest(@NotNull File manifestFile) throws IOException {
        ManifestData manifestData;
        try {
            manifestData = AndroidManifestParser.parse((IAbstractFile)new FileWrapper(manifestFile));
        }
        catch (SAXException e) {
            throw (Throwable)new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath() + '\'', e);
        }
        catch (IOException e) {
            throw (Throwable)new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath() + '\'', e);
        }
        ManifestData manifestData2 = manifestData;
        return manifestData2.getPackage();
    }

    @NotNull
    public static final String getPackageNameFromManifest(@NotNull ManifestData manifest) {
        return manifest.getPackage();
    }

    @NotNull
    public static final List<String> generateMinifyKeepRules(@NotNull ManifestData manifest, @Nullable File mergedResources) {
        return SymbolUtils.generateKeepRules(manifest, false, mergedResources);
    }

    @VisibleForTesting
    @NotNull
    public static final List<String> generateKeepRules(@NotNull ManifestData manifest, boolean isMainDex, @Nullable File mergedResources) {
        ArrayList<String> rules = new ArrayList<String>();
        rules.add("# Generated by the gradle plugin");
        ManifestData.KeepClass[] keepClassArray = manifest.getKeepClasses();
        int n = keepClassArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            Object object;
            ManifestData.KeepClass keepClass = keepClassArray[i];
            if (isMainDex) {
                String type = keepClass.getType();
                String process = keepClass.getProcess();
                if (!(!Intrinsics.areEqual((Object)type, (Object)"activity") && !Intrinsics.areEqual((Object)type, (Object)"service") && !Intrinsics.areEqual((Object)type, (Object)"provider") && !Intrinsics.areEqual((Object)type, (Object)"receiver") || process != null && !((object = (CharSequence)process).length() == 0) && !StringsKt.startsWith$default((String)process, (String)":", (boolean)false, (int)2, null))) continue;
            }
            File[] fileArray = StringCompanionObject.INSTANCE;
            String string2 = "-keep class %s { <init>(...); }";
            object = new Object[]{keepClass.getName()};
            ArrayList<String> arrayList = rules;
            Object object2 = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(object2, ((Object)object2).length)), (String)"java.lang.String.format(format, *args)");
            arrayList.add(string);
        }
        if (mergedResources != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                for (File typeDir : mergedResources.listFiles()) {
                    if (!typeDir.isDirectory() || !StringsKt.startsWith$default((String)typeDir.getName(), (String)"layout", (boolean)false, (int)2, null)) continue;
                    for (File layoutXml : typeDir.listFiles()) {
                        if (!layoutXml.isFile()) continue;
                        SymbolUtils.generateKeepRulesFromLayoutXmlFile(layoutXml, documentBuilder, (List<String>)rules);
                    }
                }
            }
            catch (ParserConfigurationException e) {
                throw (Throwable)new IOException("Failed to read merged resources", e);
            }
        }
        CollectionsKt.sort((List)rules);
        return rules;
    }

    public static final void generateKeepRulesFromLayoutXmlFile(@NotNull File layout, @NotNull DocumentBuilder documentBuilder, @NotNull List<String> rules) throws IOException {
        try {
            Document xmlDocument = documentBuilder.parse(layout);
            Element root = xmlDocument.getDocumentElement();
            if (root != null) {
                SymbolUtils.generateKeepRulesFromXmlNode(root, rules);
            }
        }
        catch (SAXException e) {
            throw (Throwable)new IOException("Failed to parse XML resource file " + layout.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw (Throwable)new IOException("Failed to parse XML resource file " + layout.getAbsolutePath(), e);
        }
    }

    private static final void generateKeepRulesFromXmlNode(Element node, List<String> rules) {
        String tag = node.getTagName();
        if (StringsKt.contains$default((CharSequence)tag, (CharSequence)".", (boolean)false, (int)2, null)) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "-keep class %s { <init>(...); }";
            Object[] objectArray = new Object[]{tag};
            List<String> list = rules;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            list.add(string3);
        }
        for (Node current = node.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getNodeType() != 1) continue;
            SymbolUtils.generateKeepRulesFromXmlNode((Element)current, rules);
        }
    }

    @NotNull
    public static final ManifestData parseManifest(@NotNull File manifestFile) throws IOException {
        ManifestData manifestData;
        try {
            manifestData = AndroidManifestParser.parse((IAbstractFile)new FileWrapper(manifestFile));
        }
        catch (SAXException e) {
            throw (Throwable)new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw (Throwable)new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath(), e);
        }
        return manifestData;
    }

    @NotNull
    public static final String canonicalizeValueResourceName(@NotNull String name) {
        return NORMALIZED_VALUE_NAME_CHARS.replaceFrom((CharSequence)name, '_');
    }

    public static final int valueStringToInt(@NotNull String valueString) {
        int n;
        if (StringsKt.startsWith$default((String)valueString, (String)"0x", (boolean)false, (int)2, null)) {
            String string = valueString;
            int n2 = 2;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            n = Integer.parseUnsignedInt(string3, 16);
        } else {
            n = Integer.parseInt(valueString);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ImmutableList<Integer> parseArrayLiteral(int size, @NotNull String valuesString) {
        if (size == 0) {
            if (!StringsKt.isBlank((CharSequence)valuesString.subSequence(1, valuesString.length() - 1))) {
                Void void_ = SymbolUtils.failParseArrayLiteral(size, valuesString);
                throw null;
            }
            return ImmutableList.of();
        }
        ImmutableList.Builder ints = ImmutableList.builder();
        Iterator values = VALUE_ID_SPLITTER.split(valuesString.subSequence(1, valuesString.length() - 1)).iterator();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            if (!values.hasNext()) {
                Void void_ = SymbolUtils.failParseArrayLiteral(size, valuesString);
                throw null;
            }
            ints.add((Object)SymbolUtils.valueStringToInt((String)values.next()));
            ++i;
        }
        if (values.hasNext()) {
            Void void_ = SymbolUtils.failParseArrayLiteral(size, valuesString);
            throw null;
        }
        return ints.build();
    }

    @NotNull
    public static final Void failParseArrayLiteral(int size, @NotNull String valuesString) {
        throw (Throwable)new IOException("Values string " + valuesString + " should have " + size + " item(s).");
    }
}

