/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.DocumentAccessor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public class LabelWithEditButton
extends JPanel
implements DocumentAccessor {
    private static final String EDIT_TEXT = "Edit";
    private static final String DONE_TEXT = "Done";
    private final JButton myButton = new JButton();
    private final JTextField myTextField = new JTextField(){

        @Override
        public Border getBorder() {
            return this.isEnabled() ? super.getBorder() : BorderFactory.createEmptyBorder();
        }

        @Override
        public Color getBackground() {
            return this.isEnabled() || this.getParent() == null ? super.getBackground() : this.getParent().getBackground();
        }
    };

    public LabelWithEditButton() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.myTextField);
        this.add(this.myButton);
        this.myButton.setLabel(EDIT_TEXT);
        this.myTextField.setEnabled(false);
        this.myButton.addActionListener(e -> this.toggleEdit());
        this.setFont(UIUtil.getLabelFont());
    }

    private void toggleEdit() {
        boolean isEnabled = this.myTextField.isEnabled();
        this.myButton.setLabel(isEnabled ? EDIT_TEXT : DONE_TEXT);
        this.myTextField.setEnabled(!isEnabled);
        if (!isEnabled) {
            this.myTextField.requestFocusInWindow();
        }
    }

    public void setText(@NotNull String text) {
        this.myTextField.setText(text);
    }

    @NotNull
    public String getText() {
        return this.myTextField.getText();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (font != null && this.myTextField != null) {
            this.myTextField.setFont(font);
        }
    }

    @Override
    @NotNull
    public Document getDocument() {
        return this.myTextField.getDocument();
    }
}

