/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.instructions.GapInstruction;
import com.android.tools.adtui.instructions.IconInstruction;
import com.android.tools.adtui.instructions.InstructionsRenderer;
import com.android.tools.adtui.instructions.NewRowInstruction;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class LegendComponent
extends AnimatedComponent {
    private static final int LEGEND_VERT_MARGIN_PX = JBUI.scale((int)8);
    private static final int LEGEND_HORIZ_MARGIN_PX = JBUI.scale((int)10);
    private static final int ICON_MARGIN_PX = JBUI.scale((int)6);
    private static final Map<Icon, Icon> myCroppedIconCache = new HashMap<Icon, Icon>();
    private final int myLeftPadding;
    private final int myRightPadding;
    private final int myVerticalPadding;
    private final LegendComponentModel myModel;
    private final Map<Legend, LegendConfig> myConfigs;
    private final Map<Legend, Integer> myMinWidths = new HashMap<Legend, Integer>();
    @NotNull
    private final Orientation myOrientation;
    @NotNull
    private final List<RenderInstruction> myInstructions = new ArrayList<RenderInstruction>();
    private final Map<Legend, String> myValuesCache = new HashMap<Legend, String>();

    public LegendComponent(@NotNull LegendComponentModel model2) {
        this(new Builder(model2));
    }

    private LegendComponent(@NotNull Builder builder) {
        this.myModel = builder.myModel;
        this.myConfigs = new HashMap<Legend, LegendConfig>();
        this.myOrientation = builder.myOrientation;
        this.myLeftPadding = builder.myLeftPadding;
        this.myRightPadding = builder.myRightPadding;
        this.myVerticalPadding = builder.myVerticalPadding;
        this.myModel.addDependency(this.myAspectObserver).onChange(LegendComponentModel.Aspect.LEGEND, this::modelChanged);
        this.setFont((Font)AdtUiUtils.DEFAULT_FONT.deriveFont(builder.myTextSize));
        this.modelChanged();
    }

    public void configure(@NotNull Legend legend, @NotNull LegendConfig config) {
        this.myConfigs.put(legend, config);
        this.modelChanged();
    }

    @NotNull
    public LegendComponentModel getModel() {
        return this.myModel;
    }

    @NotNull
    List<RenderInstruction> getInstructions() {
        return this.myInstructions;
    }

    @NotNull
    private LegendConfig getConfig(@NotNull Legend data) {
        LegendConfig config = this.myConfigs.get(data);
        if (config == null) {
            config = new LegendConfig(LegendConfig.IconType.NONE, Color.RED);
            this.myConfigs.put(data, config);
        }
        return config;
    }

    @Override
    public Dimension getPreferredSize() {
        InstructionsRenderer state = new InstructionsRenderer(this.myInstructions, InstructionsRenderer.HorizontalAlignment.LEFT);
        Dimension renderSize = state.getRenderSize();
        return new Dimension(renderSize.width + this.myLeftPadding + this.myRightPadding, renderSize.height + 2 * this.myVerticalPadding);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        g2d.translate(this.myLeftPadding, this.myVerticalPadding);
        InstructionsRenderer state = new InstructionsRenderer(this.myInstructions, InstructionsRenderer.HorizontalAlignment.LEFT);
        state.draw(this, g2d);
        g2d.translate(-this.myLeftPadding, -this.myVerticalPadding);
    }

    private void modelChanged() {
        boolean valuesChanged = false;
        for (Legend legend : this.myModel.getLegends()) {
            boolean isValueCached = this.myValuesCache.containsKey(legend);
            String value = legend.getValue();
            String oldValue = this.myValuesCache.put(legend, value);
            if (isValueCached && Objects.equals(value, oldValue)) continue;
            valuesChanged = true;
        }
        int cacheSize = this.myValuesCache.size();
        this.myValuesCache.keySet().retainAll(this.myModel.getLegends());
        if (this.myValuesCache.size() != cacheSize) {
            valuesChanged = true;
        }
        if (!valuesChanged) {
            return;
        }
        Dimension prevSize = this.getPreferredSize();
        this.myInstructions.clear();
        for (Legend legend : this.myModel.getLegends()) {
            String name = legend.getName();
            String value = legend.getValue();
            LegendConfig config = this.getConfig(legend);
            if (value == null) continue;
            if (legend != this.myModel.getLegends().get(0)) {
                if (this.myOrientation == Orientation.HORIZONTAL) {
                    this.myInstructions.add(new GapInstruction(LEGEND_HORIZ_MARGIN_PX));
                } else {
                    this.myInstructions.add(new NewRowInstruction(LEGEND_VERT_MARGIN_PX));
                }
            }
            if (config.getIconType() != LegendConfig.IconType.NONE) {
                int gapAdjust;
                RenderInstruction iconInstruction;
                if (config.getIconType() == LegendConfig.IconType.CUSTOM) {
                    assert (config.getIconGetter() != null);
                    iconInstruction = new IconInstruction(LegendComponent.cropAndCacheIcon(config.getIconGetter().apply(value)), 0, config.getColor());
                    gapAdjust = 0;
                } else {
                    iconInstruction = new LegendIconInstruction(config.getIconType(), config.getColor());
                    gapAdjust = this.myOrientation == Orientation.VERTICAL ? LegendIconInstruction.ICON_MAX_WIDTH - ((RenderInstruction)iconInstruction).getSize().width : 0;
                }
                this.myInstructions.add(iconInstruction);
                this.myInstructions.add(new GapInstruction(ICON_MARGIN_PX + gapAdjust));
            }
            if (!name.isEmpty() && StringUtil.isNotEmpty((String)value)) {
                name = name + ": ";
            }
            this.myInstructions.add(new TextInstruction(UIUtilities.getFontMetrics((JComponent)this, (Font)this.getFont()), name));
            if (!StringUtil.isNotEmpty((String)value)) continue;
            TextInstruction valueInstruction = new TextInstruction(UIUtilities.getFontMetrics((JComponent)this, (Font)this.getFont()), value);
            this.myInstructions.add(valueInstruction);
            if (this.myOrientation == Orientation.VERTICAL) continue;
            Integer minWidth = this.myMinWidths.getOrDefault(legend, 0);
            if (valueInstruction.getSize().width < minWidth) {
                this.myInstructions.add(new GapInstruction(minWidth - valueInstruction.getSize().width));
                continue;
            }
            this.myMinWidths.put(legend, valueInstruction.getSize().width);
        }
        if (!this.getPreferredSize().equals(prevSize)) {
            this.revalidate();
        }
        this.repaint();
    }

    static Icon cropAndCacheIcon(Icon icon) {
        if (!myCroppedIconCache.containsKey(icon)) {
            myCroppedIconCache.put(icon, IconUtil.cropIcon((Icon)icon, (int)LegendIconInstruction.ICON_MAX_WIDTH, (int)15));
        }
        return myCroppedIconCache.get(icon);
    }

    static final class LegendIconInstruction
    extends RenderInstruction {
        private static final int ICON_HEIGHT_PX = 15;
        private static final int LINE_THICKNESS = 3;
        private static final Dimension BOX_SIZE = new Dimension(11, 11);
        private static final Dimension BOX_BOUNDS = new Dimension(11, 15);
        private static final Dimension LINE_SIZE = new Dimension(12, 3);
        private static final Dimension LINE_BOUNDS = new Dimension(12, 15);
        private static final BasicStroke LINE_STROKE = new BasicStroke(3.0f);
        private static final BasicStroke DASH_STROKE = new BasicStroke(3.0f, 0, 2, 10.0f, new float[]{5.0f, 2.0f}, 0.0f);
        private static final BasicStroke BORDER_STROKE = new BasicStroke(1.0f);
        private static int ICON_MAX_WIDTH = Math.max(LegendIconInstruction.BOX_SIZE.width, LegendIconInstruction.LINE_SIZE.width);
        private static final Color BOX_BORDER_COLOR = new JBColor(new Color(0.0f, 0.0f, 0.0f, 0.1f), new Color(1.0f, 1.0f, 1.0f, 0.1f));
        @NotNull
        final LegendConfig.IconType myType;
        @NotNull
        private final Color myColor;

        public LegendIconInstruction(@NotNull LegendConfig.IconType type, @NotNull Color color) {
            switch (type) {
                case BOX: 
                case LINE: 
                case DASHED_LINE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(type.toString());
                }
            }
            this.myType = type;
            this.myColor = color;
        }

        @Override
        @NotNull
        public Dimension getSize() {
            switch (this.myType) {
                case BOX: {
                    return BOX_BOUNDS;
                }
                case LINE: 
                case DASHED_LINE: {
                    return LINE_BOUNDS;
                }
            }
            throw new IllegalStateException(this.myType.toString());
        }

        @Override
        public void render(@NotNull JComponent c, @NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Stroke prevStroke = g2d.getStroke();
            switch (this.myType) {
                case BOX: {
                    assert (LegendIconInstruction.BOX_SIZE.width <= bounds.width);
                    assert (LegendIconInstruction.BOX_SIZE.width <= bounds.height);
                    int boxX = bounds.x;
                    int boxY = bounds.y + (bounds.height - LegendIconInstruction.BOX_SIZE.height) / 2;
                    g2d.setColor(this.myColor);
                    g2d.fillRect(boxX, boxY, LegendIconInstruction.BOX_SIZE.width, LegendIconInstruction.BOX_SIZE.height);
                    g2d.setColor(BOX_BORDER_COLOR);
                    g2d.setStroke(BORDER_STROKE);
                    g2d.drawRect(boxX, boxY, LegendIconInstruction.BOX_SIZE.width - 1, LegendIconInstruction.BOX_SIZE.height - 1);
                    break;
                }
                case LINE: 
                case DASHED_LINE: {
                    assert (LegendIconInstruction.LINE_SIZE.width <= bounds.width);
                    assert (LegendIconInstruction.LINE_SIZE.height <= bounds.height);
                    g2d.setColor(this.myColor);
                    g2d.setStroke(this.myType == LegendConfig.IconType.LINE ? LINE_STROKE : DASH_STROKE);
                    int lineX = bounds.x;
                    int lineY = bounds.y + bounds.height / 2;
                    g2d.drawLine(lineX, lineY, lineX + LegendIconInstruction.LINE_SIZE.width, lineY);
                    break;
                }
                default: {
                    throw new IllegalStateException(this.myType.toString());
                }
            }
            g2d.setStroke(prevStroke);
        }
    }

    public static final class Builder {
        private static final int DEFAULT_PADDING_X_PX = JBUI.scale((int)1);
        private static final int DEFAULT_PADDING_Y_PX = JBUI.scale((int)5);
        private static final float DEFAULT_TEXT_SIZE = JBUI.scale((int)12);
        private final LegendComponentModel myModel;
        private int myLeftPadding = DEFAULT_PADDING_X_PX;
        private int myRightPadding = DEFAULT_PADDING_X_PX;
        private int myVerticalPadding = DEFAULT_PADDING_Y_PX;
        private float myTextSize = DEFAULT_TEXT_SIZE;
        private Orientation myOrientation = Orientation.HORIZONTAL;

        public Builder(@NotNull LegendComponentModel model2) {
            this.myModel = model2;
        }

        @NotNull
        public Builder setVerticalPadding(int verticalPadding) {
            this.myVerticalPadding = verticalPadding;
            return this;
        }

        @NotNull
        public Builder setLeftPadding(int leftPadding) {
            this.myLeftPadding = leftPadding;
            return this;
        }

        @NotNull
        public Builder setRightPadding(int rightPadding) {
            this.myRightPadding = rightPadding;
            return this;
        }

        @NotNull
        public Builder setHorizontalPadding(int padding) {
            this.setLeftPadding(padding);
            this.setRightPadding(padding);
            return this;
        }

        @NotNull
        public Builder setTextSize(int size) {
            this.myTextSize = size;
            return this;
        }

        @NotNull
        public Builder setOrientation(@NotNull Orientation orientation) {
            this.myOrientation = orientation;
            return this;
        }

        @NotNull
        public LegendComponent build() {
            return new LegendComponent(this);
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

