/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.RangeScrollBarUI;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.intellij.ui.components.JBScrollBar;
import java.util.concurrent.TimeUnit;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;

public class RangeTimeScrollBar
extends JBScrollBar {
    @NotNull
    private final Range myGlobalRange;
    @NotNull
    private final Range myViewRange;
    @NotNull
    private final TimeUnit myUnit;
    @NotNull
    private final AspectObserver myObserver;
    private boolean myUpdating;

    public RangeTimeScrollBar(@NotNull Range globalRange, @NotNull Range viewRange, @NotNull TimeUnit unit) {
        super(0);
        this.myGlobalRange = globalRange;
        this.myViewRange = viewRange;
        this.myUnit = unit;
        this.setUI((ScrollBarUI)((Object)new RangeScrollBarUI()));
        this.addAdjustmentListener(e -> this.updateViewRange());
        this.myObserver = new AspectObserver();
        this.myGlobalRange.addDependency(this.myObserver).onChange(Range.Aspect.RANGE, this::rangeChanged);
        this.myViewRange.addDependency(this.myObserver).onChange(Range.Aspect.RANGE, this::rangeChanged);
        this.rangeChanged();
    }

    private void rangeChanged() {
        this.myUpdating = true;
        int globalLengthMs = this.unitToMs(this.myGlobalRange.getLength());
        Range intersection = this.myGlobalRange.getIntersection(this.myViewRange);
        if (!intersection.isEmpty()) {
            int viewLengthMs = this.unitToMs(intersection.getLength());
            int viewRelativeMinMs = this.unitToMs(intersection.getMin() - this.myGlobalRange.getMin());
            this.setValues(viewRelativeMinMs, viewLengthMs, 0, globalLengthMs);
        } else {
            this.setValues(this.myViewRange.getMax() < this.myGlobalRange.getMin() ? 0 : globalLengthMs, 0, 0, globalLengthMs);
        }
        this.myUpdating = false;
    }

    private void updateViewRange() {
        if (this.myUpdating) {
            return;
        }
        int valueMs = this.getValue();
        int viewRelativeMinMs = this.unitToMs(Math.max(0.0, this.myViewRange.getMin() - this.myGlobalRange.getMin()));
        double delta = this.msToUnit(valueMs - viewRelativeMinMs);
        this.myViewRange.shift(delta);
    }

    private int unitToMs(double duration) {
        return (int)this.myUnit.toMillis((long)duration);
    }

    private double msToUnit(double duration) {
        return this.myUnit.convert((long)duration, TimeUnit.MILLISECONDS);
    }
}

