/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.google.common.collect.Maps;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class TabularLayout
implements LayoutManager2 {
    private final List<SizingRule> myColSizes;
    private final Map<Integer, SizingRule> myRowSizes = Maps.newHashMap();
    private int myVGap;
    private final Map<Component, Constraint> myConstraints = Maps.newHashMap();

    public TabularLayout(SizingRule ... colSizes) {
        this(colSizes, new SizingRule[0]);
    }

    public TabularLayout(SizingRule[] colSizes, SizingRule[] initialRowSizes) {
        this.myColSizes = Arrays.asList(colSizes);
        for (int i = 0; i < initialRowSizes.length; ++i) {
            this.setRowSizing(i, initialRowSizes[i]);
        }
    }

    public TabularLayout(String colSizesString) {
        this(TabularLayout.parseSizingRules(colSizesString));
    }

    public TabularLayout(String colSizesString, String initialRowSizesString) {
        this(TabularLayout.parseSizingRules(colSizesString), TabularLayout.parseSizingRules(initialRowSizesString));
    }

    private static SizingRule[] parseSizingRules(String colSizesString) {
        String[] sizeStrings = colSizesString.split(",");
        SizingRule[] colSizes = new SizingRule[sizeStrings.length];
        for (int i = 0; i < sizeStrings.length; ++i) {
            colSizes[i] = SizingRule.fromString(sizeStrings[i]);
        }
        return colSizes;
    }

    @NotNull
    public TabularLayout setVGap(int vGap) {
        this.myVGap = vGap;
        return this;
    }

    @NotNull
    public TabularLayout setRowSizing(int rowIndex, SizingRule rowSize) {
        this.myRowSizes.put(rowIndex, rowSize);
        return this;
    }

    public TabularLayout setRowSizing(int rowIndex, String rowSizeString) {
        return this.setRowSizing(rowIndex, SizingRule.fromString(rowSizeString));
    }

    public int getNumColumns() {
        return this.myColSizes.size();
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraint) {
        if (!(constraint instanceof Constraint)) {
            throw new IllegalArgumentException(String.format("Children of containers using %s must be added with a constraint", this.getClass().getSimpleName()));
        }
        Constraint typedConstraint = (Constraint)constraint;
        if (typedConstraint.myCol + typedConstraint.myColSpan > this.myColSizes.size()) {
            throw new IllegalArgumentException(String.format("Component added with invalid column span. col: %1$d, span: %2$d, num cols: %3$d", typedConstraint.myCol, typedConstraint.myColSpan, this.myColSizes.size()));
        }
        this.myConstraints.put(comp, (Constraint)constraint);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.myConstraints.remove(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        LayoutResult result = new LayoutResult(parent);
        int w = result.colCalculator.getTotalSize(true);
        int h = result.rowCalculator.getTotalSize(true);
        Insets insets = result.insets;
        return new Dimension(insets.left + insets.right + w, insets.top + insets.bottom + h);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        LayoutResult result = new LayoutResult(parent);
        int w = result.colCalculator.getTotalSize(false);
        int h = result.rowCalculator.getTotalSize(false);
        Insets insets = result.insets;
        return new Dimension(insets.left + insets.right + w, insets.top + insets.bottom + h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            LayoutResult result = new LayoutResult(parent);
            int numCols = result.colCalculator.getLength();
            int numRows = result.rowCalculator.getLength();
            if (numRows == 0 || numCols == 0) {
                return;
            }
            Insets insets = parent.getInsets();
            List<PosSize> rowBounds = result.rowCalculator.getBounds(insets.top, parent.getHeight() - insets.bottom - insets.top);
            List<PosSize> colBounds = result.colCalculator.getBounds(insets.left, parent.getWidth() - insets.right - insets.left);
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component comp = parent.getComponent(i);
                if (!comp.isVisible()) continue;
                int colIndex = this.myConstraints.get(comp).getCol();
                int colSpan = this.myConstraints.get(comp).getColSpan();
                int rowSpan = this.myConstraints.get(comp).getRowSpan();
                int rowIndex = this.myConstraints.get(comp).getRow();
                int totalWidth = 0;
                for (int currCol = colIndex; currCol < colIndex + colSpan; ++currCol) {
                    totalWidth += colBounds.get((int)currCol).size;
                }
                int totalHeight = 0;
                for (int currRow = rowIndex; currRow < rowIndex + rowSpan; ++currRow) {
                    totalHeight += rowBounds.get((int)currRow).size;
                }
                PosSize c = colBounds.get(colIndex);
                PosSize r = rowBounds.get(rowIndex);
                comp.setBounds(c.pos, r.pos, totalWidth, totalHeight);
            }
        }
    }

    private final class LayoutResult {
        public final Insets insets;
        public final SizeCalculator rowCalculator;
        public final SizeCalculator colCalculator;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LayoutResult(Container container) {
            ArrayList<Component> components = new ArrayList<Component>();
            int numRows = 0;
            Iterator iterator = container.getTreeLock();
            synchronized (iterator) {
                this.insets = container.getInsets();
                for (int i = 0; i < container.getComponentCount(); ++i) {
                    Component c = container.getComponent(i);
                    components.add(c);
                    numRows = Math.max(numRows, ((Constraint)TabularLayout.this.myConstraints.get(c)).getRow() + 1);
                }
            }
            this.colCalculator = new SizeCalculator(TabularLayout.this.myColSizes, 0);
            this.rowCalculator = new SizeCalculator(TabularLayout.this.myRowSizes, numRows, TabularLayout.this.myVGap);
            for (Component c : components) {
                Dimension size;
                if (!c.isVisible()) continue;
                Constraint constraint = (Constraint)TabularLayout.this.myConstraints.get(c);
                if (constraint.getColSpan() == 1) {
                    size = this.colCalculator.getComponentDimension(constraint.getCol(), c);
                    this.colCalculator.notifySize(constraint.getCol(), size.width);
                }
                if (constraint.getRowSpan() != 1) continue;
                size = this.rowCalculator.getComponentDimension(constraint.getRow(), c);
                this.rowCalculator.notifySize(constraint.getRow(), size.height);
            }
        }
    }

    private static final class PosSize {
        public int pos;
        public int size;

        private PosSize() {
        }
    }

    private static final class SizeCalculator {
        private final List<SizingRule> myRules;
        private final int myGap;
        private final List<Integer> mySizes;
        private final List<Float> myPercentages;
        private int myExtraSize;

        public SizeCalculator(Map<Integer, SizingRule> sparseRules, int numRules, int gap) {
            this(SizeCalculator.fromSparseRules(sparseRules, numRules), gap);
        }

        private static List<SizingRule> fromSparseRules(Map<Integer, SizingRule> sparseRules, int numRules) {
            for (Integer ruleIndex : sparseRules.keySet()) {
                if (ruleIndex < numRules) continue;
                numRules = ruleIndex + 1;
            }
            ArrayList<SizingRule> rules = new ArrayList<SizingRule>(numRules);
            for (int i = 0; i < numRules; ++i) {
                SizingRule rule = sparseRules.get(i);
                if (rule == null) {
                    rule = new SizingRule(SizingRule.Type.FIT, SizingRule.FitSizing.MINIMUM.ordinal());
                }
                rules.add(rule);
            }
            return rules;
        }

        public SizeCalculator(List<SizingRule> rules, int gap) {
            this.myRules = rules;
            this.myGap = gap;
            this.mySizes = Stream.generate(() -> 0).limit(rules.size()).collect(Collectors.toList());
            this.myPercentages = Stream.generate(() -> Float.valueOf(0.0f)).limit(rules.size()).collect(Collectors.toList());
            float totalProportionalSize = 0.0f;
            for (SizingRule rule : this.myRules) {
                if (rule.getType() != SizingRule.Type.PROPORTIONAL) continue;
                totalProportionalSize += (float)rule.getValue();
            }
            for (int i = 0; i < this.myRules.size(); ++i) {
                SizingRule rule;
                rule = this.myRules.get(i);
                if (rule.getType() == SizingRule.Type.PROPORTIONAL) {
                    assert (totalProportionalSize > 0.0f);
                    this.myPercentages.set(i, Float.valueOf((float)rule.getValue() / totalProportionalSize));
                    continue;
                }
                if (rule.getType() != SizingRule.Type.FIXED) continue;
                this.mySizes.set(i, JBUI.scale((int)rule.getValue()));
            }
        }

        public void notifySize(int i, int size) {
            SizingRule rule = this.myRules.get(i);
            if (rule.getType() == SizingRule.Type.FIT) {
                this.mySizes.set(i, Math.max(this.mySizes.get(i), size));
            } else if (rule.getType() == SizingRule.Type.PROPORTIONAL) {
                this.myExtraSize = Math.max(this.myExtraSize, Math.round((float)size / this.myPercentages.get(i).floatValue()));
            }
        }

        public Dimension getComponentDimension(int i, Component c) {
            SizingRule sizingRule = this.myRules.get(i);
            if (sizingRule.getValue() == SizingRule.FitSizing.PREFERRED.ordinal()) {
                return c.getPreferredSize();
            }
            return c.getMinimumSize();
        }

        public int getLength() {
            return this.mySizes.size();
        }

        public int getTotalSize(boolean includeExtraSize) {
            int totalSize = includeExtraSize ? this.myExtraSize : 0;
            for (Integer size : this.mySizes) {
                if (totalSize > 0 && size > 0) {
                    totalSize += this.myGap;
                }
                totalSize += size.intValue();
            }
            return totalSize;
        }

        public List<PosSize> getBounds(int start, int totalSpace) {
            List<PosSize> bounds = Stream.generate(() -> new PosSize()).limit(this.mySizes.size()).collect(Collectors.toList());
            if (bounds.isEmpty()) {
                return bounds;
            }
            int remainingSpace = totalSpace;
            for (int i = 0; i < this.mySizes.size(); ++i) {
                bounds.get((int)i).size = this.mySizes.get(i);
                remainingSpace -= this.mySizes.get(i).intValue();
            }
            if (remainingSpace > 0) {
                int spaceUsed = 0;
                int lastIndex = -1;
                for (int i = 0; i < this.myRules.size(); ++i) {
                    SizingRule rule = this.myRules.get(i);
                    if (rule.getType() != SizingRule.Type.PROPORTIONAL) continue;
                    bounds.get((int)i).size = Math.round((float)remainingSpace * this.myPercentages.get(i).floatValue());
                    spaceUsed += bounds.get((int)i).size;
                    lastIndex = i;
                }
                if (spaceUsed != remainingSpace && lastIndex >= 0) {
                    bounds.get((int)lastIndex).size += remainingSpace - spaceUsed;
                }
            }
            int pos = start;
            for (PosSize bound : bounds) {
                if (bound.size <= 0) continue;
                bound.pos = pos;
                pos += bound.size + this.myGap;
            }
            return bounds;
        }
    }

    public static final class Constraint {
        private final int myRow;
        private final int myCol;
        private final int myColSpan;
        private final int myRowSpan;

        public Constraint(int row, int col) {
            this(row, col, 1);
        }

        public Constraint(int row, int col, int colSpan) {
            this(row, col, 1, colSpan);
        }

        public Constraint(int row, int col, int rowSpan, int colSpan) {
            if (colSpan < 1) {
                throw new IllegalArgumentException("TabularLayout column span must be greater than 0");
            }
            this.myRow = row;
            this.myCol = col;
            this.myRowSpan = rowSpan;
            this.myColSpan = colSpan;
        }

        public int getRow() {
            return this.myRow;
        }

        public int getCol() {
            return this.myCol;
        }

        public int getRowSpan() {
            return this.myRowSpan;
        }

        public int getColSpan() {
            return this.myColSpan;
        }
    }

    public static final class SizingRule {
        private final Type myType;
        private final int myValue;

        public SizingRule(Type type, int value) {
            this.myType = type;
            this.myValue = value;
        }

        public Type getType() {
            return this.myType;
        }

        public int getValue() {
            return this.myValue;
        }

        @NotNull
        public static SizingRule fromString(@NotNull String s) throws IllegalArgumentException {
            try {
                if (s.startsWith("Fit")) {
                    return new SizingRule(Type.FIT, (s.endsWith("-") ? FitSizing.MINIMUM : FitSizing.PREFERRED).ordinal());
                }
                if (s.endsWith("px")) {
                    int value = Integer.parseInt(s.substring(0, s.length() - 2));
                    return new SizingRule(Type.FIXED, value);
                }
                if (s.equals("*")) {
                    return new SizingRule(Type.PROPORTIONAL, 1);
                }
                if (s.endsWith("*")) {
                    int value = Integer.parseInt(s.substring(0, s.length() - 1));
                    return new SizingRule(Type.PROPORTIONAL, value);
                }
                throw new IllegalArgumentException(String.format("Bad size value: \"%s\"", s));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(String.format("Bad size value: \"%s\"", s));
            }
        }

        public static enum FitSizing {
            MINIMUM,
            PREFERRED;

        }

        public static enum Type {
            FIT,
            FIXED,
            PROPORTIONAL;

        }
    }
}

