/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.actions;

import com.android.tools.adtui.actions.DropDownActionButton;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.PopupMenuListenerAdapter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DropDownAction
extends DefaultActionGroup
implements CustomComponentAction {
    private static final Icon BLANK_ICON = new Icon(){

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }
    };
    @Nullable
    private JBPopup myCurrentPopup = null;
    private boolean myActionsInitialized = false;

    public DropDownAction(@Nullable String title, @Nullable String description, @Nullable Icon icon) {
        super(title, true);
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(title);
        presentation.setDescription(description);
        if (icon != null) {
            presentation.setIcon(icon);
        } else {
            presentation.setIcon(BLANK_ICON);
            presentation.setDisabledIcon(BLANK_ICON);
        }
    }

    private void updateActionsInternal() {
        this.myActionsInitialized = true;
        this.updateActions();
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent eve) {
        DropDownActionButton button = DropDownAction.getActionButton(eve);
        if (button == null) {
            return;
        }
        this.updateActionsInternal();
        JPanel componentPopup = this.createCustomComponentPopup();
        if (componentPopup == null) {
            this.showPopupMenu(eve, button);
        } else {
            this.showJBPopup(eve, button, componentPopup);
        }
    }

    private void showPopupMenu(@NotNull AnActionEvent eve, final @NotNull DropDownActionButton button) {
        ActionManagerImpl am = (ActionManagerImpl)ActionManager.getInstance();
        JPopupMenu component = am.createActionPopupMenu(eve.getPlace(), (ActionGroup)this).getComponent();
        component.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                button.setSelected(true);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                button.setSelected(false);
            }
        });
        component.show((Component)((Object)button), 0, button.getHeight());
    }

    private void showJBPopup(@NotNull AnActionEvent eve, @NotNull DropDownActionButton button, @NotNull JPanel componentPopup) {
        JBPopup popup = this.createJBPopup(componentPopup);
        Component owner = eve.getInputEvent().getComponent();
        Point location = owner.getLocationOnScreen();
        location.translate(0, owner.getHeight());
        popup.showInScreenCoordinates(owner, location);
        ((DropDownAction)button.getAction()).myCurrentPopup = popup;
    }

    private static DropDownActionButton getActionButton(@NotNull AnActionEvent eve) {
        return (DropDownActionButton)((Object)eve.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY));
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        return new DropDownActionButton(this, presentation, "toolbar");
    }

    @NotNull
    private JBPopup createJBPopup(@NotNull JPanel content) {
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        JBPopup popupMenu = popupFactory.createComponentPopupBuilder((JComponent)content, (JComponent)content).createPopup();
        popupMenu.addListener((JBPopupListener)new JBPopupAdapter(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                super.beforeShown(event);
                DropDownActionButton button = (DropDownActionButton)((Object)event.asPopup().getOwner());
                button.setSelected(true);
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                super.onClosed(event);
                DropDownActionButton button = (DropDownActionButton)((Object)event.asPopup().getOwner());
                button.setSelected(false);
                event.asPopup().removeListener((JBPopupListener)this);
                ((DropDownAction)button.getAction()).myCurrentPopup = null;
            }
        });
        return popupMenu;
    }

    @Nullable
    protected JPanel createCustomComponentPopup() {
        return null;
    }

    protected boolean updateActions() {
        return false;
    }

    public boolean canBePerformed(@NotNull DataContext context) {
        return true;
    }

    protected boolean hasDropDownArrow() {
        if (!this.myActionsInitialized) {
            this.updateActionsInternal();
        }
        return this.getChildrenCount() > 1;
    }

    public void closePopup() {
        if (this.myCurrentPopup != null) {
            this.myCurrentPopup.closeOk(null);
            this.myCurrentPopup = null;
        }
    }
}

