/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.actions;

import com.android.tools.adtui.actions.DropDownAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.ui.JBColor;
import com.intellij.ui.TextAccessor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DropDownActionButton
extends ActionButtonWithText
implements TextAccessor {
    private static final Icon DROP_DOWN_ICON = AllIcons.General.ArrowDown;
    private static final int ICON_TEXT_SPACE = JBUI.scale((int)4);
    private static final JBInsets INSETS = JBUI.insets((int)0, (int)4, (int)0, (int)2);
    private static final int DROP_DOWN_ICON_SIZE_OFFSET = JBUI.scale((int)-8);
    private boolean myIsSelected = false;

    public DropDownActionButton(@NotNull DropDownAction action, @NotNull Presentation presentation, @NotNull String place) {
        super((AnAction)action, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        this.setForeground(JBColor.foreground());
    }

    public int getPopState() {
        return this.myIsSelected ? 1 : super.getPopState();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        if (this.shouldPaintArrow()) {
            DROP_DOWN_ICON.paintIcon((Component)((Object)this), g, this.getWidth() - DROP_DOWN_ICON.getIconWidth() - insets.right, (this.getHeight() - DROP_DOWN_ICON.getIconHeight() - insets.bottom - insets.top) / 2);
        }
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.shouldPaintArrow()) {
            return new Dimension(size.width + DROP_DOWN_ICON.getIconWidth() + DROP_DOWN_ICON_SIZE_OFFSET, size.height);
        }
        return size;
    }

    protected int iconTextSpace() {
        return ICON_TEXT_SPACE;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets.left += DropDownActionButton.INSETS.left;
        insets.right += DropDownActionButton.INSETS.right;
        return insets;
    }

    public void setSelected(boolean selected) {
        this.myIsSelected = selected;
        this.repaint();
    }

    protected int horizontalTextAlignment() {
        return 2;
    }

    public void setText(String text) {
        this.myPresentation.setText(text);
    }

    @NotNull
    public String getText() {
        return this.myPresentation.getText();
    }

    private boolean shouldPaintArrow() {
        return ((DropDownAction)this.myAction).hasDropDownArrow();
    }
}

