/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.hchart;

import com.android.tools.adtui.chart.hchart.HTreeChartReducer;
import com.android.tools.adtui.model.HNode;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class DefaultHTreeChartReducer<N extends HNode<N>>
implements HTreeChartReducer<N> {
    DefaultHTreeChartReducer() {
    }

    @Override
    public void reduce(@NotNull List<Rectangle2D.Float> rectangles, @NotNull List<N> nodes) {
        assert (nodes.size() == rectangles.size());
        int n = nodes.size();
        int index = 0;
        int keepIndex = 0;
        while (index < n) {
            Rectangle2D.Float rect = rectangles.get(index);
            HNode node = (HNode)nodes.get(index);
            if (Math.floor(rect.getMinX()) < Math.floor(rect.getMaxX())) {
                rectangles.set(keepIndex, rect);
                nodes.set(keepIndex, node);
                ++keepIndex;
                ++index;
                continue;
            }
            int pixel = (int)Math.floor(rect.getMaxX());
            int curDepth = node.getDepth();
            HNode keepNode = node;
            Rectangle2D.Float keepRect = rect;
            while (index < n) {
                rect = rectangles.get(index);
                node = (HNode)nodes.get(index);
                if (node.getDepth() != curDepth || Math.floor(rect.getMaxX()) != (double)pixel) break;
                keepRect.width = (float)(rect.getMaxX() - keepRect.getMinX());
                ++index;
            }
            rectangles.set(keepIndex, keepRect);
            nodes.set(keepIndex, keepNode);
            ++keepIndex;
        }
        rectangles.subList(keepIndex, rectangles.size()).clear();
        nodes.subList(keepIndex, nodes.size()).clear();
    }
}

