/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.hchart;

import com.android.tools.adtui.chart.hchart.DefaultHRenderer;
import com.android.tools.adtui.chart.hchart.Method;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class JavaMethodHRenderer
extends DefaultHRenderer<Method> {
    private static final Pattern dotPattern = Pattern.compile("\\.");

    protected boolean isMethodPlatform(@NotNull Method method) {
        return method.getNameSpace().startsWith("android.");
    }

    protected boolean isMethodVendor(@NotNull Method method) {
        return method.getNameSpace().startsWith("java.") || method.getNameSpace().startsWith("sun.") || method.getNameSpace().startsWith("javax.") || method.getNameSpace().startsWith("apple.") || method.getNameSpace().startsWith("com.apple.");
    }

    @Override
    protected Color getFillColor(@NotNull Method m) {
        if (this.isMethodVendor(m)) {
            return fillVendorColor;
        }
        if (this.isMethodPlatform(m)) {
            return fillPlatformColor;
        }
        return fillAppColor;
    }

    @Override
    protected String generateFittingText(@NotNull Method m, @NotNull Rectangle2D rect, @NotNull FontMetrics fontMetrics) {
        String fullyQualified = m.getNameSpace() + "." + m.getName();
        if ((double)fontMetrics.stringWidth(fullyQualified) < rect.getWidth()) {
            return fullyQualified;
        }
        String abbrevPackage = this.getShortPackageName(m.getNameSpace()) + "." + m.getName();
        if ((double)fontMetrics.stringWidth(abbrevPackage) < rect.getWidth()) {
            return abbrevPackage;
        }
        if ((double)fontMetrics.stringWidth(m.getName()) < rect.getWidth()) {
            return m.getName();
        }
        return "";
    }

    protected String getShortPackageName(String nameSpace) {
        if (nameSpace == null || nameSpace.equals("")) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        String[] elements = dotPattern.split(nameSpace);
        String separator = "";
        for (int i = 0; i < elements.length; ++i) {
            b.append(separator);
            b.append(elements[i].charAt(0));
            separator = ".";
        }
        return b.toString();
    }
}

