/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.eventrenderer;

import com.android.tools.adtui.model.event.EventAction;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EventRenderer<E> {
    public void draw(@NotNull Component var1, @NotNull Graphics2D var2, @NotNull AffineTransform var3, double var4, boolean var6, @Nullable EventAction<E> var7);

    default public void draw(@NotNull Component parent, @NotNull Graphics2D g2d, @NotNull AffineTransform transform, double length, boolean isMouseOver) {
        this.draw(parent, g2d, transform, length, isMouseOver, null);
    }

    public static ImageIcon createImageIconWithBackgroundBorder(Icon icon, int margin, Color borderColor, Graphics2D g2d) {
        BufferedImage originalImage = ImageUtil.toBufferedImage((Image)IconUtil.toImage((Icon)icon, (JBUI.ScaleContext)JBUI.ScaleContext.create((Graphics2D)g2d)));
        BufferedImage borderImage = UIUtil.createImage((Graphics)g2d, (int)(icon.getIconWidth() + margin * 2), (int)(icon.getIconHeight() + margin * 2), (int)2);
        int scaledMargin = (borderImage.getHeight() - originalImage.getHeight()) / 2;
        for (int y = 0; y < originalImage.getHeight(); ++y) {
            for (int x = 0; x < originalImage.getWidth(); ++x) {
                Color color = new Color(originalImage.getRGB(x, y), true);
                if (color.getAlpha() <= 0) continue;
                for (int ny = y - scaledMargin; ny <= y + scaledMargin; ++ny) {
                    for (int nx = x - scaledMargin; nx <= x + scaledMargin; ++nx) {
                        if ((x - nx) * (x - nx) + (y - ny) * (y - ny) > scaledMargin * scaledMargin) continue;
                        borderImage.setRGB(nx + scaledMargin, ny + scaledMargin, borderColor.getRGB());
                    }
                }
            }
        }
        Graphics2D borderGraphics = borderImage.createGraphics();
        icon.paintIcon(null, borderGraphics, margin, margin);
        return new JBImageIcon((Image)borderImage);
    }
}

