/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.eventrenderer;

import com.android.tools.adtui.eventrenderer.EventRenderer;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.KeyboardAction;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.JBFont;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyboardEventRenderer<E>
implements EventRenderer<E> {
    private static final JBFont FONT = JBFont.create((Font)new Font(null, 1, 11));
    private static final int ROUND_ARC = 5;
    private static final int POINT_HEIGHT_OFFSET = 5;
    private static final int PADDING = 2;
    private static final int BORDER_MARGIN = 2;
    private static final JBColor BACKGROUND_COLOR = new JBColor(9997198, 0x999A9A);
    private static final JBColor TEXT_COLOR = new JBColor(0xFAFAFA, 0x313335);
    private static final Map<String, Icon> KEYBOARD_ICON_LOOKUP;
    private static final Map<KeyboardIconCacheKey, Icon> BORDERED_KEYBOARD_ICON_CACHE;

    @Override
    public void draw(@NotNull Component parent, @NotNull Graphics2D g2d, @NotNull AffineTransform transform, double length, boolean isMouseOver, @Nullable EventAction<E> action) {
        boolean drawString;
        if (!(action instanceof KeyboardAction)) {
            return;
        }
        KeyboardAction keyAction = (KeyboardAction)action;
        boolean bl = drawString = !KEYBOARD_ICON_LOOKUP.containsKey(keyAction.getData().toString());
        if (drawString) {
            this.drawString(parent, g2d, transform, keyAction);
        } else {
            this.drawIcon(parent, g2d, transform, keyAction);
        }
    }

    private void drawString(Component parent, Graphics2D g2d, AffineTransform transform, KeyboardAction action) {
        Color currentColor = g2d.getColor();
        Font currentFont = g2d.getFont();
        AffineTransform originalTransform = g2d.getTransform();
        g2d.setFont((Font)FONT);
        FontMetrics metrics = g2d.getFontMetrics();
        String textToDraw = action.getData().toString();
        int width = metrics.stringWidth(textToDraw);
        int height = metrics.getHeight();
        int paddedHeight = height + 2;
        int pointWidth = width + 5;
        transform.translate((double)(-width) / 2.0, 0.0);
        g2d.transform(transform);
        for (int margin : Arrays.asList(2, 0)) {
            g2d.setColor((Color)(margin == 0 ? BACKGROUND_COLOR : parent.getBackground()));
            Polygon polygon = new Polygon();
            polygon.addPoint(-2 - margin, paddedHeight);
            polygon.addPoint(pointWidth + margin, paddedHeight);
            polygon.addPoint(pointWidth / 2, paddedHeight + 5 + margin);
            g2d.fillRoundRect(-2 - margin, 2 - margin, width + 2 + 5 + margin * 2, height + 2 + margin * 2, 5, 5);
            g2d.fillPolygon(polygon);
        }
        g2d.setColor((Color)TEXT_COLOR);
        g2d.drawString(textToDraw, 1, height);
        g2d.setColor(currentColor);
        g2d.setFont(currentFont);
        g2d.setTransform(originalTransform);
    }

    private void drawIcon(Component parent, Graphics2D g2d, AffineTransform transform, KeyboardAction action) {
        Icon icon = BORDERED_KEYBOARD_ICON_CACHE.computeIfAbsent(new KeyboardIconCacheKey(action.getData().toString(), parent.getBackground(), 2), key -> EventRenderer.createImageIconWithBackgroundBorder(KEYBOARD_ICON_LOOKUP.get(action.getData().toString()), 2, parent.getBackground(), g2d));
        AffineTransform originalTransform = g2d.getTransform();
        g2d.transform(transform);
        icon.paintIcon(parent, g2d, -icon.getIconWidth() / 2, 0);
        g2d.setTransform(originalTransform);
    }

    static {
        BORDERED_KEYBOARD_ICON_CACHE = new HashMap();
        HashMap keyboardIcons = new HashMap();
        keyboardIcons.put("KEYCODE_BACK", StudioIcons.Profiler.Events.BACK_BUTTON);
        keyboardIcons.put("KEYCODE_VOLUME_DOWN", StudioIcons.Profiler.Events.VOLUME_DOWN);
        keyboardIcons.put("KEYCODE_VOLUME_UP", StudioIcons.Profiler.Events.VOLUME_UP);
        KEYBOARD_ICON_LOOKUP = keyboardIcons;
    }

    private static class KeyboardIconCacheKey {
        @NotNull
        private final String myKeyString;
        @NotNull
        private final Color myBackgroundColor;
        private final int myBorderMargin;

        public KeyboardIconCacheKey(@NotNull String string, @NotNull Color color, int margin) {
            this.myKeyString = string;
            this.myBackgroundColor = color;
            this.myBorderMargin = margin;
        }

        public boolean equals(Object obj) {
            if (obj instanceof KeyboardIconCacheKey) {
                KeyboardIconCacheKey key = (KeyboardIconCacheKey)obj;
                return this.myKeyString.equals(key.myKeyString) && this.myBackgroundColor.equals(key.myBackgroundColor) && this.myBorderMargin == key.myBorderMargin;
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(new int[]{this.myKeyString.hashCode(), this.myBackgroundColor.hashCode(), this.myBorderMargin});
        }
    }
}

