/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.instructions;

import com.android.tools.adtui.instructions.InstructionsRenderer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class RenderInstruction {
    @NotNull
    private static final Dimension EMPTY_SIZE = new Dimension();
    @NotNull
    protected static final Consumer<MouseEvent> EMPTY_CONSUMER = evt -> {};
    @NotNull
    private Consumer<MouseEvent> myMouseHandler = EMPTY_CONSUMER;

    @NotNull
    public Dimension getSize() {
        return EMPTY_SIZE;
    }

    public void setMouseHandler(@NotNull Consumer<MouseEvent> mouseHandler) {
        this.myMouseHandler = mouseHandler;
    }

    public void moveCursor(@NotNull InstructionsRenderer renderer, @NotNull Point cursor) {
        Dimension size = this.getSize();
        cursor.x += size.width;
    }

    public void render(@NotNull JComponent c, @NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
    }

    @NotNull
    public Rectangle getBounds(@NotNull InstructionsRenderer renderer, @NotNull Point cursor) {
        return new Rectangle(cursor.x, cursor.y, this.getSize().width, renderer.getRowHeight());
    }

    final void handleMouseEvent(@NotNull MouseEvent evt) {
        this.myMouseHandler.accept(evt);
    }
}

